/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.mod.client;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import latmod.core.InvUtils;
import latmod.core.LatCoreMC;
import latmod.core.ODItems;
import latmod.core.client.playerdeco.PDFTB;
import latmod.core.client.playerdeco.PDLatMod;
import latmod.core.client.playerdeco.PlayerDecorator;
import latmod.core.client.playerdeco.ThreadCheckPlayerDecorators;
import latmod.core.event.LoadLMIconsEvent;
import latmod.core.event.ReloadEvent;
import latmod.core.gui.GuiLM;
import latmod.core.mod.LC;
import latmod.core.mod.LCConfig;
import latmod.core.mod.client.GuiFriends;
import latmod.core.mod.client.GuiNotification;
import latmod.core.mod.client.LCClient;
import latmod.core.tile.IPaintable;
import latmod.core.util.FastList;
import latmod.core.util.FastMap;
import latmod.core.util.LatCore;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

@SideOnly(value=Side.CLIENT)
public class LCClientEventHandler {
    public static final LCClientEventHandler instance = new LCClientEventHandler();
    public final FastList<GuiNotification> messages = new FastList();
    public final FastMap<UUID, FastList<PlayerDecorator>> playerDecorators = new FastMap();
    public final FastList<UUID> listLatMod = new FastList();
    public final FastList<UUID> listFTB = new FastList();

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent e) {
        FastList<String> ores;
        ItemStack paint;
        if (e.itemStack == null || e.itemStack.func_77973_b() == null) {
            return;
        }
        Item item = e.itemStack.func_77973_b();
        if (item instanceof IPaintable.IPainterItem && (paint = ((IPaintable.IPainterItem)item).getPaintItem(e.itemStack)) != null) {
            e.toolTip.add(EnumChatFormatting.WHITE + "" + EnumChatFormatting.BOLD + paint.func_82833_r());
        }
        if (LCConfig.Client.addRegistryNames) {
            e.toolTip.add(InvUtils.getRegName(e.itemStack));
        }
        if (LCConfig.Client.addOreNames && (ores = ODItems.getOreNames(e.itemStack)) != null && !ores.isEmpty()) {
            e.toolTip.add("Ore Dictionary names:");
            for (String or : ores) {
                e.toolTip.add("> " + or);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void preTexturesLoaded(TextureStitchEvent.Pre e) {
        if (e.map.func_130086_a() == 0) {
            LatCoreMC.blockNullIcon = e.map.func_94245_a(LC.mod.assets + "nullIcon");
        } else if (e.map.func_130086_a() == 1) {
            LatCoreMC.unknownItemIcon = e.map.func_94245_a(LC.mod.assets + "unknown");
        }
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Specials.Post e) {
        if (LCConfig.Client.enablePlayerDecorators && !e.entityPlayer.func_82150_aj()) {
            FastList<PlayerDecorator> l;
            UUID id = e.entityPlayer.func_110124_au();
            if (this.listLatMod.contains(id)) {
                PDLatMod.instance.onPlayerRender(e);
            }
            if (this.listFTB.contains(id)) {
                PDFTB.instance.onPlayerRender(e);
            }
            if ((l = this.playerDecorators.get(id)) != null && l.size() > 0) {
                for (int i = 0; i < l.size(); ++i) {
                    l.get(i).onPlayerRender(e);
                }
            }
        }
    }

    @SubscribeEvent
    public void onReload(ReloadEvent r) {
        if (r.side.isClient()) {
            ThreadCheckPlayerDecorators.init();
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent e) {
        EntityPlayer ep;
        if (LCClient.key.func_151468_f() && LC.proxy.inGameHasFocus() && (ep = LC.proxy.getClientPlayer()) != null && ep.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiFriends(ep));
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && event.phase == TickEvent.Phase.END && !this.messages.isEmpty()) {
            GuiNotification m = this.messages.get(0);
            m.render(mc);
            if (m.isDead()) {
                this.messages.remove(0);
            }
        }
    }

    @SubscribeEvent
    public void onIconsLoaded(TextureStitchEvent.Pre e) {
        if (e.map.func_130086_a() == 1) {
            LoadLMIconsEvent ev = new LoadLMIconsEvent(e.map);
            GuiLM.Icons.load(ev);
            ev.post();
        }
    }

    @SubscribeEvent
    public void onDrawDebugText(RenderGameOverlayEvent.Text event) {
        boolean shift = LC.proxy.isShiftDown();
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71474_y.field_74330_P) {
            if (LatCoreMC.isDevEnv) {
                event.left.add("[LatCoreMC] Dev version!");
            }
        } else if (LCConfig.Client.displayDebugInfo) {
            event.right.add(null);
            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                int i;
                Class<?>[] bInts;
                int x = mc.field_71476_x.field_72311_b;
                int y = mc.field_71476_x.field_72312_c;
                int z = mc.field_71476_x.field_72309_d;
                Block block = mc.field_71441_e.func_147439_a(x, y, z);
                int meta = mc.field_71441_e.func_72805_g(x, y, z);
                TileEntity te = mc.field_71441_e.func_147438_o(x, y, z);
                event.right.add(shift ? LatCore.classpath(block.getClass()) : InvUtils.getRegName(block) + (meta > 0 ? ";" + meta : "") + " @ " + LatCore.stripInt(x, y, z));
                if (shift && (bInts = block.getClass().getInterfaces()).length > 0) {
                    event.right.add(null);
                    for (i = 0; i < bInts.length; ++i) {
                        event.right.add(LatCore.classpath(bInts[i]) + "  <");
                    }
                }
                if (te != null) {
                    Class<?>[] tInts;
                    event.right.add(null);
                    event.right.add("Tile: " + LatCore.classpath(te.getClass()));
                    if (shift && (tInts = te.getClass().getInterfaces()).length > 0) {
                        event.right.add(null);
                        for (i = 0; i < tInts.length; ++i) {
                            event.right.add(LatCore.classpath(tInts[i]) + "  <");
                        }
                    }
                }
            }
        }
    }
}

