/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.mod.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.ILMGuiHandler;
import latmod.core.LMPlayer;
import latmod.core.LatCoreMC;
import latmod.core.Notification;
import latmod.core.client.playerdeco.ThreadCheckPlayerDecorators;
import latmod.core.event.LMPlayerClientEvent;
import latmod.core.mod.LCCommon;
import latmod.core.mod.client.GuiNotification;
import latmod.core.mod.client.LCClientEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class LCClient
extends LCCommon {
    public static KeyBinding key;

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        LatCoreMC.addEventHandler(LCClientEventHandler.instance, true, true, true);
        ThreadCheckPlayerDecorators.init();
        key = LatCoreMC.addKeyBinding("key.latcoremc", 41, "key.categories.gameplay");
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
    }

    @Override
    public boolean isShiftDown() {
        return GuiScreen.func_146272_n();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiScreen.func_146271_m();
    }

    @Override
    public boolean isTabDown() {
        return Keyboard.isKeyDown((int)15);
    }

    @Override
    public boolean inGameHasFocus() {
        return Minecraft.func_71410_x().field_71415_G;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getWorldClient();
    }

    @Override
    public double getReachDist(EntityPlayer ep) {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    public static ResourceLocation getSkinTexture(String username) {
        ResourceLocation r = AbstractClientPlayer.func_110311_f((String)username);
        AbstractClientPlayer.func_110304_a((ResourceLocation)r, (String)username);
        return r;
    }

    @Override
    public void notifyPlayer(Notification n) {
        LCClientEventHandler.instance.messages.add(new GuiNotification(n));
    }

    @Override
    public void spawnDust(World w, double x, double y, double z, int col) {
        EntityReddustFX fx = new EntityReddustFX(w, x, y, z, 0.0f, 0.0f, 0.0f);
        float alpha = (float)(col >> 24 & 0xFF) / 255.0f;
        float red = (float)(col >> 16 & 0xFF) / 255.0f;
        float green = (float)(col >> 8 & 0xFF) / 255.0f;
        float blue = (float)(col >> 0 & 0xFF) / 255.0f;
        fx.func_70538_b(red, green, blue);
        fx.func_82338_g(alpha);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    public void playerLMLoggedIn(LMPlayer p) {
        new LMPlayerClientEvent.LoggedIn(p, p.getPlayerSP()).post();
    }

    @Override
    public void playerLMLoggedOut(LMPlayer p) {
        new LMPlayerClientEvent.LoggedOut(p, p.getPlayerSP()).post();
    }

    @Override
    public void playerLMDataChanged(LMPlayer p, String action) {
        new LMPlayerClientEvent.DataChanged(p, action);
    }

    @Override
    public void openClientGui(EntityPlayer ep, String id, NBTTagCompound data) {
        GuiScreen g;
        ILMGuiHandler h = LatCoreMC.getLMGuiHandler(id);
        if (h != null && (g = h.getGui(ep, id, data)) != null) {
            Minecraft.func_71410_x().func_147108_a(g);
        }
    }
}

