/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.mod;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.File;
import latmod.core.IServerConfig;
import latmod.core.LMPlayer;
import latmod.core.LMSecurity;
import latmod.core.LatCoreMC;
import latmod.core.NBTHelper;
import latmod.core.event.EventLM;
import latmod.core.event.LMPlayerEvent;
import latmod.core.event.LoadLMDataEvent;
import latmod.core.event.SaveLMDataEvent;
import latmod.core.mod.LCConfig;
import latmod.core.mod.LMDataLoader;
import latmod.core.net.MessageLM;
import latmod.core.net.MessageLMPlayerLoggedIn;
import latmod.core.net.MessageLMPlayerLoggedOut;
import latmod.core.net.MessageUpdateAllData;
import latmod.core.tile.ISecureTile;
import latmod.core.util.FastList;
import latmod.core.util.LatCore;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;

public class LCEventHandler {
    public static final LCEventHandler instance = new LCEventHandler();

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        LMPlayer p = LMPlayer.getPlayer(e.player);
        boolean first = p == null;
        boolean sendAll = false;
        String cmdName = e.player.func_70005_c_();
        if (first) {
            p = new LMPlayer(LMDataLoader.nextPlayerID(), e.player.func_110124_au(), cmdName);
            LMPlayer.map.put(p.playerID, p);
        } else if (!p.username.equals(cmdName)) {
            p = new LMPlayer(p.playerID, e.player.func_110124_au(), cmdName);
            LMPlayer.map.put(p.playerID, p);
            sendAll = true;
        }
        p.setOnline(true);
        new LMPlayerEvent.LoggedIn(p, (EntityPlayerMP)e.player, first).post();
        this.updateAllData(sendAll ? null : (EntityPlayerMP)e.player);
        MessageLM.NET.sendToAll((IMessage)new MessageLMPlayerLoggedIn(p));
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        LMPlayer p = LMPlayer.getPlayer(e.player);
        if (p != null && e.player instanceof EntityPlayerMP) {
            p.setOnline(false);
            for (int i = 0; i < 4; ++i) {
                p.lastArmor[i] = e.player.field_71071_by.field_70460_b[i];
            }
            p.lastArmor[4] = e.player.field_71071_by.func_70448_g();
            new LMPlayerEvent.LoggedOut(p, (EntityPlayerMP)e.player).post();
            MessageLM.NET.sendToAll((IMessage)new MessageLMPlayerLoggedOut(p));
        }
    }

    @SubscribeEvent
    public void worldLoaded(WorldEvent.Load e) {
        if (LatCoreMC.isServer() && e.world.field_73011_w.field_76574_g == 0) {
            IServerConfig.Registry.load();
            LoadLMDataEvent e1 = new LoadLMDataEvent(new File(e.world.func_72860_G().func_75765_b(), "latmod/"), EventLM.Phase.PRE);
            e1.post();
            NBTTagCompound tag = NBTHelper.readMap(e1.getFile("LMPlayers.dat"));
            if (tag != null) {
                if (tag.func_74764_b("Players")) {
                    LMDataLoader.lastPlayerID = tag.func_74762_e("LastID");
                    LMDataLoader.readPlayersFromNBT(tag.func_74775_l("Players"), true);
                } else {
                    LMDataLoader.readPlayersFromNBT(tag, true);
                    NBTTagCompound common = NBTHelper.readMap(e1.getFile("CommonData.dat"));
                    if (common != null) {
                        LMDataLoader.lastPlayerID = common.func_74762_e("LastPlayerID");
                        e1.getFile("CommonData.dat").delete();
                    }
                }
            }
            for (int i = 0; i < LMPlayer.map.values.size(); ++i) {
                ((LMPlayer)LMPlayer.map.values.get(i)).setOnline(false);
            }
            new LoadLMDataEvent(e1.latmodFolder, EventLM.Phase.POST).post();
            LatCoreMC.logger.info("LatCoreMC data loaded");
        }
    }

    @SubscribeEvent
    public void worldSaved(WorldEvent.Save e) {
        if (LatCoreMC.isServer() && e.world.field_73011_w.field_76574_g == 0) {
            SaveLMDataEvent e1 = new SaveLMDataEvent(new File(e.world.func_72860_G().func_75765_b(), "latmod/"));
            e1.post();
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound players = new NBTTagCompound();
            LMDataLoader.writePlayersToNBT(players, true);
            tag.func_74782_a("Players", (NBTBase)players);
            tag.func_74768_a("LastID", LMDataLoader.lastPlayerID);
            NBTHelper.writeMap(e1.getFile("LMPlayers.dat"), tag);
            try {
                FastList<String> l = new FastList<String>();
                FastList<Object> list = new FastList<Object>();
                list.addAll(LMPlayer.map.keys);
                list.sort(null);
                for (int i = 0; i < list.size(); ++i) {
                    LMPlayer p = LMPlayer.getPlayer(list.get(i));
                    String id = LatCore.fillString("" + p.playerID, ' ', 6);
                    String u = LatCore.fillString(p.username, ' ', 21);
                    String s = "" + p.uuid;
                    l.add(id + u + s);
                }
                LatCore.saveFile(new File(e.world.func_72860_G().func_75765_b(), "latmod/LMPlayers.txt"), l);
            }
            catch (Exception ex) {
                LatCoreMC.logger.warn("Error occured while saving LatCoreMC.dat!");
                ex.printStackTrace();
            }
        }
    }

    public void updateAllData(EntityPlayerMP ep) {
        if (ep != null) {
            MessageLM.NET.sendTo((IMessage)new MessageUpdateAllData(), ep);
        } else {
            MessageLM.NET.sendToAll((IMessage)new MessageUpdateAllData());
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.modID.equalsIgnoreCase("LatCoreMC")) {
            LCConfig.instance.load();
        }
    }

    @SubscribeEvent
    public void onBlockClick(PlayerInteractEvent e) {
        if (e.world.field_72995_K) {
            return;
        }
        if (e.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (!this.canInteract(e)) {
            e.setCanceled(true);
        }
    }

    private boolean canInteract(PlayerInteractEvent e) {
        LMSecurity s;
        if (e.entityPlayer.field_71075_bZ.field_75098_d && LCConfig.General.allowCreativeInteractSecure) {
            return true;
        }
        TileEntity te = e.world.func_147438_o(e.x, e.y, e.z);
        return te == null || te.func_145837_r() || !(te instanceof ISecureTile) || (s = ((ISecureTile)te).getSecurity()) == null || s.level.isPublic() || s.owner == null || s.canInteract(e.entityPlayer);
    }
}

