/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.client.LMRenderHelper;
import latmod.core.event.LoadLMIconsEvent;
import latmod.core.gui.ContainerLM;
import latmod.core.gui.WidgetLM;
import latmod.core.mod.LC;
import latmod.core.mod.client.LCClient;
import latmod.core.util.FastList;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiLM
extends GuiContainer {
    public final ContainerLM container;
    public final ResourceLocation texture;
    public final FastList<WidgetLM> widgets;

    public GuiLM(ContainerLM c, ResourceLocation tex) {
        super((Container)c);
        LC.mod.getLocation("textures/gui/icons/button.png");
        this.container = c;
        this.texture = tex;
        this.widgets = new FastList();
    }

    public ItemStack getHeldItem() {
        return this.container.player.field_71071_by.func_70445_o();
    }

    public final int getPosX() {
        return this.field_147003_i;
    }

    public final int getPosY() {
        return this.field_147009_r;
    }

    public final float getZLevel() {
        return this.field_73735_i;
    }

    public final void setZLevel(float z) {
        this.field_73735_i = z;
    }

    public final void setTexture(ResourceLocation tex) {
        this.field_146297_k.func_110434_K().func_110577_a(tex);
    }

    protected void func_73864_a(int mx, int my, int b) {
        int i;
        for (i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).voidMousePressed(mx, my, b);
        }
        for (i = 0; i < this.widgets.size(); ++i) {
            if (!this.widgets.get(i).mousePressed(mx, my, b)) continue;
            return;
        }
        super.func_73864_a(mx, my, b);
    }

    protected void func_73869_a(char keyChar, int key) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            if (!this.widgets.get(i).keyPressed(key, keyChar)) continue;
            return;
        }
        super.func_73869_a(keyChar, key);
    }

    public void func_146976_a(float f, int mx, int my) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        LMRenderHelper.recolor();
        this.setTexture(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73863_a(int mx, int my, float f) {
        super.func_73863_a(mx, my, f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        this.drawText(mx, my);
        GL11.glDisable((int)2896);
    }

    public void drawText(int mx, int my) {
        FastList<String> l = new FastList<String>();
        this.addMouseText(mx, my, l);
        for (int i = 0; i < this.widgets.size(); ++i) {
            WidgetLM w = this.widgets.get(i);
            if (!w.mouseOver(mx, my)) continue;
            w.addMouseOverText(l);
        }
        if (!l.isEmpty()) {
            this.drawHoveringText(l, mx, my, this.field_146289_q);
        }
    }

    public void addMouseText(int mx, int my, FastList<String> l) {
    }

    public void drawWrappedIcon(IIcon i, float x, float y, float w, float h) {
        float minU = i.func_94209_e();
        float minV = i.func_94206_g();
        float maxU = i.func_94212_f();
        float maxV = i.func_94210_h();
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78374_a((double)(x + 0.0f), (double)(y + h), (double)this.field_73735_i, (double)minU, (double)maxV);
        t.func_78374_a((double)(x + w), (double)(y + h), (double)this.field_73735_i, (double)maxU, (double)maxV);
        t.func_78374_a((double)(x + w), (double)(y + 0.0f), (double)this.field_73735_i, (double)maxU, (double)minV);
        t.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), (double)this.field_73735_i, (double)minU, (double)minV);
        t.func_78381_a();
    }

    public void func_73729_b(int x, int y, int u, int v, int w, int h) {
        this.drawTexturedModalRectD(x, y, u, v, w, h);
    }

    public void drawTexturedModalRectD(double x, double y, double u, double v, double w, double h) {
        double scX = 0.00390625;
        double scY = 0.00390625;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + h, (double)this.field_73735_i, (u + 0.0) * scX, (v + h) * scY);
        tessellator.func_78374_a(x + w, y + h, (double)this.field_73735_i, (u + w) * scX, (v + h) * scY);
        tessellator.func_78374_a(x + w, y + 0.0, (double)this.field_73735_i, (u + w) * scX, (v + 0.0) * scY);
        tessellator.func_78374_a(x + 0.0, y + 0.0, (double)this.field_73735_i, (u + 0.0) * scX, (v + 0.0) * scY);
        tessellator.func_78381_a();
    }

    public void playSoundFX(String s, float pitch) {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(s), (float)pitch));
    }

    public void playClickSound() {
        this.playSoundFX("gui.button.press", 1.0f);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void drawPlayerHead(String username, double x, double y, double w, double h) {
        this.setTexture(LCClient.getSkinTexture(username));
        Tessellator tessellator = Tessellator.field_78398_a;
        double minU = 0.125;
        double minV = 0.25;
        double maxU = 0.25;
        double maxV = 0.5;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + h, (double)this.field_73735_i, minU, maxV);
        tessellator.func_78374_a(x + w, y + h, (double)this.field_73735_i, maxU, maxV);
        tessellator.func_78374_a(x + w, y + 0.0, (double)this.field_73735_i, maxU, minV);
        tessellator.func_78374_a(x + 0.0, y + 0.0, (double)this.field_73735_i, minU, minV);
        tessellator.func_78381_a();
        double minU2 = 0.625;
        double minV2 = 0.25;
        double maxU2 = 0.75;
        double maxV2 = 0.5;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + h, (double)this.field_73735_i, minU2, maxV2);
        tessellator.func_78374_a(x + w, y + h, (double)this.field_73735_i, maxU2, maxV2);
        tessellator.func_78374_a(x + w, y + 0.0, (double)this.field_73735_i, maxU2, minV2);
        tessellator.func_78374_a(x + 0.0, y + 0.0, (double)this.field_73735_i, minU2, minV2);
        tessellator.func_78381_a();
    }

    public static class Icons {
        public static IIcon button;
        public static IIcon pressed;
        public static IIcon toggle_off;
        public static IIcon toggle_on;
        public static IIcon help;
        public static IIcon settings;
        public static IIcon up;
        public static IIcon down;
        public static IIcon left;
        public static IIcon right;
        public static IIcon accept;
        public static IIcon accept_gray;
        public static IIcon back;
        public static IIcon cancel;
        public static IIcon add;
        public static IIcon remove;
        public static final IIcon[] security;
        public static IIcon security_whitelist;
        public static IIcon security_blacklist;
        public static final IIcon[] inv;
        public static final IIcon[] redstone;

        public static void load(LoadLMIconsEvent e) {
            button = e.load("button");
            pressed = e.load("pressed");
            toggle_off = e.load("toggle_off");
            toggle_on = e.load("toggle_on");
            help = e.load("help");
            settings = e.load("settings");
            up = e.load("arrows/up");
            down = e.load("arrows/down");
            left = e.load("arrows/left");
            right = e.load("arrows/right");
            accept = e.load("accept");
            accept_gray = e.load("accept_gray");
            back = left;
            cancel = e.load("cancel");
            add = e.load("add");
            remove = e.load("remove");
            Icons.security[0] = e.load("security/public");
            Icons.security[1] = e.load("security/private");
            Icons.security[2] = e.load("security/friends");
            Icons.security[3] = e.load("security/group");
            security_blacklist = e.load("security/black");
            security_whitelist = e.load("security/white");
            Icons.inv[0] = e.load("inv/io");
            Icons.inv[1] = e.load("inv/in");
            Icons.inv[2] = e.load("inv/out");
            Icons.inv[3] = e.load("inv/off");
            Icons.redstone[0] = e.load("rs/off");
            Icons.redstone[1] = e.load("rs/high");
            Icons.redstone[2] = e.load("rs/low");
            Icons.redstone[3] = e.load("rs/pulse");
            Friends.load(e);
        }

        static {
            security = new IIcon[4];
            inv = new IIcon[4];
            redstone = new IIcon[4];
        }

        public static class Friends {
            public static IIcon add;
            public static IIcon remove;
            public static IIcon groups;
            public static IIcon view;
            public static IIcon online;

            public static void load(LoadLMIconsEvent e) {
                add = e.load("friends/add");
                remove = e.load("friends/remove");
                groups = e.load("friends/groups");
                view = e.load("friends/view");
                online = e.load("friends/online");
            }
        }
    }
}

