/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.cmd;

import java.util.Arrays;
import java.util.List;
import latmod.core.LMPlayer;
import latmod.core.LatCoreMC;
import latmod.core.cmd.MissingArgsException;
import latmod.core.util.LatCore;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;

public abstract class CommandLM
extends CommandBase {
    protected static final String FINE = EnumChatFormatting.WHITE + "";
    public final String commandName;

    public CommandLM(String s) {
        this.commandName = s;
    }

    public final String func_71517_b() {
        return this.commandName;
    }

    public String func_71518_a(ICommandSender ics) {
        return "/" + this.commandName;
    }

    public final void func_71515_b(ICommandSender ics, String[] args) {
        String[] scmds;
        if (args == null) {
            args = new String[]{};
        }
        if ((scmds = this.getSubcommands(ics)) != null && args.length == 0) {
            LatCoreMC.printChat(ics, "Subcommands: " + LatCore.strip(scmds));
            return;
        }
        String s = this.onCommand(ics, args);
        if (s != null) {
            s = EnumChatFormatting.RED + s;
            if (s.startsWith(EnumChatFormatting.RED + FINE)) {
                s = s.substring(4);
            }
            LatCoreMC.printChat(ics, s);
        }
        this.onPostCommand(ics, args);
    }

    public abstract String[] getSubcommands(ICommandSender var1);

    public abstract void printHelp(ICommandSender var1);

    public abstract String onCommand(ICommandSender var1, String[] var2);

    public String retHelp(ICommandSender ics, String cmd) {
        return "Invalid command syntax!";
    }

    public final void printHelpLine(ICommandSender ics, String args) {
        LatCoreMC.printChat(ics, "/" + this.commandName + (args != null && args.length() > 0 ? " " + args : ""));
    }

    public void onPostCommand(ICommandSender ics, String[] args) {
    }

    public final List func_71516_a(ICommandSender ics, String[] args) {
        Object[] s = this.getTabStrings(ics, args, args.length - 1);
        if (s != null && s.length > 0) {
            if (this.sortStrings(ics, args, args.length - 1)) {
                Arrays.sort(s);
            }
            return CommandLM.func_71530_a((String[])args, (String[])s);
        }
        return null;
    }

    public NameType getUsername(String[] args, int i) {
        return NameType.NONE;
    }

    public static boolean isArg(String[] args, int i, String ... s) {
        if (args != null && i >= 0 && i < args.length) {
            for (int j = 0; j < s.length; ++j) {
                if (!args[i].equals(s[j])) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getTabStrings(ICommandSender ics, String[] args, int i) {
        return this.getUsername(args, i).getUsernames();
    }

    public boolean sortStrings(ICommandSender ics, String[] args, int i) {
        return this.getUsername(args, i) == NameType.NONE;
    }

    public static EntityPlayerMP getPlayer(ICommandSender ics, String s) {
        EntityPlayerMP ep = CommandLM.getLMPlayer(s).getPlayerMP();
        if (ep != null) {
            return ep;
        }
        throw new PlayerNotFoundException();
    }

    public static LMPlayer getLMPlayer(Object o) {
        LMPlayer p = LMPlayer.getPlayer(o);
        if (p == null) {
            throw new PlayerNotFoundException();
        }
        return p;
    }

    public static void checkArgs(String[] args, int i) {
        if (args == null || args.length < i) {
            throw new MissingArgsException();
        }
    }

    public static void checkArgsStrong(String[] args, int i) {
        if (args == null || args.length != i) {
            throw new MissingArgsException();
        }
    }

    public static enum NameType {
        NONE,
        ON,
        OFF;


        public boolean isOnline() {
            return this == ON;
        }

        public String[] getUsernames() {
            return LMPlayer.getAllNames(this);
        }
    }
}

