/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import latmod.core.LMMod;
import latmod.core.LatCoreMC;
import latmod.core.block.IBlockLM;
import latmod.core.item.ItemBlockLM;
import latmod.core.tile.TileLM;
import latmod.core.util.FastList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockLM
extends BlockContainer
implements IBlockLM {
    public final String blockName;
    public ArrayList<ItemStack> blocksAdded = new ArrayList();
    public final LMMod mod = this.getMod();
    private Item blockItem = null;

    public BlockLM(String s, Material m) {
        super(m);
        this.blockName = s;
        this.func_149663_c(this.mod.getBlockName(s));
        this.func_149658_d(s);
        this.func_149711_c(1.8f);
        this.func_149752_b(3.0f);
        this.field_149758_A = false;
    }

    @Override
    public Class<? extends ItemBlockLM> getItemBlock() {
        return ItemBlockLM.class;
    }

    public abstract LMMod getMod();

    @SideOnly(value=Side.CLIENT)
    public abstract CreativeTabs func_149708_J();

    public abstract TileLM createNewTileEntity(World var1, int var2);

    public final <E> E register() {
        this.mod.addBlock(this);
        return (E)this;
    }

    public final <E> E registerDevOnly() {
        if (LatCoreMC.isDevEnv) {
            this.mod.addBlock(this);
        }
        return (E)this;
    }

    @Override
    public final String getItemID() {
        return this.blockName;
    }

    @Override
    public void onPostLoaded() {
        this.blocksAdded.add(new ItemStack((Block)this));
    }

    public int func_149692_a(int i) {
        return i;
    }

    public boolean hasTileEntity(int m) {
        return this.field_149758_A;
    }

    public String getUnlocalizedName(int m) {
        return this.mod.getBlockName(this.blockName);
    }

    public void addAllDamages(int until) {
        for (int i = 0; i < until; ++i) {
            this.blocksAdded.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item j, CreativeTabs c, List l) {
        l.addAll(this.blocksAdded);
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase el, ItemStack is) {
        TileLM tile;
        if (this.field_149758_A && el instanceof EntityPlayer && (tile = (TileLM)w.func_147438_o(x, y, z)) != null) {
            tile.onPlacedBy((EntityPlayer)el, is);
        }
    }

    public float func_149737_a(EntityPlayer ep, World w, int x, int y, int z) {
        TileLM tile;
        if (this.field_149758_A && (tile = (TileLM)w.func_147438_o(x, y, z)) != null && !tile.isMinable(ep)) {
            return -1.0f;
        }
        return super.func_149737_a(ep, w, x, y, z);
    }

    public float func_149712_f(World w, int x, int y, int z) {
        TileLM tile;
        if (this.field_149758_A && (tile = (TileLM)w.func_147438_o(x, y, z)) != null && !tile.isMinable(null)) {
            return -1.0f;
        }
        return super.func_149712_f(w, x, y, z);
    }

    public float getExplosionResistance(Entity e, World w, int x, int y, int z, double ex, double ey, double ez) {
        TileLM tile;
        if (this.field_149758_A && (tile = (TileLM)w.func_147438_o(x, y, z)) != null && tile.isExplosionResistant()) {
            return 1000000.0f;
        }
        return super.getExplosionResistance(e, w, x, y, z, ex, ey, ez);
    }

    public int func_149656_h() {
        return this.field_149758_A ? 2 : 0;
    }

    public void func_149749_a(World w, int x, int y, int z, Block b, int m) {
        TileLM tile;
        if (!w.field_72995_K && this.field_149758_A && (tile = (TileLM)w.func_147438_o(x, y, z)) != null) {
            tile.onBroken();
        }
        super.func_149749_a(w, x, y, z, b, m);
    }

    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer ep, int s, float x1, float y1, float z1) {
        if (!this.field_149758_A) {
            return false;
        }
        TileLM tile = (TileLM)w.func_147438_o(x, y, z);
        return tile != null ? tile.onRightClick(ep, ep.func_70694_bm(), s, x1, y1, z1) : false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a(this.mod.assets + this.func_149641_N());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int s, int m) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        return this.func_149691_a(s, iba.func_72805_g(x, y, z));
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return null;
    }

    public boolean rotateBlock(World w, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean func_149696_a(World w, int x, int y, int z, int eventID, int param) {
        TileLM t;
        if (this.field_149758_A && (t = (TileLM)w.func_147438_o(x, y, z)) != null) {
            return t.func_145842_c(eventID, param);
        }
        return false;
    }

    public boolean recolourBlock(World w, int x, int y, int z, ForgeDirection side, int col) {
        TileLM t;
        if (this.field_149758_A && (t = (TileLM)w.func_147438_o(x, y, z)) != null) {
            return t.recolourBlock(side, col);
        }
        return false;
    }

    @Override
    public void loadRecipes() {
    }

    @SideOnly(value=Side.CLIENT)
    public void addInfo(ItemStack is, EntityPlayer ep, FastList<String> l) {
    }

    public void func_149695_a(World w, int x, int y, int z, Block b) {
        TileLM t;
        if (this.field_149758_A && (t = (TileLM)w.func_147438_o(x, y, z)) != null) {
            t.onNeighborBlockChange(b);
        }
    }

    public final Item getItem() {
        if (this.blockItem == null) {
            this.blockItem = Item.func_150898_a((Block)this);
        }
        return this.blockItem;
    }

    public AxisAlignedBB func_149668_a(World w, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)w, x, y, z);
        return super.func_149668_a(w, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon getBlockIcon() {
        return this.field_149761_L;
    }

    @Deprecated
    public final int func_149660_a(World w, int x, int y, int z, int s, float hitX, float hitY, float hitZ, int m) {
        return m;
    }

    public int onBlockPlaced(World w, EntityPlayer ep, MovingObjectPosition mop, int m) {
        return m;
    }
}

