/*
 * Decompiled with CFR 0.152.
 */
package latmod.core;

import net.minecraftforge.common.util.ForgeDirection;

public enum SidedDirection {
    Bottom(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.DOWN, ForgeDirection.DOWN, ForgeDirection.DOWN, ForgeDirection.DOWN),
    Top(ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.UP, ForgeDirection.UP, ForgeDirection.UP, ForgeDirection.UP),
    Back(ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.WEST),
    Front(ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST),
    Left(ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH),
    Right(ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.NORTH),
    None(ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN);

    public final ForgeDirection[] directions;
    public final int index;
    public static final SidedDirection[] VALUES;

    private SidedDirection(ForgeDirection ... f) {
        this.directions = f;
        this.index = this.ordinal();
    }

    public ForgeDirection getDir(ForgeDirection rot) {
        return this.getDir(rot.ordinal());
    }

    public ForgeDirection getDir(int rot) {
        return this.directions[rot];
    }

    public static SidedDirection getSide(ForgeDirection rot, ForgeDirection side) {
        for (int i = 0; i < VALUES.length; ++i) {
            if (VALUES[i].getDir(rot) != side) continue;
            return VALUES[i];
        }
        return None;
    }

    static {
        VALUES = new SidedDirection[]{Bottom, Top, Back, Front, Left, Right};
    }
}

