/*
 * Decompiled with CFR 0.152.
 */
package latmod.core;

import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.IServerConfig;
import latmod.core.LMConfig;
import latmod.core.LatCoreMC;
import latmod.core.block.IBlockLM;
import latmod.core.item.IItemLM;
import latmod.core.recipes.LMRecipes;
import latmod.core.tile.TileLM;
import latmod.core.util.FastList;
import latmod.core.util.FastMap;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LMMod {
    public static final FastMap<String, LMMod> modsMap = new FastMap();
    public final ModMetadata modMetadata;
    public final String modID;
    public final String displayName;
    public final String version;
    public final String assets;
    public final FastList<IBlockLM> blocks;
    public final FastList<IItemLM> items;
    public Logger logger;
    public LMRecipes recipes;
    public LMConfig config;

    public LMMod(FMLPreInitializationEvent e, LMConfig c, LMRecipes r) {
        this.modMetadata = e.getModMetadata();
        this.modID = this.modMetadata.modId;
        this.displayName = this.modMetadata.name;
        this.version = this.modMetadata.version;
        this.assets = this.modID.toLowerCase() + ":";
        this.blocks = new FastList();
        this.items = new FastList();
        this.logger = LogManager.getLogger((String)this.modID);
        if (LatCoreMC.isDevEnv) {
            this.logger.info("LMMod '" + this.displayName + "' v" + this.version + " created");
        }
        this.config = c;
        if (this.config != null) {
            this.config.setMod(this);
            if (this.config instanceof IServerConfig) {
                IServerConfig.Registry.add((IServerConfig)((Object)this.config));
            }
        }
        this.recipes = r == null ? new LMRecipes() : r;
        modsMap.put(this.modID, this);
    }

    public String toFullString() {
        return this.modID + '-' + "1.7.10" + '-' + this.version;
    }

    public String toString() {
        return this.modID;
    }

    public ResourceLocation getLocation(String s) {
        return new ResourceLocation(this.assets + s);
    }

    public CreativeTabs createTab(String s, final ItemStack icon) {
        CreativeTabs tab = new CreativeTabs(this.assets + s){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_151244_d() {
                return icon;
            }

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return this.func_151244_d().func_77973_b();
            }
        };
        return tab;
    }

    public String getBlockName(String s) {
        return this.assets + "tile." + s;
    }

    public String getItemName(String s) {
        return this.assets + "item." + s;
    }

    public String translate(String s, Object ... args) {
        if (args == null || args.length == 0) {
            return StatCollector.func_74838_a((String)(this.assets + s));
        }
        return StatCollector.func_74837_a((String)(this.assets + s), (Object[])args);
    }

    public void addItem(IItemLM i) {
        LatCoreMC.addItem((Item)i, i.getItemID());
        this.items.add(i);
    }

    public void addBlock(IBlockLM b) {
        LatCoreMC.addBlock((Block)b, b.getItemBlock(), b.getItemID());
        this.blocks.add(b);
    }

    public void addTile(Class<? extends TileLM> c, String s, String ... alt) {
        LatCoreMC.addTileEntity(c, this.modID + '.' + s, alt);
    }

    public void addEntity(Class<? extends Entity> c, String s, int id) {
        LatCoreMC.addEntity(c, s, id, this.modID);
    }

    public void onPostLoaded() {
        int i;
        for (i = 0; i < this.items.size(); ++i) {
            this.items.get(i).onPostLoaded();
        }
        for (i = 0; i < this.blocks.size(); ++i) {
            this.blocks.get(i).onPostLoaded();
        }
    }

    public void loadRecipes() {
        int i;
        for (i = 0; i < this.items.size(); ++i) {
            this.items.get(i).loadRecipes();
        }
        for (i = 0; i < this.blocks.size(); ++i) {
            this.blocks.get(i).loadRecipes();
        }
        if (this.recipes != null) {
            this.recipes.loadRecipes();
        }
    }
}

