/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.IReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.omega.OmegaParadigm;
import WayofTime.alchemicalWizardry.common.omega.OmegaRegistry;
import WayofTime.alchemicalWizardry.common.omega.OmegaStructureHandler;
import WayofTime.alchemicalWizardry.common.omega.OmegaStructureParameters;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RitualEffectOmegaTest
extends RitualEffect {
    public static final boolean isTesting = false;
    public static final int drainTotal = 32000;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (world.func_72820_D() % 200L != 0L) {
            return;
        }
        OmegaStructureParameters param = OmegaStructureHandler.getStructureStabilityFactor(world, x, y, z, 5, new Int3(0, 1, 0));
        int stab = param.stability;
        int enchantability = param.enchantability;
        int enchantmentLevel = param.enchantmentLevel;
        if (stab <= 0) {
            return;
        }
        double range = 0.5;
        List<EntityPlayer> playerList = SpellHelper.getPlayersInRange(world, (double)x + 0.5, (double)y + 1.5, (double)z + 0.5, range, range);
        Reagent reagent = null;
        HashMap<Reagent, Integer> reagentMap = new HashMap<Reagent, Integer>();
        for (int i = 0; i < 4; ++i) {
            IReagentHandler container;
            ReagentContainerInfo[] containerInfoArray;
            Int3 jarLoc = this.getJarLocation(i);
            TileEntity tile = world.func_147438_o(x + jarLoc.xCoord, y + jarLoc.yCoord, z + jarLoc.zCoord);
            if (!(tile instanceof IReagentHandler) || (containerInfoArray = (container = (IReagentHandler)tile).getContainerInfo(ForgeDirection.UP)) == null) continue;
            for (ReagentContainerInfo containerInfo : containerInfoArray) {
                ReagentStack containedReagent = containerInfo.reagent;
                if (containedReagent == null) continue;
                Reagent rea = containedReagent.reagent;
                int amt = containedReagent.amount;
                if (reagentMap.containsKey(rea)) {
                    reagentMap.put(rea, (Integer)reagentMap.get(rea) + amt);
                    continue;
                }
                reagentMap.put(rea, amt);
            }
        }
        for (Map.Entry entry : reagentMap.entrySet()) {
            if ((Integer)entry.getValue() < 32000) continue;
            reagent = (Reagent)entry.getKey();
            break;
        }
        if (reagent == null) {
            return;
        }
        int tickDuration = 18000 + (int)(18000.0 * Math.sqrt(stab / 700));
        int affinity = 0;
        for (EntityPlayer player : playerList) {
            OmegaParadigm waterParadigm = OmegaRegistry.getParadigmForReagent(reagent);
            if (waterParadigm == null || !waterParadigm.convertPlayerArmour(player, x, y, z, stab, affinity, enchantability, enchantmentLevel)) continue;
            APISpellHelper.setPlayerCurrentReagentAmount(player, tickDuration);
            APISpellHelper.setPlayerMaxReagentAmount(player, tickDuration);
            APISpellHelper.setPlayerReagentType(player, reagent);
            APISpellHelper.setCurrentAdditionalMaxHP(player, waterParadigm.getMaxAdditionalHealth());
            NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getReagentBarPacket(reagent, APISpellHelper.getPlayerCurrentReagentAmount(player), APISpellHelper.getPlayerMaxReagentAmount(player)), (EntityPlayerMP)player);
            int drainLeft = 32000;
            for (int i = 0; i < 4 && drainLeft > 0; ++i) {
                IReagentHandler container;
                ReagentStack drained;
                Int3 jarLoc = this.getJarLocation(i);
                TileEntity tile = world.func_147438_o(x + jarLoc.xCoord, y + jarLoc.yCoord, z + jarLoc.zCoord);
                if (!(tile instanceof IReagentHandler) || (drained = (container = (IReagentHandler)tile).drain(ForgeDirection.UP, new ReagentStack(reagent, drainLeft), true)) == null) continue;
                drainLeft -= drained.amount;
                world.func_147471_g(x + jarLoc.xCoord, y + jarLoc.yCoord, z + jarLoc.zCoord);
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)(x + jarLoc.xCoord), (double)(y + jarLoc.yCoord), (double)(z + jarLoc.zCoord)));
            }
            ritualStone.setActive(false);
            break;
        }
    }

    @Override
    public int getCostPerRefresh() {
        return 0;
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        int i;
        ArrayList<RitualComponent> omegaRitual = new ArrayList<RitualComponent>();
        this.addCornerRunes(omegaRitual, 1, 0, 5);
        this.addCornerRunes(omegaRitual, 2, 0, 5);
        this.addCornerRunes(omegaRitual, 3, 0, 0);
        this.addCornerRunes(omegaRitual, 4, 0, 5);
        this.addCornerRunes(omegaRitual, 5, 0, 0);
        this.addParallelRunes(omegaRitual, 1, 0, 6);
        this.addParallelRunes(omegaRitual, 2, 0, 0);
        this.addParallelRunes(omegaRitual, 4, 0, 0);
        this.addParallelRunes(omegaRitual, 5, 0, 6);
        this.addOffsetRunes(omegaRitual, 1, 3, 0, 5);
        this.addOffsetRunes(omegaRitual, 1, 5, 0, 5);
        for (i = 2; i <= 4; ++i) {
            omegaRitual.add(new RitualComponent(-5, 0, i, 1));
            omegaRitual.add(new RitualComponent(-5, 0, -i, 1));
            omegaRitual.add(new RitualComponent(5, 0, i, 2));
            omegaRitual.add(new RitualComponent(5, 0, -i, 2));
            omegaRitual.add(new RitualComponent(i, 0, -5, 3));
            omegaRitual.add(new RitualComponent(-i, 0, -5, 3));
            omegaRitual.add(new RitualComponent(i, 0, 5, 4));
            omegaRitual.add(new RitualComponent(-i, 0, 5, 4));
        }
        for (i = 2; i <= 3; ++i) {
            omegaRitual.add(new RitualComponent(4, 0, i, 1));
            omegaRitual.add(new RitualComponent(4, 0, -i, 1));
            omegaRitual.add(new RitualComponent(-4, 0, i, 2));
            omegaRitual.add(new RitualComponent(-4, 0, -i, 2));
            omegaRitual.add(new RitualComponent(i, 0, 4, 3));
            omegaRitual.add(new RitualComponent(-i, 0, 4, 3));
            omegaRitual.add(new RitualComponent(i, 0, -4, 4));
            omegaRitual.add(new RitualComponent(-i, 0, -4, 4));
        }
        omegaRitual.add(new RitualComponent(-2, 0, 1, 4));
        omegaRitual.add(new RitualComponent(-2, 0, -1, 4));
        omegaRitual.add(new RitualComponent(-4, 0, 1, 4));
        omegaRitual.add(new RitualComponent(-4, 0, -1, 4));
        omegaRitual.add(new RitualComponent(2, 0, 1, 3));
        omegaRitual.add(new RitualComponent(2, 0, -1, 3));
        omegaRitual.add(new RitualComponent(4, 0, 1, 3));
        omegaRitual.add(new RitualComponent(4, 0, -1, 3));
        omegaRitual.add(new RitualComponent(1, 0, 2, 2));
        omegaRitual.add(new RitualComponent(-1, 0, 2, 2));
        omegaRitual.add(new RitualComponent(1, 0, 4, 2));
        omegaRitual.add(new RitualComponent(-1, 0, 4, 2));
        omegaRitual.add(new RitualComponent(1, 0, -2, 1));
        omegaRitual.add(new RitualComponent(-1, 0, -2, 1));
        omegaRitual.add(new RitualComponent(1, 0, -4, 1));
        omegaRitual.add(new RitualComponent(-1, 0, -4, 1));
        omegaRitual.add(new RitualComponent(-3, 0, 2, 2));
        omegaRitual.add(new RitualComponent(-3, 0, -2, 2));
        omegaRitual.add(new RitualComponent(3, 0, 2, 1));
        omegaRitual.add(new RitualComponent(3, 0, -2, 1));
        omegaRitual.add(new RitualComponent(-2, 0, -3, 4));
        omegaRitual.add(new RitualComponent(2, 0, -3, 4));
        omegaRitual.add(new RitualComponent(-2, 0, 3, 3));
        omegaRitual.add(new RitualComponent(2, 0, 3, 3));
        return omegaRitual;
    }

    public Int3 getJarLocation(int i) {
        switch (i) {
            case 0: {
                return new Int3(-3, 0, 0);
            }
            case 1: {
                return new Int3(3, 0, 0);
            }
            case 2: {
                return new Int3(0, 0, -3);
            }
            case 3: {
                return new Int3(0, 0, 3);
            }
        }
        return new Int3(0, 0, 0);
    }
}

