/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.items.interfaces.IHolding;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class SigilOfHolding
extends EnergyItems {
    private int invSize = 4;
    public static List<ItemStack> allowedSigils = new ArrayList<ItemStack>();

    public SigilOfHolding() {
        this.field_77777_bU = 1;
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:SigilOfHolding");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (stack.func_77978_p() != null) {
            ItemStack[] inv = this.getInternalInventory(stack);
            if (inv == null) {
                return this.field_77791_bV;
            }
            ItemStack item = inv[stack.func_77978_p().func_74762_e("selectedSlot")];
            if (item != null) {
                return item.func_77954_c();
            }
        }
        return this.field_77791_bV;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.sigilofholding.desc"));
        if (par1ItemStack.func_77978_p() != null) {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.owner.currentowner") + " " + par1ItemStack.func_77978_p().func_74779_i("ownerName"));
            ItemStack[] inv = this.getInternalInventory(par1ItemStack);
            if (inv == null) {
                return;
            }
            ItemStack item = inv[par1ItemStack.func_77978_p().func_74762_e("selectedSlot")];
            if (item != null) {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.item.currentitem") + " " + item.func_82833_r());
            }
            for (int i = 0; i < this.invSize; ++i) {
                if (inv[i] == null) continue;
                par3List.add(StatCollector.func_74838_a((String)"tooltip.item.iteminslot") + " " + i + ": " + inv[i].func_82833_r());
            }
        }
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        if (SigilOfHolding.checkAndSetItemOwner(par1ItemStack, par2EntityPlayer)) {
            int currentSlot = this.getSelectedSlot(par1ItemStack);
            ItemStack[] inv = this.getInternalInventory(par1ItemStack);
            if (inv == null) {
                return false;
            }
            ItemStack itemUsed = inv[currentSlot];
            if (itemUsed == null) {
                return false;
            }
            boolean bool = itemUsed.func_77973_b().func_77648_a(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
            this.saveInternalInventory(par1ItemStack, inv);
            return bool;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (SigilOfHolding.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer)) {
            if (par3EntityPlayer.func_70093_af()) {
                if (this.addSigilToInventory(par1ItemStack, par3EntityPlayer)) {
                    return par1ItemStack;
                }
                this.selectNextSlot(par1ItemStack);
                return par1ItemStack;
            }
            int currentSlot = this.getSelectedSlot(par1ItemStack);
            ItemStack[] inv = this.getInternalInventory(par1ItemStack);
            if (inv == null) {
                return par1ItemStack;
            }
            ItemStack itemUsed = inv[currentSlot];
            if (itemUsed == null) {
                return par1ItemStack;
            }
            itemUsed.func_77973_b().func_77659_a(itemUsed, par2World, par3EntityPlayer);
            this.saveInternalInventory(par1ItemStack, inv);
        }
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (par1ItemStack.func_77978_p() != null) {
            this.tickInternalInventory(par1ItemStack, par2World, par3Entity, par4, par5);
        }
    }

    public ItemStack[] getInternalInventory(ItemStack itemStack) {
        NBTTagCompound itemTag = itemStack.func_77978_p();
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
            return null;
        }
        ItemStack[] inv = new ItemStack[9];
        NBTTagList tagList = itemTag.func_150295_c("Inventory", 10);
        if (tagList == null) {
            return null;
        }
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.invSize) continue;
            inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        return inv;
    }

    public void saveInternalInventory(ItemStack itemStack, ItemStack[] inventory) {
        NBTTagCompound itemTag = itemStack.func_77978_p();
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.invSize; ++i) {
            ItemStack stack = inventory[i];
            if (inventory[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            inventory[i].func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        itemTag.func_74782_a("Inventory", (NBTBase)itemList);
    }

    public void tickInternalInventory(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        ItemStack[] inv = this.getInternalInventory(par1ItemStack);
        if (inv == null) {
            return;
        }
        for (int i = 0; i < this.invSize; ++i) {
            if (inv[i] == null) continue;
            inv[i].func_77973_b().func_77663_a(inv[i], par2World, par3Entity, par4, par5);
        }
    }

    public int getSelectedSlot(ItemStack itemStack) {
        NBTTagCompound itemTag = itemStack.func_77978_p();
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemTag.func_74762_e("selectedSlot");
    }

    public void selectNextSlot(ItemStack itemStack) {
        ItemStack[] inv = this.getInternalInventory(itemStack);
        int filledSlots = 0;
        for (int i = 0; i < this.invSize && inv[i] != null; ++i) {
            ++filledSlots;
        }
        NBTTagCompound itemTag = itemStack.func_77978_p();
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (this.getSelectedSlot(itemStack) + 1 < filledSlots) {
            itemTag.func_74768_a("selectedSlot", itemTag.func_74762_e("selectedSlot") + 1);
        } else {
            itemTag.func_74768_a("selectedSlot", 0);
        }
    }

    public boolean hasAddedToInventory(ItemStack sigilItemStack, ItemStack addedItemStack) {
        ItemStack[] inv = this.getInternalInventory(sigilItemStack);
        if (inv == null) {
            return false;
        }
        if (addedItemStack == null) {
            return false;
        }
        Item item = addedItemStack.func_77973_b();
        int candidateSlot = -1;
        for (int i = this.invSize - 1; i >= 0; --i) {
            ItemStack nextItem = inv[i];
            if (nextItem == null) {
                candidateSlot = i;
                continue;
            }
            if (item != nextItem.func_77973_b()) continue;
            return false;
        }
        if (candidateSlot == -1) {
            return false;
        }
        if (addedItemStack.func_77973_b() instanceof IHolding) {
            inv[candidateSlot] = addedItemStack;
            this.saveInternalInventory(sigilItemStack, inv);
            return true;
        }
        for (ItemStack i : allowedSigils) {
            if (i == null || i.func_77973_b() != item) continue;
            inv[candidateSlot] = addedItemStack;
            this.saveInternalInventory(sigilItemStack, inv);
            return true;
        }
        return false;
    }

    public boolean addSigilToInventory(ItemStack sigilItemStack, EntityPlayer player) {
        ItemStack[] playerInventory = player.field_71071_by.field_70462_a;
        for (int i = 0; i < 36; ++i) {
            if (!this.hasAddedToInventory(sigilItemStack, playerInventory[i])) continue;
            player.field_71071_by.func_146026_a(playerInventory[i].func_77973_b());
            return true;
        }
        return false;
    }

    public static void initiateSigilOfHolding() {
        allowedSigils.add(new ItemStack(ModItems.waterSigil));
        allowedSigils.add(new ItemStack(ModItems.lavaSigil));
        allowedSigils.add(new ItemStack(ModItems.voidSigil));
        allowedSigils.add(new ItemStack(ModItems.airSigil));
        allowedSigils.add(new ItemStack(ModItems.sigilOfTheFastMiner));
        allowedSigils.add(new ItemStack(ModItems.divinationSigil));
        allowedSigils.add(new ItemStack(ModItems.sigilOfElementalAffinity));
        allowedSigils.add(new ItemStack(ModItems.growthSigil));
        allowedSigils.add(new ItemStack(ModItems.sigilOfHaste));
        allowedSigils.add(new ItemStack(ModItems.sigilOfWind));
    }

    public ItemStack getCurrentItem(ItemStack sigilItemStack) {
        ItemStack[] items = this.getInternalInventory(sigilItemStack);
        if (items == null) {
            return null;
        }
        return items[this.getSelectedSlot(sigilItemStack)];
    }
}

