/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.parser.token;

import net.malisis.core.util.parser.token.CharToken;
import net.malisis.core.util.parser.token.DigitToken;
import net.malisis.core.util.parser.token.EmptyToken;
import net.malisis.core.util.parser.token.ExpressionToken;
import net.malisis.core.util.parser.token.LetterToken;
import net.malisis.core.util.parser.token.SpaceToken;
import net.malisis.core.util.parser.token.StringToken;
import org.apache.commons.lang3.ArrayUtils;

public abstract class Token<T> {
    public static EmptyToken None = (EmptyToken)new EmptyToken().name("None");
    public static EmptyToken Unknown = (EmptyToken)new EmptyToken().name("Unknown");
    public static EmptyToken Error = (EmptyToken)new EmptyToken().name("Error");
    public static EmptyToken EndOfInput = (EmptyToken)new EmptyToken().name("EndOfInput");
    public static CharToken Plus = (CharToken)new CharToken('+').name("Plus");
    public static CharToken Minus = (CharToken)new CharToken('-').name("Minus");
    public static CharToken Mult = (CharToken)new CharToken('*').name("Mult");
    public static CharToken Div = (CharToken)new CharToken('/').name("Div");
    public static CharToken Sharp = (CharToken)new CharToken('#').name("Sharp");
    public static CharToken OpenPar = (CharToken)new CharToken('(').name("OpenPar");
    public static CharToken ClosePar = (CharToken)new CharToken(')').name("ClosePar");
    public static CharToken OpenCar = (CharToken)new CharToken('[').name("OpenCar");
    public static CharToken CloseCar = (CharToken)new CharToken(']').name("CloseCar");
    public static CharToken Not = (CharToken)new CharToken('!').name("Not");
    public static CharToken Equal = (CharToken)new CharToken('=').name("Equal");
    public static CharToken Superior = (CharToken)new CharToken('>').name("Superior");
    public static CharToken Inferior = (CharToken)new CharToken('<').name("Inferior");
    public static CharToken AndOperator = (CharToken)new CharToken('&').name("AndOperator");
    public static CharToken OrOperator = (CharToken)new CharToken('|').name("OrOperator");
    public static CharToken StartWith = (CharToken)new CharToken('$').name("StartWith");
    public static CharToken EndWith = (CharToken)new CharToken('^').name("EndWith");
    public static CharToken Quote = (CharToken)new CharToken('\"').name("Quote");
    public static CharToken Apostrophe = (CharToken)new CharToken('\'').name("Apostrophe");
    public static CharToken UnderScore = (CharToken)new CharToken('_').name("UnderScore");
    public static ExpressionToken Identifier = (ExpressionToken)new ExpressionToken("^[^\\d\\W]\\w*").name("Identifier");
    public static ExpressionToken Number = (ExpressionToken)new ExpressionToken("^\\d+").name("Number");
    public static ExpressionToken HexNumber = (ExpressionToken)new ExpressionToken("^#[0-9a-fA-F]+").name("HexNumber");
    public static StringToken StringToken = (StringToken)new StringToken().name("StringToken");
    public static SpaceToken Space = (SpaceToken)new SpaceToken().name("Space");
    public static DigitToken Digit = (DigitToken)new DigitToken().name("Digit");
    public static LetterToken Letter = (LetterToken)new LetterToken().name("Letter");
    protected String name = "";
    protected T value = null;

    public Token name(String name) {
        this.name = name;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isOneOf(Token ... tokens) {
        return ArrayUtils.contains((Object[])tokens, (Object)this);
    }

    public abstract boolean matches(String var1, int var2);

    public abstract int size();

    public String toString() {
        return this.name + (this.value != null ? " " + this.value : "");
    }
}

