/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.multiblock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.multiblock.MultiBlock;
import net.minecraft.block.Block;

public class PatternMultiBlock
extends MultiBlock {
    private List<List<String>> pattern = new ArrayList<List<String>>();
    private Map<Character, BlockState> blocks = new HashMap<Character, BlockState>();

    public PatternMultiBlock addLayer(String ... layer) {
        this.pattern.add(Arrays.asList(layer));
        this.buildStates();
        return this;
    }

    public PatternMultiBlock withRef(char c, Block block) {
        return this.withRef(c, block, 0);
    }

    public PatternMultiBlock withRef(char c, Block block, int metadata) {
        return this.withRef(c, new BlockState(block, metadata));
    }

    public PatternMultiBlock withRef(char c, BlockState state) {
        this.blocks.put(Character.valueOf(c), state);
        this.buildStates();
        return this;
    }

    @Override
    public void buildStates() {
        this.states.clear();
        int x = 0;
        int y = 0;
        for (List<String> layer : this.pattern) {
            for (String row : layer) {
                for (int z = 0; z < row.length(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z).add(this.offset);
                    BlockState state = this.blocks.get(Character.valueOf(row.charAt(z)));
                    if (state == null) continue;
                    this.states.put(pos, new BlockState(pos, state));
                }
            }
        }
    }
}

