/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.multiblock;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.minecraft.world.World;

public abstract class MultiBlock
implements Iterable<BlockState> {
    protected Map<BlockPos, BlockState> states = new HashMap<BlockPos, BlockState>();
    protected BlockPos offset;

    public void setOffset(BlockPos offset) {
        this.offset = offset;
    }

    public boolean isFromMultiblock(BlockPos pos) {
        return this.getBlockState(pos) != null;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.states.get(pos);
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        for (BlockState state : this) {
            BlockPos p = state.getPos().add(pos);
            if (state.getBlock().func_149742_c(world, p.getX(), p.getY(), p.getZ())) continue;
            return false;
        }
        return true;
    }

    public void placeBlocks(World world, BlockPos pos) {
        for (BlockState state : this) {
            if ((state = state.offset(pos)).getPos().equals(pos)) continue;
            state.placeBlock(world, 2);
        }
    }

    public void breakBlocks(World world, BlockPos pos) {
        for (BlockState state : this) {
            if ((state = state.offset(pos)).getPos().equals(pos)) continue;
            state.breakBlock(world, 2);
        }
    }

    @Override
    public Iterator<BlockState> iterator() {
        return this.states.values().iterator();
    }

    protected abstract void buildStates();
}

