/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkblock;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.set.hash.TLongHashSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.malisis.core.MalisisCore;
import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.chunkblock.ChunkBlockMessage;
import net.malisis.core.util.chunkblock.IChunkBlock;
import net.malisis.core.util.chunkblock.IChunkBlockHandler;
import net.malisis.core.util.chunklistener.ChunkListener;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;

public class ChunkBlockHandler
implements IChunkBlockHandler {
    private static ChunkBlockHandler instance = new ChunkBlockHandler();
    private Map<Chunk, TLongHashSet> serverChunks = new WeakHashMap<Chunk, TLongHashSet>();
    private Map<Chunk, TLongHashSet> clientChunks = new WeakHashMap<Chunk, TLongHashSet>();
    private List<IChunkBlockHandler> handlers = new ArrayList<IChunkBlockHandler>();

    public ChunkBlockHandler() {
        this.handlers.add(new ChunkListener());
    }

    private TLongHashSet getCoords(Chunk chunk) {
        Map<Chunk, TLongHashSet> chunks = chunk.field_76637_e.field_72995_K ? this.clientChunks : this.serverChunks;
        TLongHashSet coords = chunks.get(chunk);
        if (coords == null) {
            coords = new TLongHashSet();
            chunks.put(chunk, coords);
        }
        return coords;
    }

    public void callProcedure(Chunk chunk, ChunkProcedure procedure) {
        procedure.set(chunk);
        TLongHashSet coords = this.getCoords(chunk);
        if (coords != null) {
            coords.forEach((TLongProcedure)procedure);
        }
    }

    public void addHandler(IChunkBlockHandler handler) {
        this.handlers.add(handler);
    }

    public boolean updateCoordinates(Chunk chunk, int x, int y, int z, Block old, Block block) {
        boolean canceled = false;
        BlockPos pos = new BlockPos(x, y, z);
        for (IChunkBlockHandler handler : this.handlers) {
            canceled |= handler.updateCoordinates(chunk, pos, old, block);
        }
        if (!canceled) {
            this.updateCoordinates(chunk, pos, old, block);
        }
        return !canceled;
    }

    @Override
    public boolean updateCoordinates(Chunk chunk, BlockPos pos, Block old, Block block) {
        if (old instanceof IChunkBlock) {
            this.removeCoord(chunk.field_76637_e, pos, ((IChunkBlock)old).blockRange());
        }
        if (block instanceof IChunkBlock) {
            this.addCoord(chunk.field_76637_e, pos, ((IChunkBlock)block).blockRange());
        }
        return true;
    }

    private void addCoord(World world, BlockPos pos, int size) {
        List<Chunk> affectedChunks = this.getAffectedChunks(world, pos.getX(), pos.getZ(), size);
        for (Chunk chunk : affectedChunks) {
            this.addCoord(chunk, pos);
        }
    }

    private void addCoord(Chunk chunk, BlockPos pos) {
        this.getCoords(chunk).add(pos.toLong());
    }

    private void removeCoord(World world, BlockPos pos, int size) {
        List<Chunk> affectedChunks = this.getAffectedChunks(world, pos.getX(), pos.getZ(), size);
        for (Chunk chunk : affectedChunks) {
            this.removeCoord(chunk, pos);
        }
    }

    private void removeCoord(Chunk chunk, BlockPos pos) {
        if (!this.getCoords(chunk).remove(pos.toLong())) {
            MalisisCore.log.error("Failed to remove : {} ({})", new Object[]{pos, pos.toLong()});
        }
    }

    @SubscribeEvent
    public void onDataLoad(ChunkDataEvent.Load event) {
        NBTTagCompound nbt = event.getData();
        if (!nbt.func_74764_b("chunkNotifier")) {
            return;
        }
        long[] coords = this.readLongArray(nbt);
        Map<Chunk, TLongHashSet> chunks = event.getChunk().field_76637_e.field_72995_K ? this.clientChunks : this.serverChunks;
        chunks.put(event.getChunk(), new TLongHashSet(coords));
    }

    @SubscribeEvent
    public void onDataSave(ChunkDataEvent.Save event) {
        TLongHashSet coords = this.getCoords(event.getChunk());
        if (coords == null || coords.size() == 0) {
            return;
        }
        NBTTagCompound nbt = event.getData();
        this.writeLongArray(nbt, coords.toArray());
    }

    private long[] readLongArray(NBTTagCompound compound) {
        ByteBuf bytes = Unpooled.copiedBuffer((byte[])compound.func_74770_j("chunkNotifier"));
        long[] longs = new long[bytes.capacity() / 8];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = bytes.readLong();
        }
        return longs;
    }

    private void writeLongArray(NBTTagCompound compound, long[] longs) {
        ByteBuf bytes = Unpooled.buffer((int)(longs.length * 8));
        for (long aLong : longs) {
            bytes.writeLong(aLong);
        }
        compound.func_74773_a("chunkNotifier", bytes.array());
    }

    @SubscribeEvent
    public void onChunkWatched(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.player.field_70170_p.func_72964_e(event.chunk.field_77276_a, event.chunk.field_77275_b);
        TLongHashSet coords = this.getCoords(chunk);
        if (coords == null || coords.size() == 0) {
            return;
        }
        ChunkBlockMessage.sendCoords(chunk, coords.toArray(), event.player);
    }

    public void setCoords(int chunkX, int chunkZ, long[] coords) {
        Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_72964_e(chunkX, chunkZ);
        Map<Chunk, TLongHashSet> chunks = chunk.field_76637_e.field_72995_K ? this.clientChunks : this.serverChunks;
        chunks.put(chunk, new TLongHashSet(coords));
    }

    public List<Chunk> getAffectedChunks(World world, int x, int z, int distance) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(x - distance), (double)0.0, (double)(z - distance), (double)(x + distance + 1), (double)1.0, (double)(z + distance + 1));
        return ChunkBlockHandler.getAffectedChunks(world, aabb);
    }

    public static List<Chunk> getAffectedChunks(World world, AxisAlignedBB ... aabbs) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (AxisAlignedBB aabb : aabbs) {
            for (int cx = (int)Math.floor(aabb.field_72340_a) >> 4; cx <= (int)Math.ceil(aabb.field_72336_d) >> 4; ++cx) {
                for (int cz = (int)Math.floor(aabb.field_72339_c) >> 4; cz <= (int)Math.ceil(aabb.field_72334_f) >> 4; ++cz) {
                    if (!world.func_72863_F().func_73149_a(cx, cz)) continue;
                    chunks.add(world.func_72964_e(cx, cz));
                }
            }
        }
        return chunks;
    }

    public static ChunkBlockHandler get() {
        return instance;
    }

    public static abstract class ChunkProcedure
    implements TLongProcedure {
        protected World world;
        protected Chunk chunk;
        protected BlockState state;

        protected void set(Chunk chunk) {
            this.world = chunk.field_76637_e;
            this.chunk = chunk;
        }

        protected boolean check(long coord) {
            this.state = new BlockState((IBlockAccess)this.world, coord);
            if (!(this.state.getBlock() instanceof IChunkBlock)) {
                MalisisCore.log.info("[ChunkNotificationHandler]  Removing invalid {} coordinate : {} in chunk {},{}", new Object[]{this.world.field_72995_K ? "client" : "server", this.state, this.chunk.field_76635_g, this.chunk.field_76647_h});
                ChunkBlockHandler.get().removeCoord(this.chunk, this.state.getPos());
                return false;
            }
            return true;
        }

        protected void clean() {
            this.world = null;
            this.chunk = null;
            this.state = null;
        }
    }
}

