/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode.gui;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.util.bbcode.BBString;
import net.malisis.core.util.bbcode.gui.BBCodeEditor;
import net.malisis.core.util.bbcode.render.IBBCodeRenderer;

public class BBTextField
extends UITextField
implements IBBCodeRenderer<BBTextField> {
    protected BBCodeEditor editor;
    protected BBString bbText;
    protected boolean isWysiwyg = true;

    public BBTextField(MalisisGui gui, BBCodeEditor editor, BBString bbText) {
        super(gui, true);
        this.editor = editor;
        this.setText(bbText);
    }

    public BBTextField(MalisisGui gui, BBCodeEditor editor, String text) {
        this(gui, editor, new BBString(text));
    }

    public BBTextField(MalisisGui gui, BBCodeEditor editor) {
        this(gui, editor, new BBString(""));
    }

    @Override
    public BBString getBBText() {
        return this.bbText;
    }

    @Override
    public BBTextField setText(BBString str) {
        this.bbText = str != null ? str : new BBString();
        this.bbText.parseText();
        this.setText(this.bbText.getRawText());
        return this;
    }

    public boolean isWysiwyg() {
        return this.isWysiwyg;
    }

    public void setWysiwyg(boolean isWysiwyg) {
        this.isWysiwyg = isWysiwyg;
        if (isWysiwyg) {
            this.setText(new BBString(this.text.toString()));
        } else {
            this.setText(this.bbText.getBBString());
        }
        this.getCursorPosition().jumpToEnd();
    }

    @Override
    public int getStartLine() {
        return this.lineOffset;
    }

    @Override
    protected void buildLines() {
        super.buildLines();
        if (this.isWysiwyg()) {
            this.bbText.buildRenderLines(this.lines);
        }
    }

    @Override
    public void addText(String str) {
        if (!this.isWysiwyg()) {
            super.addText(str);
            return;
        }
        if (this.selectingText) {
            this.deleteSelectedText();
        }
        int position = this.getCursorPosition().getPosition();
        String oldValue = this.bbText.getText();
        this.bbText.addText(str, position);
        String newValue = this.bbText.getText();
        this.fireEvent(new ComponentEvent.ValueChange<BBTextField, String>(this, oldValue, newValue));
        this.text.setLength(0);
        this.text.append(this.bbText.getRawText());
        this.buildLines();
        this.getCursorPosition().jumpBy(str.length());
    }

    @Override
    public void deleteSelectedText() {
        if (!this.isWysiwyg()) {
            super.deleteSelectedText();
            return;
        }
        if (!this.selectingText) {
            return;
        }
        int sp = this.getSelectionPosition().getPosition();
        int cp = this.getCursorPosition().getPosition();
        int start = Math.min(sp, cp);
        int end = Math.max(sp, cp);
        String oldValue = this.bbText.getText();
        this.bbText.deleteText(start, end);
        String newValue = this.bbText.getText();
        this.fireEvent(new ComponentEvent.ValueChange<BBTextField, String>(this, oldValue, newValue));
        this.text.setLength(0);
        this.text.append(this.bbText.getRawText());
        this.buildLines();
        this.selectingText = false;
        this.getCursorPosition().jumpTo(start);
    }

    public void addTag(BBCodeEditor.Tag tag) {
        int p = this.getCursorPosition().getPosition();
        int sp = this.getSelectionPosition().getPosition();
        int cp = this.getCursorPosition().getPosition();
        int start = Math.min(sp, cp);
        int end = Math.max(sp, cp);
        if (!this.isWysiwyg()) {
            String str = "";
            if (this.selectingText) {
                p = start;
                str = this.getSelectedText();
            }
            this.addText(tag.node.toBBString());
            this.getCursorPosition().jumpTo(p + tag.node.getTag().length() + 2);
            this.addText(str);
            return;
        }
        if (!this.selectingText) {
            this.selectWord();
        }
        this.bbText.insertNode(tag.node.copy(), start, end);
        this.buildLines();
        this.getCursorPosition().jumpTo(p);
        this.selectingText = false;
    }

    @Override
    public void drawText(GuiRenderer renderer) {
        if (!this.isWysiwyg()) {
            super.drawText(renderer);
        } else {
            this.bbText.render(renderer, 2, 2, 0, this);
        }
    }
}

