/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityUtils {
    private static ForgeDirection[] facings = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.UNKNOWN};

    public static void spawnEjectedItem(World world, int x, int y, int z, ItemStack itemStack) {
        float rx = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float ry = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float rz = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), itemStack);
        float factor = 0.05f;
        entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)factor;
        entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
    }

    public static EntityPlayerMP findPlayerFromUUID(UUID uuid) {
        List listPlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP player : listPlayers) {
            if (!player.func_110124_au().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static ForgeDirection getEntityFacing(Entity entity) {
        return EntityUtils.getEntityFacing(entity, false);
    }

    public static ForgeDirection getEntityFacing(Entity entity, boolean sixWays) {
        return facings[EntityUtils.getEntityFacingInt(entity, sixWays)];
    }

    public static int getEntityFacingInt(Entity entity, boolean sixWays) {
        if (entity == null) {
            return 6;
        }
        float pitch = entity.field_70125_A;
        if (sixWays && pitch < -45.0f) {
            return 5;
        }
        if (sixWays && pitch > 45.0f) {
            return 4;
        }
        return MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    public static boolean isEquipped(EntityPlayer player, Item item) {
        return player != null && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == item;
    }

    public static boolean isEquipped(EntityPlayer player, ItemStack itemStack) {
        return EntityUtils.isEquipped(player, itemStack != null ? itemStack.func_77973_b() : null);
    }
}

