/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.model.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.model.IModelLoader;
import net.malisis.core.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class ObjFileImporter
implements IModelLoader {
    protected static Pattern linePattern = Pattern.compile("^(?<type>.*?) (?<data>.*)$");
    protected static Pattern facePattern = Pattern.compile("(?<v>\\d+)(/(?<t>\\d+)?(/(?<n>\\d+))?)?");
    protected Matcher matcher;
    protected String currentLine;
    protected int lineNumber;
    protected String currentShape = "Default";
    protected List<Vertex> vertexes = new ArrayList<Vertex>();
    protected List<UV> uvs = new ArrayList<UV>();
    protected List<Vector> normals = new ArrayList<Vector>();
    protected List<Face> faces = new ArrayList<Face>();
    protected Map<String, Shape> shapes = new HashMap<String, Shape>();

    public ObjFileImporter(ResourceLocation resourceLocation) {
        this.load(resourceLocation);
    }

    public ObjFileImporter(InputStream inputStream) {
        this.load(inputStream);
    }

    @Override
    public Map<String, Shape> getShapes() {
        return this.shapes;
    }

    public void load(ResourceLocation resourceLocation) {
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
            this.load(res.func_110527_b());
        }
        catch (IOException e) {
            MalisisCore.log.error("[ObjFileImporter] An error happened while reading the file : {}", new Object[]{resourceLocation, e});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(InputStream inputStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            block26: while ((this.currentLine = reader.readLine()) != null) {
                ++this.lineNumber;
                this.currentLine = this.currentLine.replaceAll("\\s+", " ").trim();
                this.matcher = linePattern.matcher(this.currentLine);
                if (this.matcher.matches()) {
                    String type = this.matcher.group("type");
                    String data = this.matcher.group("data");
                    switch (type) {
                        case "v": {
                            this.addVertex(data);
                            continue block26;
                        }
                        case "vn": {
                            this.addNormal(data);
                            continue block26;
                        }
                        case "vt": {
                            this.addUV(data);
                            continue block26;
                        }
                        case "f": {
                            this.addFace(data);
                            continue block26;
                        }
                        case "g": 
                        case "o": {
                            this.addShape(data);
                            continue block26;
                        }
                    }
                    MalisisCore.log.debug("[ObjFileImporter] Skipped type {} at line {} : {}", new Object[]{type, this.lineNumber, this.currentLine});
                    continue;
                }
                MalisisCore.log.debug("[ObjFileImporter] Skipped non-matching line {} : {}", new Object[]{this.lineNumber, this.currentLine});
            }
            this.addShape("");
            return;
        }
        catch (Exception e) {
            MalisisCore.log.error("[ObjFileImporter] An error happened while reading the file : {}", (Throwable)e);
        }
    }

    private void addVertex(String data) {
        String[] coords = data.split("\\s+");
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (coords.length != 3) {
            MalisisCore.log.error("[ObjFileImporter] Wrong coordinates number {} at line {} : {}", new Object[]{coords.length, this.lineNumber, this.currentLine});
        } else {
            x = Float.parseFloat(coords[0]);
            y = Float.parseFloat(coords[1]);
            z = Float.parseFloat(coords[2]);
        }
        this.vertexes.add(new Vertex(x, y, z));
    }

    private void addUV(String data) {
        String[] coords = data.split("\\s+");
        float u = 0.0f;
        float v = 0.0f;
        if (coords.length != 2) {
            MalisisCore.log.error("[ObjFileImporter] Wrong UV coordinates number {} at line {} : {}", new Object[]{coords.length, this.lineNumber, this.currentLine});
        } else {
            u = Float.parseFloat(coords[0]);
            v = 1.0f - Float.parseFloat(coords[1]);
        }
        this.uvs.add(new UV(u, v));
    }

    private void addNormal(String data) {
        String[] coords = data.split("\\s+");
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (coords.length != 3) {
            MalisisCore.log.error("[ObjFileImporter] Wrong Normal coordinates number {} at line {} : {}", new Object[]{coords.length, this.lineNumber, this.currentLine});
        } else {
            x = Float.parseFloat(coords[0]);
            y = Float.parseFloat(coords[1]);
            z = Float.parseFloat(coords[2]);
        }
        this.normals.add(new Vector(x, y, z));
    }

    private void addFace(String data) {
        this.matcher = facePattern.matcher(data);
        ArrayList<Vertex> faceVertex = new ArrayList<Vertex>();
        ArrayList<Vector> faceNormals = new ArrayList<Vector>();
        int v = 0;
        int t = 0;
        int n = 0;
        UV uv = null;
        while (this.matcher.find()) {
            Vector normal = null;
            uv = null;
            String strV = this.matcher.group("v");
            String strT = this.matcher.group("t");
            String strN = this.matcher.group("n");
            v = Integer.parseInt(strV);
            Vertex vertex = this.vertexes.get(v > 0 ? v - 1 : this.vertexes.size() - v - 1);
            if (vertex != null) {
                Vertex vertexCopy = new Vertex(vertex);
                if (strT != null && (uv = this.uvs.get((t = Integer.parseInt(strT)) > 0 ? t - 1 : this.uvs.size() - t - 1)) != null) {
                    vertexCopy.setUV(uv.u, uv.v);
                }
                faceVertex.add(vertexCopy);
                if (strN == null) continue;
                n = Integer.parseInt(strN);
                int n2 = n = n > 0 ? n - 1 : this.normals.size() - n - 1;
                if (n >= 0 && n < this.normals.size()) {
                    normal = this.normals.get(n);
                }
                if (normal == null) continue;
                faceNormals.add(new Vector(normal.x, normal.y, normal.z));
                continue;
            }
            MalisisCore.log.error("[ObjFileImporter] Wrong vertex reference {} for face at line {} :\n{}", new Object[]{v, this.lineNumber, this.currentLine});
        }
        Face f = new Face(faceVertex);
        f.deductParameters(faceNormals.toArray(new Vector[0]));
        RenderParameters params = f.getParameters();
        if (params.direction.get() == ForgeDirection.NORTH || params.direction.get() == ForgeDirection.EAST) {
            params.flipU.set(true);
        }
        params.renderAllFaces.set(true);
        params.interpolateUV.set(false);
        params.calculateAOColor.set(false);
        params.useBlockBrightness.set(false);
        this.faces.add(f);
    }

    private void addShape(String data) {
        if (this.faces.size() != 0) {
            Shape s = new Shape(this.faces);
            this.shapes.put(this.currentShape.toLowerCase(), s);
            this.faces.clear();
        }
        if (data != "" && data.indexOf(95) != -1) {
            this.currentShape = data.substring(0, data.indexOf(95));
        }
    }

    private class UV {
        float u;
        float v;

        public UV(float u, float v) {
            this.u = u;
            this.v = v;
        }
    }
}

