/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.IRenderWorldLast;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.RenderWorldEventHandler;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class MalisisRenderer
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer,
IRenderWorldLast {
    private static Map damagedBlocks;
    protected static IIcon[] damagedIcons;
    private boolean initialized = false;
    protected int renderId = -1;
    protected Tessellator t = Tessellator.field_78398_a;
    protected IBlockAccess world;
    protected RenderBlocks renderBlocks;
    protected boolean isShifted = false;
    protected Block block;
    protected int blockMetadata;
    protected int x;
    protected int y;
    protected int z;
    protected TileEntity tileEntity;
    protected float partialTick = 0.0f;
    protected ItemStack itemStack;
    protected IItemRenderer.ItemRenderType itemRenderType;
    protected RenderGlobal renderGlobal;
    protected RenderType renderType;
    protected int drawMode;
    protected Shape shape = new Cube();
    protected Face face;
    protected RenderParameters rp = new RenderParameters();
    protected RenderParameters params;
    protected int baseBrightness;
    protected IIcon overrideTexture;
    protected boolean getBlockDamage = false;
    protected DestroyBlockProgress destroyBlockProgress = null;
    protected boolean vertexDrawn = false;

    public MalisisRenderer() {
        this.renderId = RenderingRegistry.getNextAvailableRenderId();
        this.t = Tessellator.field_78398_a;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public void reset() {
        this.renderType = RenderType.UNSET;
        this.drawMode = 0;
        this.world = null;
        this.block = null;
        this.blockMetadata = 0;
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.overrideTexture = null;
        this.destroyBlockProgress = null;
    }

    public void set(IBlockAccess world, Block block, int x, int y, int z, int metadata) {
        this.world = world;
        this.block = block;
        this.blockMetadata = metadata;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(IBlockAccess world) {
        this.world = world;
    }

    public void set(Block block) {
        this.set(this.world, block, this.x, this.y, this.z, this.blockMetadata);
    }

    public void set(int blockMetadata) {
        this.set(this.world, this.block, this.x, this.y, this.z, blockMetadata);
    }

    public void set(Block block, int blockMetadata) {
        this.set(this.world, block, this.x, this.y, this.z, blockMetadata);
    }

    public void set(int x, int y, int z) {
        this.set(this.world, this.block, x, y, z, this.blockMetadata);
    }

    public void set(TileEntity te, float partialTick) {
        this.set((IBlockAccess)te.func_145831_w(), te.func_145838_q(), te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145832_p());
        this.partialTick = partialTick;
        this.tileEntity = te;
    }

    public void set(IItemRenderer.ItemRenderType type, ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            this.set(Block.func_149634_a((Item)itemStack.func_77973_b()));
        }
        this.itemStack = itemStack;
        this.itemRenderType = type;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.set(block, metadata);
        this.renderBlocks = renderer;
        this.prepare(RenderType.ISBRH_INVENTORY, new double[0]);
        this.render();
        this.clean();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.set(world, block, x, y, z, world.func_72805_g(x, y, z));
        this.tileEntity = world.func_147438_o(x, y, z);
        this.renderBlocks = renderer;
        this.vertexDrawn = false;
        this.prepare(RenderType.ISBRH_WORLD, new double[0]);
        if (renderer.func_147744_b()) {
            this.overrideTexture = renderer.field_147840_d;
        }
        this.render();
        this.clean();
        return this.vertexDrawn;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.set(type, item);
        this.prepare(RenderType.ITEM_INVENTORY, new double[0]);
        this.render();
        this.clean();
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float partialTick) {
        this.set(te, partialTick);
        this.prepare(RenderType.TESR_WORLD, x, y, z);
        this.render();
        if (this.getBlockDamage) {
            this.destroyBlockProgress = this.getBlockDestroyProgress();
            if (this.destroyBlockProgress != null) {
                this.next();
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)774, (int)768, (int)1, (int)0);
                GL11.glAlphaFunc((int)516, (float)0.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                this.t.func_78383_c();
                this.renderDestroyProgress();
                this.next();
                GL11.glDisable((int)3042);
            }
        }
        this.clean();
    }

    @Override
    public boolean shouldSetViewportPosition() {
        return true;
    }

    @Override
    public boolean shouldRender(RenderWorldLastEvent event, IBlockAccess world) {
        return true;
    }

    @Override
    public void renderWorldLastEvent(RenderWorldLastEvent event, IBlockAccess world) {
        this.set(world);
        this.partialTick = event.partialTicks;
        this.renderGlobal = event.context;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (this.shouldSetViewportPosition()) {
            EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
            x = -(p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)this.partialTick);
            y = -(p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)this.partialTick);
            z = -(p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)this.partialTick);
        }
        this.prepare(RenderType.WORLD_LAST, x, y, z);
        this.render();
        this.clean();
    }

    public void prepare(RenderType renderType, double ... data) {
        this._initialize();
        this.renderType = renderType;
        if (renderType == RenderType.ISBRH_WORLD) {
            this.tessellatorShift();
        } else if (renderType == RenderType.ISBRH_INVENTORY) {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            this.startDrawing();
        } else if (renderType == RenderType.ITEM_INVENTORY) {
            GL11.glPushAttrib((int)64);
            this.startDrawing();
        } else if (renderType == RenderType.TESR_WORLD) {
            GL11.glPushAttrib((int)64);
            RenderHelper.func_74518_a();
            GL11.glEnable((int)2903);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glTranslated((double)data[0], (double)data[1], (double)data[2]);
            this.func_147499_a(TextureMap.field_110575_b);
            this.startDrawing();
        } else if (renderType == RenderType.WORLD_LAST) {
            GL11.glPushAttrib((int)64);
            RenderHelper.func_74518_a();
            GL11.glEnable((int)2903);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glTranslated((double)data[0], (double)data[1], (double)data[2]);
            this.func_147499_a(TextureMap.field_110575_b);
            this.startDrawing();
        }
    }

    public void startDrawing() {
        this.startDrawing(7);
    }

    public void startDrawing(int drawMode) {
        this.t.func_78371_b(drawMode);
        this.drawMode = drawMode;
    }

    public void next() {
        this.next(this.drawMode);
    }

    public void next(int drawMode) {
        this.draw();
        this.startDrawing(drawMode);
    }

    public void draw() {
        this.t.func_78381_a();
    }

    public void clean() {
        if (this.renderType == RenderType.ISBRH_WORLD) {
            this.tessellatorUnshift();
        } else if (this.renderType == RenderType.ISBRH_INVENTORY) {
            this.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (this.renderType == RenderType.ITEM_INVENTORY) {
            this.draw();
            GL11.glPopAttrib();
        } else if (this.renderType == RenderType.TESR_WORLD) {
            this.draw();
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        } else if (this.renderType == RenderType.WORLD_LAST) {
            this.draw();
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
        this.reset();
    }

    public void tessellatorShift() {
        if (this.isShifted) {
            return;
        }
        this.isShifted = true;
        this.t.func_78372_c((float)this.x, (float)this.y, (float)this.z);
    }

    public void tessellatorUnshift() {
        if (!this.isShifted) {
            return;
        }
        this.isShifted = false;
        this.t.func_78372_c((float)(-this.x), (float)(-this.y), (float)(-this.z));
    }

    public void enableBlending() {
        if (this.renderType == RenderType.ISBRH_WORLD) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2903);
        GL11.glShadeModel((int)7425);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glAlphaFunc((int)516, (float)0.0f);
    }

    public void disableTextures() {
        GL11.glDisable((int)3553);
    }

    public void enableTextures() {
        GL11.glEnable((int)3553);
    }

    protected void func_147499_a(ResourceLocation resourceLocaltion) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocaltion);
    }

    protected final void _initialize() {
        if (this.initialized) {
            return;
        }
        this.initialize();
        this.initialized = true;
    }

    protected void initialize() {
    }

    public void renderStandard() {
        this.renderStandard(this.renderBlocks);
    }

    public void renderStandard(RenderBlocks renderer) {
        if (renderer == null) {
            return;
        }
        boolean b = this.isShifted;
        if (b) {
            this.tessellatorUnshift();
        }
        renderer.func_147775_a(this.block);
        renderer.func_147784_q(this.block, this.x, this.y, this.z);
        if (b) {
            this.tessellatorShift();
        }
    }

    public void render() {
        this.drawShape(this.shape, this.rp);
    }

    public void renderDestroyProgress() {
        if (this.destroyBlockProgress != null) {
            this.overrideTexture = damagedIcons[this.destroyBlockProgress.func_73106_e()];
        }
        this.render();
    }

    public void drawShape(Shape shape) {
        this.drawShape(shape, null);
    }

    public void drawShape(Shape s, RenderParameters params) {
        if (s == null) {
            return;
        }
        this.shape = s;
        this.rp = params != null ? params : new RenderParameters();
        s.applyMatrix();
        if (this.rp.vertexPositionRelativeToRenderBounds.get().booleanValue()) {
            this.calcVertexesPosition(this.getRenderBounds());
        }
        if (this.rp.applyTexture.get().booleanValue()) {
            this.applyTexture(s, this.rp);
        }
        for (Face f : s.getFaces()) {
            this.drawFace(f, f.getParameters());
        }
    }

    public void drawFace(Face face) {
        this.drawFace(face, face.getParameters());
    }

    protected void drawFace(Face f, RenderParameters faceParams) {
        if (f == null) {
            return;
        }
        int vertexCount = f.getVertexes().length;
        if (vertexCount != 4 && this.renderType == RenderType.ISBRH_WORLD) {
            MalisisCore.log.error("[MalisisRenderer] Attempting to render a face containing {} vertexes in ISBRH. Ignored", new Object[]{vertexCount});
            return;
        }
        this.face = f;
        this.params = RenderParameters.merge(this.rp, faceParams);
        if (!this.shouldRenderFace(this.face)) {
            return;
        }
        if ((this.renderType == RenderType.ITEM_INVENTORY || this.renderType == RenderType.ISBRH_INVENTORY || this.params.useNormals.get().booleanValue()) && this.params.direction.get() != null) {
            this.t.func_78375_b((float)this.params.direction.get().offsetX, (float)this.params.direction.get().offsetY, (float)this.params.direction.get().offsetZ);
        }
        this.baseBrightness = this.getBaseBrightness();
        this.drawVertexes(this.face.getVertexes());
        if (this.drawMode == 9 || this.drawMode == 6913 || this.drawMode == 3 || this.drawMode == 2) {
            this.next();
        }
    }

    protected void drawVertexes(Vertex[] vertexes) {
        for (int i = 0; i < vertexes.length; ++i) {
            this.drawVertex(vertexes[i], i);
        }
    }

    protected void drawVertex(Vertex vertex, int number) {
        if (vertex == null) {
            vertex = new Vertex(0.0, 0.0, 0.0);
        }
        int brightness = this.calcVertexBrightness(vertex, (int[][])this.params.aoMatrix.get(number));
        vertex.setBrightness(brightness);
        int color = this.calcVertexColor(vertex, (int[][])this.params.aoMatrix.get(number));
        vertex.setColor(color);
        if (!this.params.usePerVertexAlpha.get().booleanValue()) {
            vertex.setAlpha(this.params.alpha.get());
        }
        this.t.func_78384_a(vertex.getColor(), vertex.getAlpha());
        this.t.func_78380_c(vertex.getBrightness());
        if (this.params.useTexture.get().booleanValue()) {
            this.t.func_78374_a(vertex.getX(), vertex.getY(), vertex.getZ(), vertex.getU(), vertex.getV());
        } else {
            this.t.func_78377_a(vertex.getX(), vertex.getY(), vertex.getZ());
        }
        this.vertexDrawn = true;
    }

    public void drawString(String text, float x, float y, float z, int color, boolean shadow) {
        if (MalisisRenderer.getFontRenderer() == null) {
            return;
        }
        text = StatCollector.func_74838_a((String)text);
        text = text.replaceAll("\r", "");
        GL11.glPushMatrix();
        float s = 0.01f;
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glScalef((float)s, (float)(-s), (float)s);
        GL11.glDisable((int)32826);
        MalisisRenderer.getFontRenderer().func_85187_a(text, 0, 0, color, shadow);
        GL11.glPopMatrix();
        GL11.glEnable((int)32826);
    }

    protected IIcon getIcon(RenderParameters params) {
        Object icon = params.icon.get();
        if (params.useCustomTexture.get().booleanValue()) {
            icon = new MalisisIcon();
        } else if (this.overrideTexture != null) {
            icon = this.overrideTexture;
        } else if (this.block != null && icon == null) {
            int side = 0;
            if (params.textureSide.get() != null) {
                side = params.textureSide.get().ordinal();
            }
            icon = this.world != null && params.useWorldSensitiveIcon.get() != false ? this.block.func_149673_e(this.world, this.x, this.y, this.z, side) : this.block.func_149691_a(side, this.blockMetadata);
        }
        return icon;
    }

    protected boolean shouldRenderFace(Face face) {
        if (this.renderType != RenderType.ISBRH_WORLD || this.world == null || this.block == null) {
            return true;
        }
        if (this.rp != null && this.rp.renderAllFaces.get().booleanValue()) {
            return true;
        }
        if (this.renderBlocks != null && this.renderBlocks.field_147837_f) {
            return true;
        }
        RenderParameters p = face.getParameters();
        if (p.direction.get() == null || p.renderAllFaces.get().booleanValue()) {
            return true;
        }
        boolean b = this.block.func_149646_a(this.world, this.x + p.direction.get().offsetX, this.y + p.direction.get().offsetY, this.z + p.direction.get().offsetZ, p.direction.get().ordinal());
        return b;
    }

    public void applyTexture(Shape shape) {
        this.applyTexture(shape, null);
    }

    public void applyTexture(Shape shape, RenderParameters parameters) {
        Face[] arr$ = shape.getFaces();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Face f;
            this.face = f = arr$[i$];
            RenderParameters params = RenderParameters.merge(f.getParameters(), parameters);
            IIcon icon = this.getIcon(params);
            if (icon == null) continue;
            boolean flipU = params.flipU.get();
            if (params.direction.get() == ForgeDirection.NORTH || params.direction.get() == ForgeDirection.EAST) {
                flipU = !flipU;
            }
            f.setTexture(icon, flipU, params.flipV.get(), params.interpolateUV.get());
        }
    }

    protected int calcVertexColor(Vertex vertex, int[][] aoMatrix) {
        int color = 0xFFFFFF;
        if (this.params.usePerVertexColor.get().booleanValue()) {
            color = vertex.getColor();
        }
        if (this.params.colorMultiplier.get() != null) {
            color = this.params.colorMultiplier.get();
        } else if (this.block != null) {
            int n = color = this.world != null ? this.block.func_149720_d(this.world, this.x, this.y, this.z) : this.block.func_149741_i(this.blockMetadata);
        }
        if (this.drawMode == 6913) {
            return color;
        }
        if (this.renderType != RenderType.ISBRH_WORLD && this.renderType != RenderType.TESR_WORLD) {
            return color;
        }
        float factor = 1.0f;
        if (this.params.calculateAOColor.get().booleanValue() && aoMatrix != null && Minecraft.func_71379_u() && this.block.getLightValue(this.world, this.x, this.y, this.z) == 0) {
            factor = this.getBlockAmbientOcclusion(this.world, this.x + this.params.direction.get().offsetX, this.y + this.params.direction.get().offsetY, this.z + this.params.direction.get().offsetZ);
            for (int i = 0; i < aoMatrix.length; ++i) {
                factor += this.getBlockAmbientOcclusion(this.world, this.x + aoMatrix[i][0], this.y + aoMatrix[i][1], this.z + aoMatrix[i][2]);
            }
            factor /= (float)(aoMatrix.length + 1);
        }
        int r = (int)((float)(color >> 16 & 0xFF) * (factor *= this.params.colorFactor.get().floatValue()));
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        color = r << 16 | g << 8 | b;
        return color;
    }

    protected int getBaseBrightness() {
        if (this.renderType != RenderType.ISBRH_WORLD && this.renderType != RenderType.TESR_WORLD || this.world == null || !this.params.useBlockBrightness.get().booleanValue()) {
            return this.params.brightness.get();
        }
        if (this.params.direction.get() == null) {
            return this.block.func_149677_c(this.world, this.x, this.y, this.z);
        }
        AxisAlignedBB bounds = this.getRenderBounds();
        ForgeDirection dir = this.params.direction.get();
        int ox = this.x + dir.offsetX;
        int oy = this.y + dir.offsetY;
        int oz = this.z + dir.offsetZ;
        if (bounds != null) {
            if (dir == ForgeDirection.WEST && bounds.field_72340_a > 0.0) {
                ++ox;
            } else if (dir == ForgeDirection.EAST && bounds.field_72336_d < 1.0) {
                --ox;
            } else if (dir == ForgeDirection.NORTH && bounds.field_72339_c > 0.0) {
                ++oz;
            } else if (dir == ForgeDirection.SOUTH && bounds.field_72334_f < 1.0) {
                --oz;
            } else if (dir == ForgeDirection.DOWN && bounds.field_72338_b > 0.0) {
                ++oy;
            } else if (dir == ForgeDirection.UP && bounds.field_72337_e < 1.0) {
                --oy;
            }
        }
        return this.getMixedBrightnessForBlock(this.world, ox, oy, oz);
    }

    protected int calcVertexBrightness(Vertex vertex, int[][] aoMatrix) {
        if (this.params.usePerVertexBrightness.get().booleanValue()) {
            return vertex.getBrightness();
        }
        if (this.drawMode == 6913) {
            return this.baseBrightness;
        }
        if (this.renderType != RenderType.ISBRH_WORLD && this.renderType != RenderType.TESR_WORLD) {
            return this.baseBrightness;
        }
        if (!this.params.calculateBrightness.get().booleanValue() || aoMatrix == null) {
            return this.baseBrightness;
        }
        if (!Minecraft.func_71379_u() || this.block.getLightValue(this.world, this.x, this.y, this.z) != 0) {
            return this.baseBrightness;
        }
        int[] b = new int[Math.max(3, aoMatrix.length)];
        for (int i = 0; i < b.length; ++i) {
            int n = i;
            b[n] = b[n] + this.getMixedBrightnessForBlock(this.world, this.x + aoMatrix[i][0], this.y + aoMatrix[i][1], this.z + aoMatrix[i][2]);
        }
        int brightness = this.getAoBrightness(b[0], b[1], b[2], this.baseBrightness);
        return brightness;
    }

    protected int getAoBrightness(int b1, int b2, int b3, int base) {
        if (b1 == 0) {
            b1 = base;
        }
        if (b2 == 0) {
            b2 = base;
        }
        if (b3 == 0) {
            b3 = base;
        }
        return b1 + b2 + b3 + base >> 2 & 0xFF00FF;
    }

    protected float getBlockAmbientOcclusion(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return 1.0f;
        }
        return block.func_149685_I();
    }

    protected int getMixedBrightnessForBlock(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149677_c(world, x, y, z);
    }

    protected AxisAlignedBB getRenderBounds() {
        if (this.block == null || !this.rp.useBlockBounds.get().booleanValue()) {
            return this.rp.renderBounds.get();
        }
        if (this.world != null) {
            this.block.func_149719_a(this.world, this.x, this.y, this.z);
        }
        return AxisAlignedBB.func_72330_a((double)this.block.func_149704_x(), (double)this.block.func_149665_z(), (double)this.block.func_149706_B(), (double)this.block.func_149753_y(), (double)this.block.func_149669_A(), (double)this.block.func_149693_C());
    }

    protected void calcVertexesPosition(AxisAlignedBB bounds) {
        if (bounds == null) {
            return;
        }
        Face[] arr$ = this.shape.getFaces();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Face f;
            this.face = f = arr$[i$];
            for (Vertex v : f.getVertexes()) {
                v.interpolateCoord(bounds);
            }
        }
    }

    protected Map getDamagedBlocks() {
        if (damagedBlocks != null) {
            return damagedBlocks;
        }
        try {
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            Field f = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{MalisisCore.isObfEnv ? "field_94141_F" : "destroyBlockIcons"});
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            damagedIcons = (IIcon[])f.get(Minecraft.func_71410_x().field_71438_f);
            f = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{MalisisCore.isObfEnv ? "field_72738_E" : "damagedBlocks"});
            modifiers.setInt(f, f.getModifiers());
            damagedBlocks = (HashMap)f.get(Minecraft.func_71410_x().field_71438_f);
            return damagedBlocks;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected DestroyBlockProgress getBlockDestroyProgress() {
        if (this.renderType != RenderType.TESR_WORLD) {
            return null;
        }
        Map damagedBlocks = this.getDamagedBlocks();
        if (damagedBlocks == null || damagedBlocks.isEmpty()) {
            return null;
        }
        for (DestroyBlockProgress dbp : damagedBlocks.values()) {
            if (!this.isCurrentBlockDestroyProgress(dbp)) continue;
            return dbp;
        }
        return null;
    }

    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        return dbp.func_73110_b() == this.x && dbp.func_73109_c() == this.y && dbp.func_73108_d() == this.z;
    }

    public int getRenderId() {
        return this.renderId;
    }

    public void registerFor(Class ... listClass) {
        for (Class clazz : listClass) {
            if (Block.class.isAssignableFrom(clazz)) {
                try {
                    clazz.getField("renderId").set(null, this.renderId);
                    RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this);
                }
                catch (ReflectiveOperationException e) {
                    MalisisCore.log.error("[MalisisRenderer] Tried to register ISBRH for block class {} that does not have renderId field", new Object[]{clazz.getSimpleName()});
                    e.printStackTrace();
                }
                continue;
            }
            if (!TileEntity.class.isAssignableFrom(clazz)) continue;
            ClientRegistry.bindTileEntitySpecialRenderer((Class)clazz, (TileEntitySpecialRenderer)this);
        }
    }

    public void registerFor(Item item) {
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)this);
    }

    public void registerForRenderWorldLast() {
        RenderWorldEventHandler.register(this);
    }

    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static int getStringWidth(String str) {
        str = StatCollector.func_74838_a((String)str);
        str = str.replaceAll("\r", "");
        return (int)Math.ceil((float)MalisisRenderer.getFontRenderer().func_78256_a(str) * 0.01f);
    }

    public static int getStringHeight() {
        return (int)Math.ceil((float)MalisisRenderer.getFontRenderer().field_78288_b * 0.01f);
    }
}

