/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.element;

import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;

public abstract class GuiShape
extends Shape {
    public GuiShape(Face ... faces) {
        super(faces);
    }

    public GuiShape(int faceCount) {
        this.faces = new Face[faceCount];
        for (int i = 0; i < faceCount; ++i) {
            this.faces[i] = new GuiFace();
        }
    }

    public void setPosition(int x, int y) {
        this.translate(x, y, 0.0f);
    }

    @Override
    public void translate(float x, float y, float z) {
        super.translate(x, y, z);
        this.applyMatrix();
    }

    public void translate(int x, int y) {
        this.translate(x, y, 0.0f);
    }

    @Override
    public void rotate(float angle, float x, float y, float z) {
        this.rotate(angle, 0.0f, 0.0f, 1.0f, x, y, z);
    }

    public void rotate(float angle) {
    }

    @Override
    public void scale(float scale) {
        this.scale(scale, scale);
    }

    public abstract void setSize(int var1, int var2);

    public abstract void scale(float var1, float var2);

    public static class GuiFace
    extends Face {
        public GuiFace() {
            super(new Vertex.BottomSouthWest().setBaseName("TopLeft"), new Vertex.TopSouthWest().setBaseName("BottomLeft"), new Vertex.TopSouthEast().setBaseName("BottomRight"), new Vertex.BottomSouthEast().setBaseName("TopRight"));
            this.setStandardUV();
        }

        public GuiFace(int width, int height) {
            this();
            this.factor(width, height, 0.0f);
        }
    }
}

