/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.element.XResizableGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.malisis.core.util.MouseButton;
import net.minecraft.util.IIcon;

public class UISlider
extends UIComponent<UISlider> {
    public static int SLIDER_WIDTH = 8;
    protected GuiIcon iconBackground;
    protected GuiIcon sliderIcon;
    private String label;
    private float minValue;
    private float maxValue;
    private float value;
    private float offset;
    private GuiShape sliderShape;

    public UISlider(MalisisGui gui, int width, float min, float max, String label) {
        super(gui);
        this.setSize(width, 20);
        this.minValue = min;
        this.maxValue = max;
        this.label = label;
        this.shape = new XResizableGuiShape();
        this.sliderShape = new SimpleGuiShape();
        this.sliderShape.setSize(8, 20);
        this.sliderShape.storeState();
        this.iconBackground = gui.getGuiTexture().getXResizableIcon(0, 0, 200, 20, 5);
        this.sliderIcon = gui.getGuiTexture().getIcon(227, 46, 8, 20);
    }

    public UISlider(MalisisGui gui, int width, float min, float max) {
        this(gui, width, min, max, null);
    }

    @Override
    public boolean onClick(int x, int y) {
        this.slideTo(x);
        return true;
    }

    @Override
    public boolean onScrollWheel(int x, int y, int delta) {
        this.slideBy(delta);
        return true;
    }

    @Override
    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        this.slideTo(x);
        return true;
    }

    public void slideTo(int x) {
        int l = this.width - SLIDER_WIDTH;
        int pos = this.relativeX(x);
        pos = Math.max(0, Math.min(pos - SLIDER_WIDTH / 2, l));
        this.slideTo((float)pos / (float)l);
    }

    public void slideTo(float offset) {
        if (this.isDisabled()) {
            return;
        }
        if (offset < 0.0f) {
            offset = 0.0f;
        }
        if (offset > 1.0f) {
            offset = 1.0f;
        }
        this.offset = offset;
        float oldValue = this.value;
        float newValue = this.minValue + (this.maxValue - this.minValue) * offset;
        if (this.fireEvent(new ComponentEvent.ValueChange<UISlider, Float>(this, Float.valueOf(oldValue), Float.valueOf(newValue)))) {
            this.value = newValue;
        }
    }

    public void slideBy(float amount) {
        this.slideTo(this.offset + (amount *= 0.05f));
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.rp.icon.set((IIcon)this.iconBackground);
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.zIndex = 0;
        int ox = (int)(this.offset * (float)(this.width - SLIDER_WIDTH));
        this.sliderShape.resetState();
        this.sliderShape.setPosition(ox, 0);
        this.rp.icon.set((IIcon)this.sliderIcon);
        renderer.drawShape(this.sliderShape, this.rp);
        renderer.next();
        if (this.label != null) {
            String str = String.format(this.label, Float.valueOf(this.value));
            int x = (this.width - GuiRenderer.getStringWidth(str)) / 2;
            int y = 6;
            renderer.drawText(str, x, y, this.isHovered() ? 0xFFFFA0 : 0xFFFFFF, true);
        }
    }
}

