/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IClipable;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.element.XResizableGuiShape;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import org.apache.commons.lang3.StringUtils;

public class UISelect<T>
extends UIComponent<UISelect<T>>
implements Iterable<Option<T>>,
IClipable {
    protected FluentIterable<Option<T>> options;
    protected Option<T> selectedOption = null;
    protected int maxExpandedWidth = -1;
    protected int maxDisplayedOptions = -1;
    protected boolean expanded = false;
    protected int optionsWidth = 0;
    protected int optionsHeight = 0;
    protected String labelPattern;
    protected Function<T, ? extends Option<T>> optionFunction;
    protected Function<T, String> labelFunction = Functions.toStringFunction();
    protected Predicate<T> disablePredicate = Predicates.alwaysFalse();
    private Function<T, Option<T>> toOption = new Function<T, Option<T>>(){

        public Option<T> apply(T input) {
            Option option = UISelect.this.optionFunction != null ? (Option)UISelect.this.optionFunction.apply(input) : new Option(input);
            option.setLabel((String)UISelect.this.labelFunction.apply(input));
            option.setDisabled(UISelect.this.disablePredicate.apply(input));
            return option;
        }
    };
    protected int textColor = 0xFFFFFF;
    protected int bgColor = 0xFFFFFF;
    protected int hoverTextColor = 14604447;
    protected int hoverBgColor = 6191263;
    protected int selectTextColor = 10397919;
    protected int disabledTextColor = 0x444444;
    protected boolean textShadow = true;
    protected GuiShape arrowShape;
    protected GuiShape optionsShape;
    protected GuiShape optionBackground;
    protected GuiIcon iconsSelect;
    protected GuiIcon iconsSelectDisabled;
    protected GuiIcon iconsExpanded;
    protected GuiIcon arrowIcon;

    public UISelect(MalisisGui gui, int width, Iterable<T> values) {
        super(gui);
        this.setSize(width, 12);
        this.setOptions(values);
        this.shape = new XResizableGuiShape(3);
        this.arrowShape = new SimpleGuiShape();
        this.arrowShape.setSize(7, 4);
        this.arrowShape.storeState();
        this.optionsShape = new XYResizableGuiShape(1);
        this.optionBackground = new SimpleGuiShape();
        this.iconsSelect = gui.getGuiTexture().getXResizableIcon(200, 30, 9, 12, 3);
        this.iconsSelectDisabled = gui.getGuiTexture().getXResizableIcon(200, 42, 9, 12, 3);
        this.iconsExpanded = gui.getGuiTexture().getXYResizableIcon(200, 30, 9, 12, 1);
        this.arrowIcon = gui.getGuiTexture().getIcon(209, 48, 7, 4);
    }

    public UISelect(MalisisGui gui, int width) {
        this(gui, width, null);
    }

    public int getTextColor() {
        return this.textColor;
    }

    public UISelect<T> setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public UISelect<T> setBgColor(int bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public int getHoverTextColor() {
        return this.hoverTextColor;
    }

    public UISelect<T> setHoverTextColor(int hoverTextColor) {
        this.hoverTextColor = hoverTextColor;
        return this;
    }

    public int getHoverBgColor() {
        return this.hoverBgColor;
    }

    public UISelect<T> setHoverBgColor(int hoverBgColor) {
        this.hoverBgColor = hoverBgColor;
        return this;
    }

    public int getSelectTextColor() {
        return this.selectTextColor;
    }

    public UISelect<T> setSelectTextColor(int selectTextColor) {
        this.selectTextColor = selectTextColor;
        return this;
    }

    public int getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public UISelect<T> setDisabledTextColor(int disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
        return this;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public UISelect<T> setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    public UISelect<T> setColors(int textColor, int bgColor, int hoverTextColor, int hoverBgColor, int selectTextColor, int disabledTextColor, boolean textShadow) {
        this.textColor = textColor;
        this.bgColor = bgColor;
        this.hoverTextColor = hoverTextColor;
        this.hoverBgColor = hoverBgColor;
        this.selectTextColor = selectTextColor;
        this.disabledTextColor = disabledTextColor;
        this.textShadow = textShadow;
        return this;
    }

    public UISelect<T> setOptionFunction(Function<T, ? extends Option<T>> func) {
        this.optionFunction = func;
        return this;
    }

    public UISelect<T> setLabelFunction(Function<T, String> func) {
        if (func == null) {
            func = Functions.toStringFunction();
        }
        this.labelFunction = func;
        this.calcOptionsSize();
        return this;
    }

    public UISelect<T> setDisablePredicate(Predicate<T> predicate) {
        if (predicate == null) {
            predicate = Predicates.alwaysFalse();
        }
        this.disablePredicate = predicate;
        return this;
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused && this.expanded) {
            this.expanded = false;
        }
    }

    public UISelect<T> setLabelPattern(String labelPattern) {
        this.labelPattern = labelPattern;
        this.calcOptionsSize();
        return this;
    }

    public UISelect<T> setMaxExpandedWidth(int width) {
        this.maxExpandedWidth = width;
        this.calcOptionsSize();
        return this;
    }

    private void calcOptionsSize() {
        this.optionsWidth = this.getWidth() - 4;
        for (Option<T> option : this) {
            this.optionsWidth = Math.max(this.optionsWidth, GuiRenderer.getStringWidth(option.getLabel(this.labelPattern)));
        }
        this.optionsWidth += 4;
        if (this.maxExpandedWidth > 0) {
            this.optionsWidth = Math.min(this.maxExpandedWidth, this.optionsWidth);
        }
    }

    public UISelect<T> maxDisplayedOptions(int amount) {
        this.maxDisplayedOptions = amount;
        this.calcOptionsSize();
        return this;
    }

    public UISelect<T> setOptions(Iterable<T> values) {
        if (values == null) {
            values = Collections.EMPTY_LIST;
        }
        this.options = FluentIterable.from((Iterable)values).transform(this.toOption);
        this.calcOptionsSize();
        return this;
    }

    public Option getOption(T obj) {
        for (Option<T> opt : this) {
            if (obj != opt.getKey()) continue;
            return opt;
        }
        return null;
    }

    public void setSelectedOption(T obj) {
        this.setSelectedOption(this.getOption(obj));
    }

    public void setSelectedOption(Option<T> option) {
        this.selectedOption = option;
    }

    public Option<T> getSelectedOption() {
        return this.selectedOption;
    }

    public T getSelectedValue() {
        Option<T> opt = this.getSelectedOption();
        if (opt == null) {
            return null;
        }
        return opt.getKey();
    }

    public T select(Option<T> option) {
        Object value;
        if (option == null || option.isDisabled()) {
            return this.getSelectedValue();
        }
        Object t = value = option != null ? (Object)option.getKey() : null;
        if (option.equals(this.selectedOption)) {
            return value;
        }
        if (this.fireEvent(new SelectEvent<Object>(this, value))) {
            this.setSelectedOption(option);
        }
        return this.getSelectedValue();
    }

    public T select(T obj) {
        return (T)this.select((T)this.getOption(obj));
    }

    public T selectFirst() {
        return (T)this.select((T)((Option)Iterables.getFirst(this.options, null)));
    }

    public T selectLast() {
        return (T)this.select((T)((Option)Iterables.getLast(this.options, null)));
    }

    public T selectPrevious() {
        if (this.selectedOption == null) {
            return this.selectFirst();
        }
        Option<T> option = null;
        for (Option<T> opt : this) {
            if (opt.isDisabled()) continue;
            if (opt.equals(this.selectedOption)) {
                return (T)this.select((T)option);
            }
            option = opt;
        }
        return null;
    }

    public T selectNext() {
        if (this.selectedOption == null) {
            return this.selectFirst();
        }
        Option<T> option = null;
        for (Option<T> opt : this) {
            if (opt.isDisabled()) continue;
            if (this.selectedOption.equals(option)) {
                return (T)this.select((T)opt);
            }
            option = opt;
        }
        return null;
    }

    protected Option<T> getOptionAt(int mouseX, int mouseY) {
        if (!this.isInsideBounds(mouseX, mouseY)) {
            return null;
        }
        int y = this.relativeY(mouseY - 13);
        if (y < 0) {
            return null;
        }
        int cy = 0;
        for (Option<T> option : this) {
            if (cy + option.getHeight() > y) {
                return option;
            }
            cy += option.getHeight();
        }
        return null;
    }

    @Override
    public boolean isInsideBounds(int x, int y) {
        if (super.isInsideBounds(x, y)) {
            return true;
        }
        if (!this.expanded || !this.isVisible()) {
            return false;
        }
        return x >= this.screenX() && x <= this.screenX() + this.optionsWidth && y >= this.screenY() + 12 && y <= this.screenY() + 12 + this.optionsHeight;
    }

    @Override
    public int getZIndex() {
        return super.getZIndex() + (this.expanded ? 300 : 0);
    }

    @Override
    public ClipArea getClipArea() {
        return new ClipArea(this, this.screenX(), this.screenY(), this.screenX() + this.optionsWidth, this.screenY() + this.optionsHeight + 12, false);
    }

    @Override
    public void setClipContent(boolean clip) {
    }

    @Override
    public boolean shouldClipContent() {
        return this.expanded;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.shape.resetState();
        this.shape.setSize(super.getWidth(), super.getHeight());
        this.rp.icon.set((IIcon)(this.isDisabled() ? this.iconsSelectDisabled : this.iconsSelect));
        this.rp.colorMultiplier.set(this.bgColor);
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.optionsHeight = 10 * (this.maxDisplayedOptions == -1 ? this.options.size() : this.maxDisplayedOptions) + 2;
        if (this.optionsHeight < 10) {
            this.optionsHeight = 10;
        }
        if (this.selectedOption != null) {
            this.select(this.selectedOption.getKey());
        }
        this.arrowShape.resetState();
        this.arrowShape.setPosition(this.width - 9, 4);
        if (this.isHovered() || this.expanded) {
            this.rp.colorMultiplier.set(12503295);
        } else {
            this.rp.colorMultiplier.reset();
        }
        this.rp.icon.set((IIcon)this.arrowIcon);
        renderer.drawShape(this.arrowShape, this.rp);
        if (this.selectedOption != null) {
            this.selectedOption.draw(this, renderer, 2, 2, 2, partialTick, false, true);
        }
        if (!this.expanded) {
            return;
        }
        renderer.next();
        ClipArea area = this.getClipArea();
        renderer.startClipping(area);
        this.optionsShape.resetState();
        this.optionsShape.setSize(this.optionsWidth, this.optionsHeight);
        this.optionsShape.translate(0.0f, 12.0f, 1.0f);
        this.rp.icon.set((IIcon)this.iconsExpanded);
        this.rp.colorMultiplier.set(this.bgColor);
        renderer.drawShape(this.optionsShape, this.rp);
        renderer.next();
        int y = 14;
        Option<T> hover = this.getOptionAt(mouseX, mouseY);
        for (Option<T> option : this) {
            option.draw(this, renderer, 0, y, 0, partialTick, option.equals(hover), false);
            y += option.getHeight();
        }
        renderer.endClipping(area);
    }

    @Override
    public boolean onClick(int x, int y) {
        if (!this.expanded) {
            this.expanded = true;
            return true;
        }
        Option<T> opt = this.getOptionAt(x, y);
        if (opt != null) {
            if (opt.isDisabled()) {
                this.setFocused(true);
                return true;
            }
            this.select((T)opt);
        }
        this.expanded = false;
        this.setFocused(true);
        return true;
    }

    @Override
    public boolean onScrollWheel(int x, int y, int delta) {
        if (!this.isFocused()) {
            return super.onScrollWheel(x, y, delta);
        }
        if (delta < 0) {
            this.selectNext();
        } else {
            this.selectPrevious();
        }
        return true;
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (!this.isFocused()) {
            return super.onKeyTyped(keyChar, keyCode);
        }
        switch (keyCode) {
            case 200: {
                this.selectPrevious();
                break;
            }
            case 208: {
                this.selectNext();
                break;
            }
            case 199: {
                this.selectFirst();
                break;
            }
            case 207: {
                this.selectLast();
                break;
            }
            default: {
                return super.onKeyTyped(keyChar, keyCode);
            }
        }
        return true;
    }

    @Override
    public Iterator<Option<T>> iterator() {
        return this.options.iterator();
    }

    public static class SelectEvent<T>
    extends ComponentEvent.ValueChange<UISelect, T> {
        public SelectEvent(UISelect<T> component, T newValue) {
            super(component, component.getSelectedValue(), newValue);
        }
    }

    public static class Option<T> {
        private T key;
        private String label;
        private boolean disabled;

        public Option(T key) {
            this.key = key;
        }

        public Option(T key, String label) {
            this.key = key;
            this.label = label;
        }

        public T getKey() {
            return this.key;
        }

        public String getLabel(String pattern) {
            if (pattern == null) {
                return this.label;
            }
            return String.format(pattern, this.label);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public int getHeight() {
            return GuiRenderer.getStringHeight() + 1;
        }

        public void draw(UISelect select, GuiRenderer renderer, int x, int y, int z, float partialTick, boolean hovered, boolean isTop) {
            String text = this.getLabel(select.labelPattern);
            if (StringUtils.isEmpty((CharSequence)text)) {
                return;
            }
            if (hovered && !this.disabled) {
                renderer.drawRectangle(x + 1, y - 1, z + 2, select.optionsWidth - 2, this.getHeight(), select.getHoverBgColor(), 255);
            }
            if (isTop) {
                text = GuiRenderer.clipString(text, select.getWidth() - 15);
            }
            int color = this.equals(select.getSelectedOption()) && !isTop ? select.getSelectTextColor() : select.getTextColor();
            boolean shadow = select.isTextShadow();
            if (hovered) {
                color = select.getHoverTextColor();
            }
            if (this.disabled) {
                text = EnumChatFormatting.ITALIC + text;
                color = select.getDisabledTextColor();
                shadow = false;
            }
            renderer.drawText(text, x + 2, y, z + 2, color, shadow, true);
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Option && this.key.equals(((Option)obj).key);
        }
    }
}

