/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.malisis.core.renderer.RenderParameters;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class UIRadioButton
extends UIComponent<UIRadioButton> {
    private static HashMap<String, List<UIRadioButton>> radioButtons = new HashMap();
    protected GuiIcon bgIcon;
    protected GuiIcon bgIconDisabled;
    protected GuiIcon rbDisabled;
    protected GuiIcon rbChecked;
    protected GuiIcon rbHovered;
    private String name;
    private String label;
    private boolean selected;

    public UIRadioButton(MalisisGui gui, String name, String label) {
        super(gui);
        this.name = name;
        if (label != null && !label.equals("")) {
            this.label = label;
            this.width = GuiRenderer.getStringWidth(label);
        }
        this.setSize(this.width + 10, 11);
        this.shape = new SimpleGuiShape();
        this.bgIcon = gui.getGuiTexture().getIcon(200, 54, 8, 8);
        this.bgIconDisabled = gui.getGuiTexture().getIcon(200, 62, 8, 8);
        this.rbDisabled = gui.getGuiTexture().getIcon(208, 54, 6, 6);
        this.rbChecked = gui.getGuiTexture().getIcon(214, 54, 6, 6);
        this.rbHovered = gui.getGuiTexture().getIcon(220, 54, 6, 6);
        UIRadioButton.addRadioButton(this);
    }

    public UIRadioButton(MalisisGui gui, String name) {
        this(gui, name, null);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected() {
        UIRadioButton rb = UIRadioButton.getSelected(this.name);
        if (rb != null) {
            rb.selected = false;
        }
        this.selected = true;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.shape.resetState();
        this.shape.setSize(8, 8);
        this.shape.translate(1.0f, 0.0f, 0.0f);
        this.rp.icon.set((IIcon)(this.isDisabled() ? this.bgIconDisabled : this.bgIcon));
        renderer.drawShape(this.shape, this.rp);
        renderer.next();
        if (this.hovered) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3008);
            renderer.enableBlending();
            this.rp = new RenderParameters();
            this.rp.colorMultiplier.set(0xFFFFFF);
            this.rp.alpha.set(80);
            this.rp.useTexture.set(false);
            this.shape.resetState();
            this.shape.setSize(6, 6);
            this.shape.setPosition(2, 1);
            renderer.drawShape(this.shape, this.rp);
            renderer.next();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3553);
        }
        if (this.label != null) {
            renderer.drawText(this.label, 12, 0, 0x404040, false);
        }
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.selected) {
            GL11.glEnable((int)3042);
            this.rp.reset();
            this.shape.resetState();
            this.shape.setSize(6, 6);
            this.shape.setPosition(2, 1);
            this.rp.icon.set((IIcon)(this.isDisabled() ? this.rbDisabled : (this.isHovered() ? this.rbHovered : this.rbChecked)));
            renderer.drawShape(this.shape, this.rp);
        }
    }

    @Override
    public boolean onClick(int x, int y) {
        if (this.fireEvent(new SelectEvent(this))) {
            this.setSelected();
        }
        return true;
    }

    public static void addRadioButton(UIRadioButton rb) {
        List<UIRadioButton> listRb = radioButtons.get(rb.name);
        if (listRb == null) {
            listRb = new ArrayList<UIRadioButton>();
        }
        listRb.add(rb);
        radioButtons.put(rb.name, listRb);
    }

    public static UIRadioButton getSelected(String name) {
        List<UIRadioButton> listRb = radioButtons.get(name);
        if (listRb == null) {
            return null;
        }
        for (UIRadioButton rb : listRb) {
            if (!rb.selected) continue;
            return rb;
        }
        return null;
    }

    public static UIRadioButton getSelected(UIRadioButton rb) {
        return UIRadioButton.getSelected(rb.name);
    }

    public static class SelectEvent
    extends ComponentEvent.ValueChange<UIRadioButton, UIRadioButton> {
        public SelectEvent(UIRadioButton component) {
            super(component, UIRadioButton.getSelected(component), component);
        }
    }
}

