/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import com.google.common.eventbus.Subscribe;
import java.util.LinkedList;
import java.util.List;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.control.IScrollable;
import net.malisis.core.client.gui.component.control.UISlimScrollbar;
import net.malisis.core.client.gui.event.component.ContentUpdateEvent;
import net.malisis.core.client.gui.event.component.SpaceChangeEvent;
import net.malisis.core.util.bbcode.BBString;
import net.malisis.core.util.bbcode.render.BBCodeRenderer;
import net.malisis.core.util.bbcode.render.IBBCodeRenderer;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.lang3.StringUtils;

public class UILabel
extends UIComponent<UILabel>
implements IScrollable,
IBBCodeRenderer<UILabel> {
    protected String text;
    protected BBString bbText;
    protected BBCodeRenderer bbRenderer;
    protected List<String> lines = new LinkedList<String>();
    protected boolean multiLine = false;
    protected int lineOffset = 0;
    protected int lineSpacing = 1;
    protected float fontScale = 1.0f;
    protected UISlimScrollbar scrollBar;
    protected int color = 0x404040;
    protected boolean drawShadow;
    protected int textWidth;
    protected int textHeight;

    public UILabel(MalisisGui gui, String text, boolean multiLine) {
        super(gui);
        this.setText(text);
        this.multiLine = multiLine;
    }

    public UILabel(MalisisGui gui, BBString text) {
        this(gui);
        this.setText(text);
        this.multiLine = true;
    }

    public UILabel(MalisisGui gui, String text) {
        this(gui, text, false);
    }

    public UILabel(MalisisGui gui, boolean multiLine) {
        this(gui, null, multiLine);
    }

    public UILabel(MalisisGui gui) {
        this(gui, null, false);
    }

    public String getText() {
        return this.text;
    }

    public UILabel setText(String text) {
        this.text = text;
        this.bbText = null;
        if (this.multiLine) {
            this.buildLines();
        } else {
            this.calculateSize();
        }
        return this;
    }

    public UILabel setColor(int color) {
        this.color = color;
        return this;
    }

    public UILabel setDrawShadow(boolean drawShadow) {
        this.drawShadow = drawShadow;
        return this;
    }

    public UILabel setFontScale(float scale) {
        this.fontScale = scale;
        this.calculateSize();
        return this;
    }

    @Override
    public float getFontScale() {
        return this.fontScale;
    }

    @Override
    public int getContentWidth() {
        return this.getWidth();
    }

    @Override
    public int getContentHeight() {
        return this.lines.size() * (GuiRenderer.FONT_HEIGHT + 1);
    }

    @Override
    public float getOffsetX() {
        return 0.0f;
    }

    @Override
    public void setOffsetX(float offsetX, int delta) {
    }

    @Override
    public float getOffsetY() {
        return (float)this.lineOffset / (float)(this.lines.size() - this.getVisibleLines());
    }

    @Override
    public void setOffsetY(float offsetY, int delta) {
        this.lineOffset = Math.round(offsetY / this.getScrollStep());
        this.lineOffset = Math.max(0, Math.min(this.lines.size(), this.lineOffset));
    }

    @Override
    public float getScrollStep() {
        float step = 1.0f / (float)(this.lines.size() - this.getVisibleLines());
        return GuiScreen.func_146271_m() ? 5.0f * step : step;
    }

    @Override
    public int getVerticalPadding() {
        return 0;
    }

    @Override
    public int getHorizontalPadding() {
        return 0;
    }

    @Override
    public BBString getBBText() {
        return this.bbText;
    }

    @Override
    public UILabel setText(BBString str) {
        if (!this.multiLine) {
            throw new IllegalArgumentException("Can only set BBString for multi line labels.");
        }
        this.setText(str.getRawText());
        this.bbText = str;
        this.bbText.buildRenderLines(this.lines);
        return this;
    }

    @Override
    public int getStartLine() {
        return this.lineOffset;
    }

    @Override
    public int getVisibleLines() {
        return this.getHeight() / this.getLineHeight();
    }

    @Override
    public int getLineHeight() {
        return GuiRenderer.getStringHeight(this.fontScale) + this.lineSpacing;
    }

    @Override
    public UIComponent getComponentAt(int x, int y) {
        return this.multiLine ? super.getComponentAt(x, y) : null;
    }

    protected void buildLines() {
        this.lines.clear();
        if (!StringUtils.isEmpty((CharSequence)this.text)) {
            this.lines = GuiRenderer.wrapText(this.text, this.getWidth(), this.fontScale);
        }
        this.fireEvent(new ContentUpdateEvent<UILabel>(this));
    }

    protected void calculateSize() {
        if (this.multiLine) {
            return;
        }
        this.textWidth = GuiRenderer.getStringWidth(this.text, this.fontScale);
        this.textHeight = GuiRenderer.getStringHeight(this.fontScale);
        this.setSize(this.textWidth, this.textHeight);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.bbText != null) {
            this.bbText.render(renderer, this.screenX(), this.screenY(), this.getZIndex(), this);
            return;
        }
        renderer.setFontScale(this.fontScale);
        if (this.multiLine) {
            for (int i = this.lineOffset; i < this.lineOffset + this.getVisibleLines() && i < this.lines.size(); ++i) {
                int h = (i - this.lineOffset) * this.getLineHeight();
                renderer.drawText(this.lines.get(i), 0, h, this.color, this.drawShadow);
            }
        } else {
            renderer.drawText(this.text, this.color, this.drawShadow);
        }
        renderer.setFontScale(1.0f);
    }

    @Subscribe
    public void onSizeChange(SpaceChangeEvent.SizeChangeEvent<UILabel> event) {
        this.buildLines();
    }

    @Override
    public String getPropertyString() {
        return "text=" + this.text + " | color=0x" + Integer.toHexString(this.color) + " | " + super.getPropertyString();
    }
}

