/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.control;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.control.IControlComponent;
import net.malisis.core.client.gui.component.control.IScrollable;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.client.gui.event.component.ContentUpdateEvent;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.IIcon;

public class UIScrollBar
extends UIComponent<UIScrollBar>
implements IControlComponent {
    protected int scrollThickness = 10;
    protected int scrollHeight = 15;
    private static Map<UIComponent, Map<Type, UIScrollBar>> scrollbars = new WeakHashMap<UIComponent, Map<Type, UIScrollBar>>();
    protected GuiIcon disabledIcon;
    protected GuiIcon verticalIcon;
    protected GuiIcon verticalDisabledIcon;
    protected GuiIcon horizontalIcon;
    protected GuiIcon horizontalDisabledIcon;
    protected Type type;
    public boolean autoHide = false;
    protected GuiShape scrollShape;

    public <T extends UIComponent> UIScrollBar(MalisisGui gui, T parent, Type type) {
        super(gui);
        this.type = type;
        this.setZIndex(parent.getZIndex() + 1);
        parent.addControlComponent(this);
        parent.register(this);
        UIScrollBar.addScrollbar(parent, this);
        this.setPosition();
        this.updateScrollbars();
        this.createShape(gui);
    }

    public void setScrollSize(int thickness, int height) {
        this.scrollThickness = thickness;
        this.scrollHeight = height;
        this.createShape(this.getGui());
    }

    protected void setPosition() {
        int vp = this.getScrollable().getVerticalPadding();
        int hp = this.getScrollable().getHorizontalPadding();
        if (this.type == Type.HORIZONTAL) {
            this.setPosition(-hp, vp, Anchor.BOTTOM);
        } else {
            this.setPosition(hp, -vp, Anchor.RIGHT);
        }
    }

    protected void createShape(MalisisGui gui) {
        int w = this.scrollThickness - 2;
        int h = this.scrollHeight;
        if (this.type == Type.HORIZONTAL) {
            w = this.scrollHeight;
            h = this.scrollThickness - 2;
        }
        this.shape = new XYResizableGuiShape(1);
        this.scrollShape = new SimpleGuiShape();
        this.scrollShape.setSize(w, h);
        this.scrollShape.storeState();
        this.icon = gui.getGuiTexture().getXYResizableIcon(215, 0, 15, 15, 1);
        this.disabledIcon = gui.getGuiTexture().getXYResizableIcon(215, 15, 15, 15, 1);
        this.verticalIcon = gui.getGuiTexture().getIcon(230, 0, 8, 15);
        this.verticalDisabledIcon = gui.getGuiTexture().getIcon(238, 0, 8, 15);
        this.horizontalIcon = gui.getGuiTexture().getIcon(230, 15, 15, 8);
        this.horizontalDisabledIcon = gui.getGuiTexture().getIcon(230, 23, 15, 8);
    }

    protected IScrollable getScrollable() {
        return (IScrollable)((Object)this.getParent());
    }

    public boolean hasVisibleOtherScrollbar() {
        UIScrollBar scrollbar = UIScrollBar.getScrollbar(this.getParent(), this.isHorizontal() ? Type.VERTICAL : Type.HORIZONTAL);
        return scrollbar != null && scrollbar.isVisible();
    }

    public boolean isHorizontal() {
        return this.type == Type.HORIZONTAL;
    }

    public UIScrollBar setAutoHide(boolean autoHide) {
        this.autoHide = autoHide;
        return this;
    }

    @Override
    public int getWidth() {
        return this.isHorizontal() ? this.getParent().getWidth() - (this.hasVisibleOtherScrollbar() ? this.scrollThickness : 0) : this.scrollThickness;
    }

    @Override
    public int getHeight() {
        return this.isHorizontal() ? this.scrollThickness : this.getParent().getHeight() - (this.hasVisibleOtherScrollbar() ? this.scrollThickness : 0);
    }

    public int getLength() {
        return this.isHorizontal() ? this.getWidth() : this.getHeight();
    }

    public UIScrollBar setLength(int length) {
        return null;
    }

    public float getOffset() {
        return this.isHorizontal() ? this.getScrollable().getOffsetX() : this.getScrollable().getOffsetY();
    }

    public void scrollTo(float offset) {
        int delta;
        if (this.isDisabled()) {
            return;
        }
        if (offset < 0.0f) {
            offset = 0.0f;
        }
        if (offset > 1.0f) {
            offset = 1.0f;
        }
        int n = delta = this.hasVisibleOtherScrollbar() ? this.scrollThickness : 0;
        if (this.isHorizontal()) {
            this.getScrollable().setOffsetX(offset, delta);
        } else {
            this.getScrollable().setOffsetY(offset, delta);
        }
    }

    public void scrollBy(float amount) {
        this.scrollTo(this.getOffset() + amount);
    }

    public void updateScrollbars() {
        UIComponent component = this.getParent();
        IScrollable scrollable = this.getScrollable();
        int delta = this.hasVisibleOtherScrollbar() ? this.scrollThickness : 0;
        boolean hide = false;
        if (this.isHorizontal()) {
            if (scrollable.getContentWidth() <= component.getWidth() - delta) {
                hide = true;
            }
        } else if (scrollable.getContentHeight() <= component.getHeight() - delta) {
            hide = true;
        }
        if (hide != this.isDisabled()) {
            this.scrollTo(0.0f);
        }
        this.setDisabled(hide);
        if (this.autoHide) {
            this.setVisible(!hide);
        }
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.rp.icon.set((IIcon)(this.isDisabled() ? this.disabledIcon : this.icon));
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        GuiIcon icon;
        int ox = 0;
        int oy = 0;
        int l = this.getLength() - this.scrollHeight - 2;
        if (this.isHorizontal()) {
            icon = this.isDisabled() ? this.horizontalDisabledIcon : this.horizontalIcon;
            ox = (int)(this.getOffset() * (float)l);
        } else {
            icon = this.isDisabled() ? this.verticalDisabledIcon : this.verticalIcon;
            oy = (int)(this.getOffset() * (float)l);
        }
        this.scrollShape.resetState();
        this.scrollShape.setPosition(ox + 1, oy + 1);
        this.rp.icon.set((IIcon)icon);
        renderer.drawShape(this.scrollShape, this.rp);
    }

    @Subscribe
    public void onContentUpdate(ContentUpdateEvent event) {
        if (this.getParent() != event.getComponent()) {
            return;
        }
        this.updateScrollbars();
    }

    @Override
    public boolean onButtonPress(int x, int y, MouseButton button) {
        if (button != MouseButton.LEFT) {
            return this.onButtonPress(x, y, button);
        }
        this.onScrollTo(x, y);
        return true;
    }

    @Override
    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        if (button != MouseButton.LEFT) {
            return super.onDrag(lastX, lastY, x, y, button);
        }
        if (this.isFocused()) {
            this.onScrollTo(x, y);
        }
        return true;
    }

    private void onScrollTo(int x, int y) {
        int l = this.getLength() - this.scrollHeight - 2;
        int pos = this.isHorizontal() ? this.relativeX(x) : this.relativeY(y);
        this.scrollTo((float)(pos -= this.scrollHeight / 2) / (float)l);
    }

    @Override
    public boolean onScrollWheel(int x, int y, int delta) {
        if (this.isHorizontal() != GuiScreen.func_146272_n() && !this.isHovered()) {
            return super.onScrollWheel(x, y, delta);
        }
        this.scrollBy((float)(-delta) * this.getScrollable().getScrollStep());
        return true;
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (MalisisGui.isGuiCloseKey(keyCode)) {
            return super.onKeyTyped(keyChar, keyCode);
        }
        if (!this.isHovered() && !this.getParent().isHovered()) {
            return super.onKeyTyped(keyChar, keyCode);
        }
        if (this.isHorizontal() != GuiScreen.func_146272_n()) {
            return super.onKeyTyped(keyChar, keyCode);
        }
        if (keyCode == 199) {
            this.scrollTo(0.0f);
        } else if (keyCode == 207) {
            this.scrollTo(1.0f);
        } else {
            return super.onKeyTyped(keyChar, keyCode);
        }
        return true;
    }

    @Override
    public String getPropertyString() {
        return (Object)((Object)this.type) + " | " + super.getPropertyString();
    }

    public static UIScrollBar getScrollbar(UIComponent component, Type type) {
        Map<Type, UIScrollBar> bars = scrollbars.get(component);
        if (bars == null) {
            return null;
        }
        return bars.get((Object)type);
    }

    public static void addScrollbar(UIComponent component, UIScrollBar scrollbar) {
        Map<Type, UIScrollBar> bars = scrollbars.get(component);
        if (bars == null) {
            bars = new HashMap<Type, UIScrollBar>();
            scrollbars.put(component, bars);
        }
        bars.put(scrollbar.type, scrollbar);
    }

    public static enum Type {
        HORIZONTAL,
        VERTICAL;

    }
}

