/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.world;

import codechicken.lib.vec.BlockCoord;
import com.amadornes.framez.movement.MovingBlock;
import com.amadornes.framez.movement.MovingStructure;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.network.NetworkManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class WorldWrapperClient
extends WorldClient {
    private MovingStructure structure;
    private List<BlockCoord> toUpdate = new ArrayList<BlockCoord>();

    public WorldWrapperClient(MovingStructure structure) {
        super(new NetHandlerPlayClient(Minecraft.func_71410_x(), null, new NetworkManager(true)), new WorldSettings(structure.getWorld().func_72912_H()), structure.getWorld().field_73011_w.field_76574_g, structure.getWorld().field_73013_u, structure.getWorld().field_72984_F);
        this.structure = structure;
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    protected int func_152379_p() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    private MovingBlock get(int x, int y, int z) {
        if (this.structure.getMoved() >= 1.0) {
            return null;
        }
        MovingBlock b = this.structure.getBlock(x, y, z);
        if (b != null && !b.isStored()) {
            return null;
        }
        return b;
    }

    public Block func_147439_a(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getBlock();
        }
        return Blocks.field_150350_a;
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getTileEntity();
        }
        return null;
    }

    public int func_72802_i(int x, int y, int z, int unknown) {
        return this.structure.getWorld().func_72802_i(x, y, z, unknown);
    }

    public int func_72805_g(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getMetadata();
        }
        return 0;
    }

    public int func_72879_k(int x, int y, int z, int face) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getBlock().func_149748_c((IBlockAccess)this, x, y, z, face);
        }
        return 0;
    }

    public boolean func_147437_c(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        return b == null;
    }

    public Entity func_73045_a(int id) {
        return this.structure.getWorld().func_73045_a(id);
    }

    public boolean func_72838_d(Entity entity) {
        entity.field_70165_t += (double)this.structure.getDirection().offsetX * this.structure.getMoved();
        entity.field_70163_u += (double)this.structure.getDirection().offsetY * this.structure.getMoved();
        entity.field_70161_v += (double)this.structure.getDirection().offsetZ * this.structure.getMoved();
        return this.structure.getWorld().func_72838_d(entity);
    }

    public void func_72869_a(String type, double x, double y, double z, double r, double g, double b) {
        this.structure.getWorld().func_72869_a(type, x + (double)this.structure.getDirection().offsetX * this.structure.getMoved(), y + (double)this.structure.getDirection().offsetY * this.structure.getMoved(), z + (double)this.structure.getDirection().offsetZ * this.structure.getMoved(), r, g, b);
    }

    public boolean func_147449_b(int p_147449_1_, int p_147449_2_, int p_147449_3_, Block p_147449_4_) {
        return false;
    }

    public boolean func_147465_d(int p_147465_1_, int p_147465_2_, int p_147465_3_, Block p_147465_4_, int p_147465_5_, int p_147465_6_) {
        return false;
    }

    public boolean func_72921_c(int p_72921_1_, int p_72921_2_, int p_72921_3_, int p_72921_4_, int p_72921_5_) {
        return false;
    }

    public boolean func_147468_f(int p_147468_1_, int p_147468_2_, int p_147468_3_) {
        return false;
    }

    public void func_147455_a(int x, int y, int z, TileEntity te) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            b.setTileEntity(te);
        }
    }

    public void func_147475_p(int x, int y, int z) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            b.setTileEntity(null);
        }
    }

    public void func_72835_b() {
        ArrayList<BlockCoord> toUpdateCurrent = new ArrayList<BlockCoord>(this.toUpdate);
        this.toUpdate.clear();
        for (BlockCoord b : toUpdateCurrent) {
            Block bl = this.func_147439_a(b.x, b.y, b.z);
            if (bl == null) continue;
            bl.func_149674_a((World)this, b.x, b.y, b.z, this.field_73012_v);
        }
        toUpdateCurrent.clear();
    }

    public void func_72939_s() {
    }

    public void func_72980_b(double x, double y, double z, String sound, float volume, float pitch, boolean unknown) {
        this.structure.getWorld().func_72980_b(x, y, z, sound, volume, pitch, unknown);
    }

    public void func_72956_a(Entity entity, String sound, float volume, float pitch) {
        this.structure.getWorld().func_72956_a(entity, sound, volume, pitch);
    }

    public void func_72908_a(double x, double y, double z, String sound, float volume, float pitch) {
        this.structure.getWorld().func_72908_a(x, y, z, sound, volume, pitch);
    }

    public void func_72926_e(int x, int y, int z, int a, int b) {
        this.structure.getWorld().func_72926_e(x, y, z, a, b);
    }

    public void func_72889_a(EntityPlayer player, int x, int y, int z, int a, int b) {
        this.structure.getWorld().func_72889_a(player, x, y, z, a, b);
    }

    public void func_85173_a(EntityPlayer player, String sound, float volume, float pitch) {
        this.structure.getWorld().func_85173_a(player, sound, volume, pitch);
    }

    public boolean func_147463_c(EnumSkyBlock p_147463_1_, int p_147463_2_, int p_147463_3_, int p_147463_4_) {
        return false;
    }

    public Chunk func_72938_d(int x, int z) {
        return this.structure.getWorld().func_72938_d(x, z);
    }

    public Chunk func_72964_e(int x, int z) {
        return this.structure.getWorld().func_72964_e(x, z);
    }

    public IChunkProvider func_72863_F() {
        return this.structure.getWorld().func_72863_F();
    }

    protected boolean func_72916_c(int p_72916_1_, int p_72916_2_) {
        return this.func_72863_F().func_73149_a(p_72916_1_, p_72916_2_);
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getBlock().isSideSolid((IBlockAccess)this, x, y, z, side);
        }
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        MovingBlock b = this.get(x, y, z);
        if (b != null) {
            return b.getBlock().isSideSolid((IBlockAccess)this, x, y, z, side);
        }
        return _default;
    }

    public void func_147444_c(int p_147444_1_, int p_147444_2_, int p_147444_3_, Block p_147444_4_) {
    }

    public void func_147460_e(int p_147460_1_, int p_147460_2_, int p_147460_3_, Block p_147460_4_) {
    }

    public void func_147441_b(int p_147441_1_, int p_147441_2_, int p_147441_3_, Block p_147441_4_, int p_147441_5_) {
    }

    public void func_147459_d(int p_147459_1_, int p_147459_2_, int p_147459_3_, Block p_147459_4_) {
    }

    public void func_147458_c(int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    MovingBlock b = this.get(x, y, z);
                    if (b == null) continue;
                    b.setRenderList(-1);
                }
            }
        }
    }

    public void func_147471_g(int x, int y, int z) {
        this.toUpdate.add(new BlockCoord(x, y, z));
    }

    public long func_72820_D() {
        return this.structure.getWorld().func_72820_D();
    }

    public long func_82737_E() {
        try {
            return this.structure.getWorld().func_82737_E();
        }
        catch (Exception exception) {
            return 0L;
        }
    }
}

