/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.movement;

import codechicken.lib.vec.BlockCoord;
import com.amadornes.framez.movement.MovedBlockHandler;
import com.amadornes.framez.movement.MovingBlock;
import com.amadornes.framez.world.WorldWrapperClient;
import com.amadornes.framez.world.WorldWrapperProvider;
import com.amadornes.framez.world.WorldWrapperServer;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MovingStructure {
    private World world;
    private ForgeDirection direction;
    private List<MovingBlock> blocks = new ArrayList<MovingBlock>();
    private double speed;
    private boolean moved = false;
    private double totalMoved = 0.0;
    private WorldWrapperServer wrapper;
    @SideOnly(value=Side.CLIENT)
    private WorldWrapperClient wrapperClient;

    public MovingStructure(World world, ForgeDirection direction, double speed) {
        this.world = world;
        this.direction = direction;
        this.speed = speed;
        if (world.field_72995_K) {
            this.initClient();
        } else {
            this.initServer();
        }
    }

    private void initServer() {
        this.wrapper = WorldWrapperProvider.getWrapper(this.world);
    }

    @SideOnly(value=Side.CLIENT)
    private void initClient() {
        this.wrapperClient = new WorldWrapperClient(this);
    }

    public void addBlocks(List<BlockCoord> blocks) {
        for (BlockCoord b : blocks) {
            this.addBlock(b);
        }
    }

    public void addBlock(int x, int y, int z) {
        this.blocks.add(new MovingBlock(x, y, z, this.world, this));
    }

    public void addBlock(BlockCoord coords) {
        this.blocks.add(new MovingBlock(coords, this.world, this));
    }

    public List<MovingBlock> getBlocks() {
        return this.blocks;
    }

    public ForgeDirection getDirection() {
        return this.direction;
    }

    public double getMoved() {
        return this.totalMoved;
    }

    public double getMoved(float partialTick) {
        return this.totalMoved - this.getSpeed() * (double)partialTick;
    }

    public double getSpeed() {
        return this.speed;
    }

    public World getWorld() {
        return this.world;
    }

    public World getWorldWrapper() {
        if (this.wrapper == null) {
            return this.getWorldWrapperClient();
        }
        return this.wrapper;
    }

    @SideOnly(value=Side.CLIENT)
    public World getWorldWrapperClient() {
        return this.wrapperClient;
    }

    public void tick(TickEvent.Phase phase) {
        if (!this.moved) {
            if (phase == TickEvent.Phase.END) {
                this.moveEntities();
            }
            if (phase == TickEvent.Phase.START) {
                if (this.totalMoved == 0.0) {
                    this.startMoving();
                }
                this.getWorldWrapper().func_72835_b();
                ArrayList<BlockCoord> l = new ArrayList<BlockCoord>();
                for (MovingBlock movingBlock : this.blocks) {
                    BlockCoord d;
                    if (!l.contains(movingBlock)) {
                        l.add(movingBlock.getLocation());
                    }
                    if (l.contains(d = movingBlock.getLocation().copy().add(this.getDirection().offsetX, this.getDirection().offsetY, this.getDirection().offsetZ))) continue;
                    l.add(d);
                }
                for (BlockCoord blockCoord : l) {
                    this.getWorld().func_147451_t(blockCoord.x, blockCoord.y, blockCoord.z);
                }
                l.clear();
                this.totalMoved += this.speed;
                if (this.totalMoved >= 1.0) {
                    this.finishMoving();
                }
            }
        }
    }

    public void startMoving() {
        if (this.wrapper != null) {
            this.wrapper.addStructure(this);
        }
        for (MovingBlock b : this.blocks) {
            b.storeData();
            b.remove();
            b.placePlaceholder();
        }
        for (MovingBlock b : this.blocks) {
            this.world.func_147471_g(b.getLocation().x, b.getLocation().y, b.getLocation().z);
            this.world.func_147444_c(b.getLocation().x, b.getLocation().y, b.getLocation().z, b.getBlock());
            this.world.func_147460_e(b.getLocation().x, b.getLocation().y, b.getLocation().z, Blocks.field_150350_a);
            this.world.func_147451_t(b.getLocation().x, b.getLocation().y, b.getLocation().z);
        }
    }

    public void finishMoving() {
        this.totalMoved = 1.0;
        this.moved = true;
        for (MovingBlock b : this.blocks) {
            b.removePlaceholder();
            b.place();
        }
        for (MovingBlock b : this.blocks) {
            if (!this.world.field_72995_K) {
                this.world.func_147471_g(b.getLocation().x, b.getLocation().y, b.getLocation().z);
                this.world.func_147444_c(b.getLocation().x, b.getLocation().y, b.getLocation().z, b.getBlock());
                this.world.func_147460_e(b.getLocation().x, b.getLocation().y, b.getLocation().z, Blocks.field_150350_a);
                this.world.func_147451_t(b.getLocation().x, b.getLocation().y, b.getLocation().z);
                this.world.func_72938_d(b.getX(), b.getZ()).func_76630_e();
                continue;
            }
            this.world.func_147458_c(b.getLocation().x + this.getDirection().offsetX, b.getLocation().y + this.getDirection().offsetY, b.getLocation().z + this.getDirection().offsetZ, b.getLocation().x + this.getDirection().offsetX, b.getLocation().y + this.getDirection().offsetY, b.getLocation().z + this.getDirection().offsetZ);
        }
        if (this.wrapper != null) {
            this.wrapper.removeStructure(this);
        }
        MovedBlockHandler.onStructureFinishMoving(this);
    }

    public MovingBlock getBlock(int x, int y, int z) {
        BlockCoord coords = new BlockCoord(x, y, z);
        for (MovingBlock b : new ArrayList<MovingBlock>(this.getBlocks())) {
            if (b.getLocation() == null || !b.getLocation().equals((Object)coords)) continue;
            return b;
        }
        return null;
    }

    private void moveEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (MovingBlock b : this.blocks) {
            ArrayList<AxisAlignedBB> aabbs = new ArrayList<AxisAlignedBB>();
            try {
                b.getBlock().func_149743_a(this.getWorldWrapper(), b.getLocation().x, b.getLocation().y, b.getLocation().z, AxisAlignedBB.func_72330_a((double)b.getLocation().x, (double)b.getLocation().y, (double)b.getLocation().z, (double)(b.getLocation().x + 1), (double)(b.getLocation().y + 1), (double)(b.getLocation().z + 1)), aabbs, null);
            }
            catch (Exception ex) {
                aabbs.add(AxisAlignedBB.func_72330_a((double)b.getX(), (double)b.getY(), (double)b.getZ(), (double)(b.getX() + 1), (double)(b.getY() + 1), (double)(b.getZ() + 1)));
            }
            for (Object e : aabbs) {
                AxisAlignedBB aabb = (AxisAlignedBB)e;
                if (aabb == null) continue;
                aabb = aabb.func_72329_c();
                double x = (double)this.direction.offsetX * this.getMoved();
                double y = (double)this.direction.offsetY * this.getMoved();
                double z = (double)this.direction.offsetZ * this.getMoved();
                aabb.field_72340_a += x;
                aabb.field_72336_d += x;
                aabb.field_72338_b += y;
                aabb.field_72337_e += y;
                aabb.field_72339_c += z;
                aabb.field_72334_f += z;
                aabb.field_72337_e += 0.25;
                aabb.field_72340_a = aabb.field_72340_a - (this.direction.offsetX < 0 ? 0.25 : 0.0);
                aabb.field_72339_c = aabb.field_72339_c - (this.direction.offsetZ < 0 ? 0.25 : 0.0);
                aabb.field_72336_d = aabb.field_72336_d + (this.direction.offsetX > 0 ? 0.25 : 0.0);
                aabb.field_72334_f = aabb.field_72334_f + (this.direction.offsetZ > 0 ? 0.25 : 0.0);
                for (Object o2 : this.world.func_72872_a(Entity.class, aabb)) {
                    if (entities.contains(o2)) continue;
                    entities.add((Entity)o2);
                }
            }
        }
        for (Entity e : entities) {
            if (e instanceof EntityPlayer && e.func_70093_af() || this.direction.offsetY < 0) continue;
            try {
                this.moveEntity(e);
            }
            catch (Exception ex) {}
        }
    }

    private void moveEntity(Entity entity) {
        double movedX = this.speed * (double)this.direction.offsetX;
        double movedY = this.speed * (double)this.direction.offsetY + 0.001;
        double movedZ = this.speed * (double)this.direction.offsetZ;
        if (entity.field_70145_X) {
            entity.field_70121_D.func_72317_d(movedX, movedY, movedZ);
            entity.field_70165_t = (entity.field_70121_D.field_72340_a + entity.field_70121_D.field_72336_d) / 2.0;
            entity.field_70163_u = entity.field_70121_D.field_72338_b + (double)entity.field_70129_M - (double)entity.field_70139_V;
            entity.field_70161_v = (entity.field_70121_D.field_72339_c + entity.field_70121_D.field_72334_f) / 2.0;
        } else {
            double d11;
            double d10;
            double d12;
            int j;
            boolean flag;
            entity.field_70170_p.field_72984_F.func_76320_a("move");
            entity.field_70139_V *= 0.4f;
            double d3 = entity.field_70165_t;
            double d4 = entity.field_70163_u;
            double d5 = entity.field_70161_v;
            double d6 = movedX;
            double d7 = movedY;
            double d8 = movedZ;
            AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72329_c();
            boolean bl = flag = entity.field_70122_E && entity.func_70093_af() && entity instanceof EntityPlayer;
            if (flag) {
                double d9 = 0.05;
                while (movedX != 0.0 && entity.field_70170_p.func_72945_a(entity, entity.field_70121_D.func_72325_c(movedX, -1.0, 0.0)).isEmpty()) {
                    movedX = movedX < d9 && movedX >= -d9 ? 0.0 : (movedX > 0.0 ? (movedX -= d9) : (movedX += d9));
                    d6 = movedX;
                }
                while (movedZ != 0.0 && entity.field_70170_p.func_72945_a(entity, entity.field_70121_D.func_72325_c(0.0, -1.0, movedZ)).isEmpty()) {
                    movedZ = movedZ < d9 && movedZ >= -d9 ? 0.0 : (movedZ > 0.0 ? (movedZ -= d9) : (movedZ += d9));
                    d8 = movedZ;
                }
                while (movedX != 0.0 && movedZ != 0.0 && entity.field_70170_p.func_72945_a(entity, entity.field_70121_D.func_72325_c(movedX, -1.0, movedZ)).isEmpty()) {
                    movedX = movedX < d9 && movedX >= -d9 ? 0.0 : (movedX > 0.0 ? (movedX -= d9) : (movedX += d9));
                    movedZ = movedZ < d9 && movedZ >= -d9 ? 0.0 : (movedZ > 0.0 ? (movedZ -= d9) : (movedZ += d9));
                    d6 = movedX;
                    d8 = movedZ;
                }
            }
            List list = entity.field_70170_p.func_72945_a(entity, entity.field_70121_D.func_72321_a(movedX, movedY, movedZ));
            for (int i = 0; i < list.size(); ++i) {
                movedY = ((AxisAlignedBB)list.get(i)).func_72323_b(entity.field_70121_D, movedY);
            }
            entity.field_70121_D.func_72317_d(0.0, movedY, 0.0);
            if (!entity.field_70135_K && d7 != movedY) {
                movedZ = 0.0;
                movedY = 0.0;
                movedX = 0.0;
            }
            boolean flag1 = entity.field_70122_E || d7 != movedY && d7 < 0.0;
            for (j = 0; j < list.size(); ++j) {
                movedX = ((AxisAlignedBB)list.get(j)).func_72316_a(entity.field_70121_D, movedX);
            }
            entity.field_70121_D.func_72317_d(movedX, 0.0, 0.0);
            if (!entity.field_70135_K && d6 != movedX) {
                movedZ = 0.0;
                movedY = 0.0;
                movedX = 0.0;
            }
            for (j = 0; j < list.size(); ++j) {
                movedZ = ((AxisAlignedBB)list.get(j)).func_72322_c(entity.field_70121_D, movedZ);
            }
            entity.field_70121_D.func_72317_d(0.0, 0.0, movedZ);
            if (!entity.field_70135_K && d8 != movedZ) {
                movedZ = 0.0;
                movedY = 0.0;
                movedX = 0.0;
            }
            if (entity.field_70138_W > 0.0f && flag1 && (flag || entity.field_70139_V < 0.05f) && (d6 != movedX || d8 != movedZ)) {
                int k;
                d12 = movedX;
                d10 = movedY;
                d11 = movedZ;
                movedX = d6;
                movedY = entity.field_70138_W;
                movedZ = d8;
                AxisAlignedBB axisalignedbb1 = entity.field_70121_D.func_72329_c();
                entity.field_70121_D.func_72328_c(axisalignedbb);
                list = entity.field_70170_p.func_72945_a(entity, entity.field_70121_D.func_72321_a(d6, movedY, d8));
                for (k = 0; k < list.size(); ++k) {
                    movedY = ((AxisAlignedBB)list.get(k)).func_72323_b(entity.field_70121_D, movedY);
                }
                entity.field_70121_D.func_72317_d(0.0, movedY, 0.0);
                if (!entity.field_70135_K && d7 != movedY) {
                    movedZ = 0.0;
                    movedY = 0.0;
                    movedX = 0.0;
                }
                for (k = 0; k < list.size(); ++k) {
                    movedX = ((AxisAlignedBB)list.get(k)).func_72316_a(entity.field_70121_D, movedX);
                }
                entity.field_70121_D.func_72317_d(movedX, 0.0, 0.0);
                if (!entity.field_70135_K && d6 != movedX) {
                    movedZ = 0.0;
                    movedY = 0.0;
                    movedX = 0.0;
                }
                for (k = 0; k < list.size(); ++k) {
                    movedZ = ((AxisAlignedBB)list.get(k)).func_72322_c(entity.field_70121_D, movedZ);
                }
                entity.field_70121_D.func_72317_d(0.0, 0.0, movedZ);
                if (!entity.field_70135_K && d8 != movedZ) {
                    movedZ = 0.0;
                    movedY = 0.0;
                    movedX = 0.0;
                }
                if (!entity.field_70135_K && d7 != movedY) {
                    movedZ = 0.0;
                    movedY = 0.0;
                    movedX = 0.0;
                } else {
                    movedY = -entity.field_70138_W;
                    for (k = 0; k < list.size(); ++k) {
                        movedY = ((AxisAlignedBB)list.get(k)).func_72323_b(entity.field_70121_D, movedY);
                    }
                    entity.field_70121_D.func_72317_d(0.0, movedY, 0.0);
                }
                if (d12 * d12 + d11 * d11 >= movedX * movedX + movedZ * movedZ) {
                    movedX = d12;
                    movedY = d10;
                    movedZ = d11;
                    entity.field_70121_D.func_72328_c(axisalignedbb1);
                }
            }
            entity.field_70170_p.field_72984_F.func_76319_b();
            entity.field_70170_p.field_72984_F.func_76320_a("rest");
            entity.field_70165_t = (entity.field_70121_D.field_72340_a + entity.field_70121_D.field_72336_d) / 2.0;
            entity.field_70163_u = entity.field_70121_D.field_72338_b + (double)entity.field_70129_M - (double)entity.field_70139_V;
            entity.field_70161_v = (entity.field_70121_D.field_72339_c + entity.field_70121_D.field_72334_f) / 2.0;
            entity.field_70123_F = d6 != movedX || d8 != movedZ;
            entity.field_70124_G = d7 != movedY;
            entity.field_70122_E = true;
            entity.field_70132_H = entity.field_70123_F || entity.field_70124_G;
            entity.field_70143_R = 0.0f;
            d12 = entity.field_70165_t - d3;
            d10 = entity.field_70163_u - d4;
            d11 = entity.field_70161_v - d5;
            entity.field_70169_q -= d12;
            entity.field_70167_r -= d10;
            entity.field_70166_s -= d11;
        }
    }
}

