/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.compat.ae2;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import com.amadornes.framez.compat.ae2.MotorProviderAE2;
import com.amadornes.framez.config.Config;
import com.amadornes.framez.tile.TileMotor;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMotorAE2
extends TileMotor
implements IAEPowerStorage,
IGridHost,
IGridBlock {
    private IGridNode node = null;
    private double oldPower = 0.0;

    private double getRatio() {
        return PowerUnits.RF.convertTo(PowerUnits.AE, Config.PowerRatios.rf);
    }

    @Override
    public boolean shouldMove() {
        return this.isBeingPowered();
    }

    @Override
    public boolean hasEnoughFramezPower(double power) {
        return this.getTotalStored() >= power;
    }

    @Override
    public double getMovementSpeed() {
        return 1.0;
    }

    @Override
    public void consumeFramezPower(double power) {
        this.drain(power);
    }

    @Override
    public Map.Entry<Double, Double> getExtraInfo() {
        return new AbstractMap.SimpleEntry<Double, Double>(this.maxStored, this.stored);
    }

    @Override
    public void func_145845_h() {
        double pow;
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.node == null) {
                this.node = AEApi.instance().createGridNode((IGridBlock)this);
            }
            this.node.updateState();
        }
        if ((pow = this.getTotalStored()) != this.oldPower) {
            this.sendUpdatePacket();
        }
        this.oldPower = pow;
    }

    public double getTotalStored() {
        double nodePower = 0.0;
        if (this.node != null) {
            for (IGridNode n : this.node.getGrid().getNodes()) {
                IAEPowerStorage storage;
                IGridHost host;
                if (n == this.node || !((host = n.getGridBlock().getMachine()) instanceof IAEPowerStorage) || !(storage = (IAEPowerStorage)host).isAEPublicPowerStorage() || storage.getPowerFlow() != AccessRestriction.READ && storage.getPowerFlow() != AccessRestriction.READ_WRITE) continue;
                nodePower += storage.getAECurrentPower();
            }
        }
        return Math.min(this.stored + nodePower, this.maxStored);
    }

    public void drain(double amt) {
        block1: {
            double extracted;
            IAEPowerStorage storage;
            IGridHost host;
            IGridNode n;
            double drainedFromThis = Math.min(amt, this.stored);
            this.stored -= drainedFromThis;
            if (!((amt *= this.getRatio()) > 0.0)) break block1;
            Iterator i$ = this.node.getGrid().getNodes().iterator();
            while (i$.hasNext() && ((n = (IGridNode)i$.next()) == this.node || !((host = n.getGridBlock().getMachine()) instanceof IAEPowerStorage) || !(storage = (IAEPowerStorage)host).isAEPublicPowerStorage() || storage.getPowerFlow() != AccessRestriction.READ && storage.getPowerFlow() != AccessRestriction.READ_WRITE || (amt -= (extracted = storage.extractAEPower(amt, Actionable.MODULATE, PowerMultiplier.ONE))) != 0.0)) {
            }
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.destroy();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.destroy();
        }
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        return 0.0;
    }

    public double injectAEPower(double amt, Actionable mode) {
        double ratio = this.getRatio();
        int tot = (int)(this.stored + amt / ratio);
        this.stored = Math.min((double)tot, this.maxStored);
        this.sendUpdatePacket();
        return ((double)tot - this.stored) * ratio;
    }

    public double getAEMaxPower() {
        return this.maxStored * this.getRatio();
    }

    public double getAECurrentPower() {
        return this.stored * this.getRatio();
    }

    public boolean isAEPublicPowerStorage() {
        return true;
    }

    public AccessRestriction getPowerFlow() {
        return AccessRestriction.WRITE;
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        if (dir == this.getFace()) {
            return null;
        }
        if (this.node == null) {
            this.node = AEApi.instance().createGridNode((IGridBlock)this);
            this.node.updateState();
        }
        return this.node;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    public void securityBreak() {
        this.func_145831_w().func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145831_w().func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public double getIdlePowerUsage() {
        return 0.0;
    }

    public EnumSet<GridFlags> getFlags() {
        return EnumSet.copyOf(Arrays.asList(GridFlags.CANNOT_CARRY));
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public AEColor getGridColor() {
        return AEColor.Transparent;
    }

    public void onGridNotification(GridNotification notification) {
    }

    public void setNetworkStatus(IGrid grid, int channelsInUse) {
    }

    public EnumSet<ForgeDirection> getConnectableSides() {
        ArrayList<ForgeDirection> sides = new ArrayList<ForgeDirection>(Arrays.asList(ForgeDirection.values()));
        sides.remove(this.getFace());
        return EnumSet.copyOf(sides);
    }

    public IGridHost getMachine() {
        return this;
    }

    public void gridChanged() {
    }

    public ItemStack getMachineRepresentation() {
        return new ItemStack(GameRegistry.findBlock((String)"framez", (String)("motor." + MotorProviderAE2.inst.getId())));
    }

    @Override
    public void writeUpdatePacket(NBTTagCompound tag) {
        super.writeUpdatePacket(tag);
        tag.func_74780_a("stored", this.getTotalStored());
    }

    @Override
    public void readUpdatePacket(NBTTagCompound tag) {
        super.readUpdatePacket(tag);
        this.stored = tag.func_74769_h("stored");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74780_a("stored", this.stored);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.stored = tag.func_74769_h("stored");
    }

    public boolean isWorldAccessible() {
        return true;
    }

    public boolean isWorldAccessable() {
        return true;
    }
}

