/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.client.render;

import codechicken.lib.vec.BlockCoord;
import com.amadornes.framez.block.BlockMotor;
import com.amadornes.framez.client.render.RenderHelper;
import com.amadornes.framez.tile.TileMotor;
import com.amadornes.framez.util.MotorPlacement;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderMotorPlacement {
    @SubscribeEvent
    public void onRenderTick(RenderWorldLastEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack item = player.func_71045_bC();
        if (item == null) {
            return;
        }
        if (!(item.func_77973_b() instanceof ItemBlock) || !(Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockMotor)) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74319_N && Minecraft.func_71410_x().field_71462_r == null) {
            return;
        }
        MovingObjectPosition mop = player.func_70614_a(player.field_71075_bZ.field_75098_d ? 5.0 : 4.0, 0.0f);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        ForgeDirection faceHit = ForgeDirection.getOrientation((int)mop.field_72310_e);
        BlockCoord b = new BlockCoord(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).add(faceHit.offsetX, faceHit.offsetY, faceHit.offsetZ);
        if (!world.func_147437_c(b.x, b.y, b.z)) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        Vec3 playerPos = player.func_70666_h(event.partialTicks);
        double x = (double)b.x - playerPos.field_72450_a;
        double y = (double)b.y - playerPos.field_72448_b;
        double z = (double)b.z - playerPos.field_72449_c;
        GL11.glTranslated((double)x, (double)y, (double)z);
        int rotation = MotorPlacement.getPlacementRotation(mop);
        if (faceHit == ForgeDirection.WEST || faceHit == ForgeDirection.UP || faceHit == ForgeDirection.SOUTH || faceHit == ForgeDirection.NORTH) {
            if (rotation == 1) {
                rotation = 3;
            } else if (rotation == 3) {
                rotation = 1;
            }
        }
        if (faceHit == ForgeDirection.SOUTH) {
            if (rotation == 0) {
                rotation = 2;
            } else if (rotation == 2) {
                rotation = 0;
            }
        }
        if (faceHit == ForgeDirection.EAST) {
            ++rotation;
        }
        if (faceHit == ForgeDirection.WEST) {
            --rotation;
        }
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        switch (faceHit) {
            case UP: {
                break;
            }
            case DOWN: {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case EAST: {
                GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                rotation += 3;
                break;
            }
            case WEST: {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                ++rotation;
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
        }
        GL11.glRotated((double)(90 * rotation), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        double c = world.func_72855_b(AxisAlignedBB.func_72330_a((double)b.x, (double)b.y, (double)b.z, (double)(b.x + 1), (double)(b.y + 1), (double)(b.z + 1))) ? 1.0 : 0.5;
        int rgb = TileMotor.getColorMultiplierForPlayer(player.func_146103_bH().getName());
        double r_ = (double)(rgb >> 16 & 0xFF) / 256.0 * c;
        double g_ = (double)(rgb >> 8 & 0xFF) / 256.0 * c;
        double b_ = (double)(rgb & 0xFF) / 256.0 * c;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4d((double)(r_ * 0.5), (double)(g_ * 0.5), (double)(b_ * 0.5), (double)1.0);
        GL11.glBegin((int)7);
        RenderHelper.vertex(0.4, 0.025, 0.25);
        RenderHelper.vertex(0.4, 0.025, 0.5);
        RenderHelper.vertex(0.6, 0.025, 0.5);
        RenderHelper.vertex(0.6, 0.025, 0.25);
        RenderHelper.vertex(0.5, 0.025, 0.5);
        RenderHelper.vertex(0.25, 0.025, 0.5);
        RenderHelper.vertex(0.5, 0.025, 0.75);
        RenderHelper.vertex(0.75, 0.025, 0.5);
        GL11.glEnd();
        GL11.glColor4d((double)r_, (double)g_, (double)b_, (double)1.0);
        double border = 0.025;
        GL11.glBegin((int)7);
        RenderHelper.vertex(0.4 + border, 0.0275, 0.25 + border);
        RenderHelper.vertex(0.4 + border, 0.0275, 0.5 + border);
        RenderHelper.vertex(0.6 - border, 0.0275, 0.5 + border);
        RenderHelper.vertex(0.6 - border, 0.0275, 0.25 + border);
        RenderHelper.vertex(0.5, 0.0275, 0.5 + border);
        RenderHelper.vertex(0.25 + border * 2.5, 0.0275, 0.5 + border);
        RenderHelper.vertex(0.5, 0.0275, 0.75 - border * 1.5);
        RenderHelper.vertex(0.75 - border * 2.5, 0.0275, 0.5 + border);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }
}

