/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.client.render;

import com.amadornes.framez.api.FramezApi;
import com.amadornes.framez.api.IRenderMotorSpecial;
import com.amadornes.framez.client.render.RenderHelper;
import com.amadornes.framez.item.ItemBlockMotorCore;
import com.amadornes.framez.tile.TileMotor;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.DoubleBuffer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderMotor
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    public static boolean renderingBorder = false;
    private RenderBlocks rb = new RenderBlocks();
    private boolean itemRenderer = false;
    private int list;

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    private void renderStandardBlock(Block block, int x, int y, int z) {
        if (!this.itemRenderer) {
            this.rb.func_147784_q(block, x, y, z);
        } else {
            if (renderingBorder) {
                int rgb = TileMotor.getColorMultiplierForPlayer(Minecraft.func_71410_x().field_71439_g.func_146103_bH().getName());
                float r = (float)(rgb >> 16 & 0xFF) / 256.0f;
                float g = (float)(rgb >> 8 & 0xFF) / 256.0f;
                float b = (float)(rgb & 0xFF) / 256.0f;
                Tessellator.field_78398_a.func_78386_a(r, g, b);
            }
            Tessellator.field_78398_a.func_78375_b((float)(-this.rb.field_147859_h), 0.0f, 0.0f);
            this.rb.func_147798_e(block, (double)x, (double)y, (double)z, block.func_149691_a(ForgeDirection.WEST.ordinal(), 0));
            Tessellator.field_78398_a.func_78375_b((float)this.rb.field_147861_i, 0.0f, 0.0f);
            this.rb.func_147764_f(block, (double)x, (double)y, (double)z, block.func_149691_a(ForgeDirection.EAST.ordinal(), 0));
            Tessellator.field_78398_a.func_78375_b(0.0f, (float)(-this.rb.field_147855_j), 0.0f);
            this.rb.func_147768_a(block, (double)x, (double)y, (double)z, block.func_149691_a(ForgeDirection.DOWN.ordinal(), 0));
            Tessellator.field_78398_a.func_78375_b(0.0f, (float)this.rb.field_147857_k, 0.0f);
            this.rb.func_147806_b(block, (double)x, (double)y, (double)z, block.func_149691_a(ForgeDirection.UP.ordinal(), 0));
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, (float)(-this.rb.field_147851_l));
            this.rb.func_147761_c(block, (double)x, (double)y, (double)z, block.func_149691_a(ForgeDirection.NORTH.ordinal(), 0));
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, (float)this.rb.field_147853_m);
            this.rb.func_147734_d(block, (double)x, (double)y, (double)z, block.func_149691_a(ForgeDirection.SOUTH.ordinal(), 0));
            if (renderingBorder) {
                Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
            }
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        RenderBlocks rbOld = this.rb;
        this.rb = renderer;
        this.render(block, x, y, z);
        this.rb = rbOld;
        return true;
    }

    private void render(Block block, int x, int y, int z) {
        this.rb.field_147837_f = true;
        renderingBorder = true;
        this.rb.func_147782_a(0.0, 0.0, 0.0, 0.0625, 0.0625, 1.0);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.9375, 0.0, 0.0, 1.0, 0.0625, 1.0);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.0625, 0.0, 0.0, 0.9375, 0.0625, 0.0625);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.0625, 0.0, 0.9375, 0.9375, 0.0625, 1.0);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.0, 0.9375, 0.0, 0.0625, 1.0, 1.0);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.9375, 0.9375, 0.0, 1.0, 1.0, 1.0);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.0625, 0.9375, 0.0, 0.9375, 1.0, 0.0625);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.0625, 0.9375, 0.9375, 0.9375, 1.0, 1.0);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.0, 0.0625, 0.0, 0.0625, 0.9375, 0.0625);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.9375, 0.0625, 0.0, 1.0, 0.9375, 0.0625);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.9375, 0.0625, 0.9375, 1.0, 0.9375, 1.0);
        this.renderStandardBlock(block, x, y, z);
        this.rb.func_147782_a(0.0, 0.0625, 0.9375, 0.0625, 0.9375, 1.0);
        this.renderStandardBlock(block, x, y, z);
        renderingBorder = false;
        this.rb.func_147782_a(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);
        this.renderStandardBlock(block, x, y, z);
        this.rb.field_147837_f = false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return RENDER_ID;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.itemRenderer = true;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        switch (type) {
            case ENTITY: {
                GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
                if (item.func_82836_z() == null) break;
                GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
                break;
            }
            case EQUIPPED: {
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                break;
            }
            case INVENTORY: {
                GL11.glTranslated((double)0.0, (double)-0.0625, (double)0.0);
                break;
            }
        }
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator.field_78398_a.func_78382_b();
        this.render(Block.func_149634_a((Item)item.func_77973_b()), 0, 0, 0);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glDisable((int)3042);
        if (!(item.func_77973_b() instanceof ItemBlockMotorCore)) {
            GL11.glPushMatrix();
            this.renderArrow(false, 0.0);
            this.renderArrow(true, 0.0);
            GL11.glPopMatrix();
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            for (ForgeDirection f : ForgeDirection.VALID_DIRECTIONS) {
                IRenderMotorSpecial[] l;
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                switch (f) {
                    case UP: {
                        break;
                    }
                    case DOWN: {
                        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                        break;
                    }
                    case WEST: {
                        GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                        break;
                    }
                    case EAST: {
                        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                        break;
                    }
                    case NORTH: {
                        GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                        break;
                    }
                    case SOUTH: {
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                        break;
                    }
                }
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                for (IRenderMotorSpecial r : l = FramezApi.inst().getMotorRegistry().getRenderers(item, f)) {
                    GL11.glPushMatrix();
                    r.renderSpecial(item, f, 0.0f);
                    GL11.glPopMatrix();
                }
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
        this.itemRenderer = false;
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float frame) {
        TileMotor te = (TileMotor)tile;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        ForgeDirection face = te.getFace();
        ForgeDirection direction = te.getDirection();
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        block0 : switch (face) {
            case UP: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                switch (direction) {
                    case WEST: {
                        break block0;
                    }
                    case EAST: {
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case NORTH: {
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case SOUTH: {
                        GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                }
                break;
            }
            case DOWN: {
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                switch (direction) {
                    case WEST: {
                        break block0;
                    }
                    case EAST: {
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case NORTH: {
                        GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case SOUTH: {
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                }
                break;
            }
            case WEST: {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                switch (direction) {
                    case UP: {
                        GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case DOWN: {
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case NORTH: {
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case SOUTH: {
                        break block0;
                    }
                }
                break;
            }
            case EAST: {
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                switch (direction) {
                    case UP: {
                        GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case DOWN: {
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case NORTH: {
                        break block0;
                    }
                    case SOUTH: {
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                }
                break;
            }
            case NORTH: {
                switch (direction) {
                    case UP: {
                        GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case DOWN: {
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case EAST: {
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case WEST: {
                        break block0;
                    }
                }
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                switch (direction) {
                    case UP: {
                        GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case DOWN: {
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                    case EAST: {
                        break block0;
                    }
                    case WEST: {
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                        break block0;
                    }
                }
                break;
            }
        }
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        GL11.glPushMatrix();
        double progress = te.getMoved();
        this.renderArrow(false, progress);
        this.renderArrow(true, progress);
        this.renderArrow(false, -progress);
        this.renderArrow(true, -progress);
        GL11.glPopMatrix();
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        for (ForgeDirection f : ForgeDirection.VALID_DIRECTIONS) {
            IRenderMotorSpecial[] l;
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            switch (f) {
                case UP: {
                    break;
                }
                case DOWN: {
                    GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                    break;
                }
                case WEST: {
                    GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                    break;
                }
                case EAST: {
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                    break;
                }
                case NORTH: {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                    break;
                }
                case SOUTH: {
                    GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                    break;
                }
            }
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            for (IRenderMotorSpecial r : l = FramezApi.inst().getMotorRegistry().getRenderers(te, f)) {
                GL11.glPushMatrix();
                r.renderSpecial(te, f, frame);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public void renderArrow(boolean direction, double progress) {
        double distSides = 4.5;
        double distBottom = 3.0;
        double thickness = 1.5;
        GL11.glPushMatrix();
        if (progress <= 0.0) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)20.0f, (float)20.0f);
        } else {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        if (direction) {
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            GL11.glTranslated((double)0.0, (double)0.0, (double)(1.0 - (distBottom + thickness / 2.0) / 8.0));
        }
        double p = (1.0 - (Math.abs(progress) * ((16.0 - distSides * 2.0) / 16.0) + distSides / 16.0)) * 1.001;
        GL11.glTranslated((double)p, (double)0.0, (double)0.0);
        if (progress <= 0.0) {
            GL11.glClipPlane((int)12288, (DoubleBuffer)RenderHelper.planeEquation(0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0));
        } else {
            GL11.glClipPlane((int)12288, (DoubleBuffer)RenderHelper.planeEquation(0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0));
        }
        GL11.glTranslated((double)(-p), (double)0.0, (double)0.0);
        GL11.glEnable((int)12288);
        this.renderArrow();
        GL11.glDisable((int)12288);
        GL11.glEnable((int)3553);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glPopMatrix();
    }

    private void renderArrow() {
        if (this.list == 0) {
            this.list = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.list, (int)4864);
            this.renderArrow_do();
            GL11.glEndList();
        }
        GL11.glCallList((int)this.list);
    }

    private void renderArrow_do() {
        double distSides = 4.5;
        double distBottom = 3.0;
        double thickness = 1.5;
        double depth = 1.0;
        GL11.glColor4d((double)1.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glDisable((int)3553);
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glBegin((int)9);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, distBottom / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, (distBottom - thickness / 2.0) / 16.0);
        RenderHelper.vertex(distSides / 16.0, 1.0, (distBottom + thickness / 2.0) / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, (distBottom + thickness + thickness / 2.0) / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, (distBottom + thickness) / 16.0);
        RenderHelper.vertex(1.0 - distSides / 16.0, 1.0, (distBottom + thickness) / 16.0);
        RenderHelper.vertex(1.0 - distSides / 16.0, 1.0, distBottom / 16.0);
        GL11.glEnd();
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glBegin((int)7);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, distBottom / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0 - depth / 16.0, distBottom / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0 - depth / 16.0, (distBottom - thickness / 2.0) / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, (distBottom - thickness / 2.0) / 16.0);
        GL11.glEnd();
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)-1.0);
        GL11.glBegin((int)7);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, (distBottom - thickness / 2.0) / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0 - depth / 16.0, (distBottom - thickness / 2.0) / 16.0);
        RenderHelper.vertex(distSides / 16.0, 1.0 - depth / 16.0, (distBottom + thickness / 2.0) / 16.0);
        RenderHelper.vertex(distSides / 16.0, 1.0, (distBottom + thickness / 2.0) / 16.0);
        GL11.glEnd();
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)1.0);
        GL11.glBegin((int)7);
        RenderHelper.vertex(distSides / 16.0, 1.0, (distBottom + thickness / 2.0) / 16.0);
        RenderHelper.vertex(distSides / 16.0, 1.0 - depth / 16.0, (distBottom + thickness / 2.0) / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0 - depth / 16.0, (distBottom + thickness + thickness / 2.0) / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, (distBottom + thickness + thickness / 2.0) / 16.0);
        GL11.glEnd();
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glBegin((int)7);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, (distBottom + thickness + thickness / 2.0) / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0 - depth / 16.0, (distBottom + thickness + thickness / 2.0) / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0 - depth / 16.0, (distBottom + thickness) / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, (distBottom + thickness) / 16.0);
        GL11.glEnd();
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glBegin((int)7);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, (distBottom + thickness) / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0 - depth / 16.0, (distBottom + thickness) / 16.0);
        RenderHelper.vertex(1.0 - distSides / 16.0, 1.0 - depth / 16.0, (distBottom + thickness) / 16.0);
        RenderHelper.vertex(1.0 - distSides / 16.0, 1.0, (distBottom + thickness) / 16.0);
        GL11.glEnd();
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glBegin((int)7);
        RenderHelper.vertex(1.0 - distSides / 16.0, 1.0, (distBottom + thickness) / 16.0);
        RenderHelper.vertex(1.0 - distSides / 16.0, 1.0 - depth / 16.0, (distBottom + thickness) / 16.0);
        RenderHelper.vertex(1.0 - distSides / 16.0, 1.0 - depth / 16.0, distBottom / 16.0);
        RenderHelper.vertex(1.0 - distSides / 16.0, 1.0, distBottom / 16.0);
        GL11.glEnd();
        GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
        GL11.glBegin((int)7);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0, distBottom / 16.0);
        RenderHelper.vertex(1.0 - distSides / 16.0, 1.0, distBottom / 16.0);
        RenderHelper.vertex(1.0 - distSides / 16.0, 1.0 - depth / 16.0, distBottom / 16.0);
        RenderHelper.vertex((distSides + thickness) / 16.0, 1.0 - depth / 16.0, distBottom / 16.0);
        GL11.glEnd();
    }
}

