/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.block;

import com.amadornes.framez.Framez;
import com.amadornes.framez.movement.MovingBlock;
import com.amadornes.framez.tile.TileMoving;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlockMoving
extends BlockContainer {
    private boolean drawingHighlight = false;

    public BlockMoving() {
        super(Material.field_151576_e);
        this.func_149663_c("moving");
        this.func_149711_c(-1.0f);
        this.func_149752_b(-1.0f);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String func_149739_a() {
        return "Moving";
    }

    public TileEntity func_149915_a(World w, int meta) {
        return new TileMoving();
    }

    private TileMoving get(IBlockAccess w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te != null && te instanceof TileMoving) {
            return (TileMoving)te;
        }
        return null;
    }

    public void func_149743_a(World w, int x, int y, int z, AxisAlignedBB aabb, List l, Entity e) {
        TileMoving te = this.get((IBlockAccess)w, x, y, z);
        if (te == null) {
            return;
        }
        te.addCollisionBoxesToList(aabb, l, e);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World w, int x, int y, int z) {
        TileMoving te = this.get((IBlockAccess)w, x, y, z);
        if (te == null) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return te.getSelectedBoundingBox();
    }

    public MovingObjectPosition func_149731_a(World w, int x, int y, int z, Vec3 start, Vec3 end) {
        TileMoving te = this.get((IBlockAccess)w, x, y, z);
        if (te == null) {
            return null;
        }
        return te.rayTrace(start, end);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return -1;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer p, int side, float subX, float subY, float subZ) {
        TileMoving te = this.get((IBlockAccess)w, x, y, z);
        if (te == null) {
            return false;
        }
        return te.onBlockActivated(p);
    }

    public void func_149674_a(World w, int x, int y, int z, Random rnd) {
        TileMoving te = this.get((IBlockAccess)w, x, y, z);
        if (te == null) {
            return;
        }
        if (te.getBlockA() == null) {
            return;
        }
        te.getBlockA().getBlock().func_149674_a(te.getBlockA().getWorldWrapper(), x, y, z, rnd);
    }

    public int getLightValue(IBlockAccess w, int x, int y, int z) {
        TileMoving te = this.get(w, x, y, z);
        if (te == null) {
            return 0;
        }
        return te.getLightValue();
    }

    public int getLightOpacity(IBlockAccess w, int x, int y, int z) {
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World w, int x, int y, int z) {
        TileMoving te = this.get((IBlockAccess)w, x, y, z);
        if (te == null) {
            return null;
        }
        return te.getPickBlock(target);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World w, int x, int y, int z, Random rnd) {
        TileMoving te = this.get((IBlockAccess)w, x, y, z);
        if (te == null) {
            return;
        }
        te.randomDisplayTick(rnd);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDrawHighlight(DrawBlockHighlightEvent event) {
        if (event == null || event.context == null || event.currentItem == null || event.player == null || event.target == null || event.target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        if (this.drawingHighlight) {
            return;
        }
        this.drawingHighlight = true;
        try {
            MovingObjectPosition mop;
            TileMoving te = this.get((IBlockAccess)event.player.field_70170_p, event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
            if (te != null && (mop = te.rayTrace(event.player)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                DrawBlockHighlightEvent ev = new DrawBlockHighlightEvent(event.context, event.player, mop, mop.subHit, event.currentItem, event.partialTicks);
                World world = event.player.field_70170_p;
                World w = null;
                double moved = 0.0;
                ForgeDirection dir = null;
                MovingBlock a = te.getBlockA();
                MovingBlock b = te.getBlockB();
                if (a != null) {
                    w = a.getWorldWrapper();
                    moved = a.getMoved() - a.getSpeed() * (1.0 - Framez.proxy.getFrame());
                    dir = a.getDirection();
                } else if (b != null) {
                    w = b.getWorldWrapper();
                    moved = b.getMoved() - b.getSpeed() * (1.0 - Framez.proxy.getFrame());
                    b.getDirection();
                }
                if (w != null) {
                    event.player.field_70170_p = w;
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)((double)dir.offsetX * moved), (double)((double)dir.offsetY * moved), (double)((double)dir.offsetZ * moved));
                    MinecraftForge.EVENT_BUS.post((Event)ev);
                    GL11.glPopMatrix();
                    if (ev.isCanceled()) {
                        event.setCanceled(true);
                    }
                    event.player.field_70170_p = world;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawingHighlight = false;
    }
}

