/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.block;

import com.amadornes.framez.api.IMotor;
import com.amadornes.framez.api.IMotorProvider;
import com.amadornes.framez.client.render.RenderMotor;
import com.amadornes.framez.init.CreativeTabFramez;
import com.amadornes.framez.tile.TileMotor;
import com.amadornes.framez.util.MotorPlacement;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMotor
extends BlockContainer
implements IMotor {
    private IMotorProvider provider;
    private MovingObjectPosition placeMOP = null;

    public BlockMotor(IMotorProvider provider) {
        super(Material.field_151573_f);
        this.provider = provider;
        this.func_149663_c("motor");
        this.func_149711_c(4.0f);
        this.func_149647_a(CreativeTabFramez.inst);
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            return this.provider.getTileClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderMotor.RENDER_ID;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        if (!world.field_72995_K) {
            TileMotor te = (TileMotor)world.func_147438_o(x, y, z);
            ForgeDirection oldFace = te.getFace();
            ForgeDirection oldDirection = te.getDirection();
            ForgeDirection face = te.getFace().getRotation(axis);
            ForgeDirection direction = te.getDirection().getRotation(axis);
            te.setFace(face, true);
            te.setDirection(direction, true);
            if (te.setFace(face) && te.setDirection(direction)) {
                return true;
            }
            te.setFace(oldFace, true);
            te.setDirection(oldDirection, true);
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack item) {
        super.func_149689_a(world, x, y, z, entity, item);
        TileMotor te = (TileMotor)world.func_147438_o(x, y, z);
        if (entity instanceof EntityPlayer && this.placeMOP != null) {
            te.setPlacer(((EntityPlayer)entity).func_146103_bH().getName());
            ForgeDirection face = ForgeDirection.getOrientation((int)this.placeMOP.field_72310_e).getOpposite();
            te.setFace(face, true);
            te.setDirection(MotorPlacement.getPlacementDirection(this.placeMOP, face), true);
            this.placeMOP = null;
        }
        te.sendUpdatePacket();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("framez:motor");
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public String func_149739_a() {
        return "tile." + this.provider.getUnlocalizedName();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess w, int x, int y, int z) {
        if (!RenderMotor.renderingBorder) {
            return 0xFFFFFF;
        }
        TileEntity te = w.func_147438_o(x, y, z);
        if (te != null && te instanceof TileMotor) {
            return ((TileMotor)te).getColorMultiplier();
        }
        return 0xFF0000;
    }

    @Override
    public IMotorProvider getProvider() {
        return this.provider;
    }

    public int func_149660_a(World w, int x, int y, int z, int side, float x_, float y_, float z_, int meta) {
        this.placeMOP = new MovingObjectPosition(x, y, z, side, Vec3.func_72443_a((double)((float)x + x_), (double)((float)y + y_), (double)((float)z + z_)));
        return super.func_149660_a(w, x, y, z, side, x_, y_, z_, meta);
    }
}

