/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.multiblock;

import com.dynious.refinedrelocation.util.BlockAndMeta;
import com.dynious.refinedrelocation.util.MultiBlockAndMeta;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;

public class MultiBlockMap {
    private Object[][][] map;

    public MultiBlockMap(int sizeX, int sizeY, int sizeZ) {
        this.map = new Object[sizeX][sizeY][sizeZ];
    }

    public void addBlockAtPos(int x, int y, int z, BlockAndMeta blockAndMeta) {
        if (x >= 0 && x < this.map.length && y >= 0 && y < this.map[0].length && z >= 0 && z < this.map[0][0].length) {
            if (this.map[x][y][z] == null) {
                this.map[x][y][z] = blockAndMeta;
            } else if (this.map[x][y][z] instanceof MultiBlockAndMeta) {
                ((MultiBlockAndMeta)this.map[x][y][z]).add(blockAndMeta);
            } else {
                this.map[x][y][z] = new MultiBlockAndMeta(Arrays.asList((BlockAndMeta)this.map[x][y][z], blockAndMeta));
            }
        }
    }

    public void addBlockAtPos(int x, int y, int z, Block block) {
        this.addBlockAtPos(x, y, z, new BlockAndMeta(block));
    }

    public void addBlocksAtPos(int x, int y, int z, BlockAndMeta ... blockAndMeta) {
        if (x >= 0 && x < this.map.length && y >= 0 && y < this.map[0].length && z >= 0 && z < this.map[0][0].length) {
            if (this.map[x][y][z] == null) {
                this.map[x][y][z] = new MultiBlockAndMeta(Arrays.asList(blockAndMeta));
            } else if (this.map[x][y][z] instanceof MultiBlockAndMeta) {
                ((MultiBlockAndMeta)this.map[x][y][z]).add(Arrays.asList(blockAndMeta));
            } else {
                ArrayList<BlockAndMeta> l = new ArrayList<BlockAndMeta>(Arrays.asList(blockAndMeta));
                l.add((BlockAndMeta)this.map[x][y][z]);
                this.map[x][y][z] = new MultiBlockAndMeta(l);
            }
        }
    }

    public Object getBlockAndMetaAtPos(int x, int y, int z) {
        if (x >= 0 && x < this.map.length && y >= 0 && y < this.map[0].length && z >= 0 && z < this.map[0][0].length) {
            return this.map[x][y][z];
        }
        return null;
    }

    public int getSizeX() {
        return this.map.length;
    }

    public int getSizeY() {
        return this.map[0].length;
    }

    public int getSizeZ() {
        return this.map[0][0].length;
    }
}

