/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.item;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.block.ModBlocks;
import com.dynious.refinedrelocation.helper.MiscHelper;
import com.dynious.refinedrelocation.helper.ParticleHelper;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Settings;
import com.dynious.refinedrelocation.lib.Sounds;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileRelocationController;
import com.dynious.refinedrelocation.tileentity.TileRelocationPortal;
import com.dynious.refinedrelocation.util.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.FOVUpdateEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class ItemPlayerRelocator
extends Item {
    public static final String UUID_TAG = "UUID";
    public static final String DIMENSION_TAG = "dimId";
    public static final String INTER_LINK_TAG = "interLink";
    public static final String TIME = "time";

    public ItemPlayerRelocator() {
        this.func_77655_b("playerRelocator");
        this.func_77637_a(RefinedRelocation.tabRefinedRelocation);
        this.func_77625_d(1);
    }

    public static long getTimeDifference(ItemStack stack) {
        return System.currentTimeMillis() - stack.func_77978_p().func_74763_f(TIME);
    }

    public static int getTimeLeft(ItemStack stack, EntityPlayer player) {
        int cooldown = player.field_71075_bZ.field_75098_d ? 1 : Settings.PLAYER_RELOCATOR_COOLDOWN;
        return (int)((long)cooldown - ItemPlayerRelocator.getTimeDifference(stack) / 1000L);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocationController) {
            TileRelocationController tileController = (TileRelocationController)tile;
            if (tileController.isFormed(true)) {
                if (tileController.isLocked) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.CONTROLLER_LOCKED)));
                    return false;
                }
                if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(UUID_TAG)) {
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74778_a(UUID_TAG, UUID.randomUUID().toString());
                }
                stack.func_77978_p().func_74757_a(INTER_LINK_TAG, tileController.isIntraLinker());
                stack.func_77978_p().func_74768_a(DIMENSION_TAG, tile.func_145831_w().field_73011_w.field_76574_g);
                stack.func_77978_p().func_74768_a("x", x);
                stack.func_77978_p().func_74768_a("y", y);
                stack.func_77978_p().func_74768_a("z", z);
                tileController.setLinkedUUID(stack.func_77978_p().func_74779_i(UUID_TAG));
                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.PLAYER_RELOCATOR_LINK)));
            }
            return true;
        }
        return false;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 45;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("x") && ItemPlayerRelocator.getTimeDifference(stack) / 1000L > (long)(player.field_71075_bZ.field_75098_d ? 1 : Settings.PLAYER_RELOCATOR_COOLDOWN)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
            world.func_72956_a((Entity)player, Sounds.ambiance, 1.0f, 1.0f);
            ParticleHelper.spawnParticlesInCircle("portal", 2.0f, 100, world, player.field_70165_t, player.field_70163_u - 0.5, player.field_70161_v, true);
        }
        return stack;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        TileEntity connectedTile;
        WorldServer linkedWorld;
        if (world.field_72995_K) {
            return stack;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("x") && (linkedWorld = MinecraftServer.func_71276_C().func_71218_a(stack.func_77978_p().func_74762_e(DIMENSION_TAG))) != null && (world == linkedWorld || stack.func_77978_p().func_74767_n(INTER_LINK_TAG)) && (connectedTile = linkedWorld.func_147438_o(stack.func_77978_p().func_74762_e("x"), stack.func_77978_p().func_74762_e("y"), stack.func_77978_p().func_74762_e("z"))) != null && connectedTile instanceof TileRelocationController && ((TileRelocationController)connectedTile).isFormed(true)) {
            int zPos;
            int yPos;
            if (world != linkedWorld && !((TileRelocationController)connectedTile).isIntraLinker() || ArrayUtils.contains((int[])Settings.PLAYER_RELOCATOR_DISABLED_AGES, (int)world.field_73011_w.field_76574_g)) {
                return stack;
            }
            if (!stack.func_77978_p().func_74779_i(UUID_TAG).equals(((TileRelocationController)connectedTile).getLinkedUUID())) {
                stack.func_77978_p().func_82580_o(UUID_TAG);
                return stack;
            }
            int xPos = MathHelper.func_76128_c((double)player.field_70165_t);
            if (this.checkBlocks(world, xPos, yPos = MathHelper.func_76128_c((double)player.field_70163_u), zPos = MathHelper.func_76128_c((double)player.field_70161_v))) {
                player.func_70634_a((double)xPos + 0.5, (double)yPos, (double)zPos + 0.5);
                this.setBlockToPortal(world, xPos, yPos - 1, zPos);
                this.setBlockToPortal(world, xPos, yPos - 2, zPos);
                if (stack.func_77978_p().func_74764_b(DIMENSION_TAG)) {
                    this.setLowerBlockToDimensionalPortal(world, xPos, yPos - 3, zPos, new Vector3(connectedTile.field_145851_c, connectedTile.field_145848_d, connectedTile.field_145849_e), stack.func_77978_p().func_74762_e(DIMENSION_TAG));
                } else {
                    this.setLowerBlockToPortal(world, xPos, yPos - 3, zPos, new Vector3(connectedTile.field_145851_c, connectedTile.field_145848_d, connectedTile.field_145849_e));
                }
                world.func_72956_a((Entity)player, Sounds.explosion, 1.0f, 1.0f);
                stack.func_77978_p().func_74772_a(TIME, System.currentTimeMillis());
            }
        }
        return stack;
    }

    private boolean checkBlocks(World world, int x, int y, int z) {
        return this.isBlockReplaceable(world, x, y - 1, z) && this.isBlockReplaceable(world, x, y - 2, z) && this.isBlockReplaceable(world, x, y - 3, z);
    }

    private boolean isBlockReplaceable(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return world.func_147438_o(x, y, z) == null && block != Blocks.field_150357_h && block != ModBlocks.relocationPortal && !block.func_149742_c(world, x, y, z) && block.func_149712_f(world, x, y, z) != -1.0f;
    }

    private void setBlockToPortal(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        world.func_147449_b(x, y, z, (Block)ModBlocks.relocationPortal);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocationPortal) {
            ((TileRelocationPortal)tile).init(block, blockMeta);
        }
    }

    private void setLowerBlockToPortal(World world, int x, int y, int z, Vector3 linkedPos) {
        Block block = world.func_147439_a(x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        world.func_147449_b(x, y, z, (Block)ModBlocks.relocationPortal);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocationPortal) {
            ((TileRelocationPortal)tile).init(block, blockMeta, linkedPos);
        }
    }

    private void setLowerBlockToDimensionalPortal(World world, int x, int y, int z, Vector3 linkedPos, int dimensionId) {
        Block block = world.func_147439_a(x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        world.func_147449_b(x, y, z, (Block)ModBlocks.relocationPortal);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocationPortal) {
            ((TileRelocationPortal)tile).init(block, blockMeta, linkedPos, dimensionId);
        }
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean b) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("x")) {
            list.add(StatCollector.func_74837_a((String)Strings.LINKED_TO_AT, (Object[])new Object[]{StatCollector.func_74838_a((String)"tile.relocationController.name"), itemStack.func_77978_p().func_74762_e("x"), itemStack.func_77978_p().func_74762_e("y"), itemStack.func_77978_p().func_74762_e("z")}));
            if (itemStack.func_77978_p().func_74767_n(INTER_LINK_TAG)) {
                WorldProvider p = WorldProvider.func_76570_a((int)itemStack.func_77978_p().func_74762_e(DIMENSION_TAG));
                String worldString = p != null ? p.func_80007_l() : "<Error>";
                list.add(StatCollector.func_74837_a((String)Strings.INTER_DIMENSIONAL, (Object[])new Object[]{worldString}));
            }
            if (!itemStack.func_77978_p().func_74764_b(UUID_TAG)) {
                list.add("\u00a74" + StatCollector.func_74838_a((String)Strings.BROKEN_LINK));
            }
            if (ItemPlayerRelocator.getTimeLeft(itemStack, player) > 0) {
                list.add("\u00a7e" + StatCollector.func_74837_a((String)Strings.COOLDOWN, (Object[])new Object[]{MiscHelper.getDurationString(ItemPlayerRelocator.getTimeLeft(itemStack, player))}));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a(Resources.MOD_ID + ":" + "playerRelocator");
    }

    @SideOnly(value=Side.CLIENT)
    public void shiftFOV(ItemStack stack, FOVUpdateEvent event) {
        float inUse = stack.func_77988_m() - Minecraft.func_71410_x().field_71439_g.func_71052_bv();
        event.newfov = event.fov + inUse / 110.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDisplayDamage(ItemStack stack) {
        EntityClientPlayerMP player;
        if (stack.func_77942_o() && ItemPlayerRelocator.getTimeLeft(stack, (EntityPlayer)(player = Minecraft.func_71410_x().field_71439_g)) > 0) {
            return ItemPlayerRelocator.getTimeLeft(stack, (EntityPlayer)player);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getMaxDamage(ItemStack stack) {
        if (stack.func_77942_o()) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            return player.field_71075_bZ.field_75098_d ? 1 : Settings.PLAYER_RELOCATOR_COOLDOWN;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77645_m() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isDamaged(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            return ItemPlayerRelocator.getTimeLeft(itemStack, (EntityPlayer)player) > 0;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBlur(ItemStack stack, ScaledResolution resolution) {
        float inUse = ((float)stack.func_77988_m() - (float)Minecraft.func_71410_x().field_71439_g.func_71052_bv()) / (float)stack.func_77988_m();
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        float scale = 2.0f / inUse;
        Vector2f sourceCenter = new Vector2f((float)(resolution.func_78326_a() / 2), (float)(resolution.func_78328_b() / 2));
        Vector2f destCenter = new Vector2f((float)(resolution.func_78326_a() / 2), (float)(resolution.func_78328_b() / 2));
        GL11.glTranslatef((float)destCenter.getX(), (float)destCenter.getY(), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)0.0f);
        GL11.glTranslatef((float)(sourceCenter.getX() * -1.0f), (float)(sourceCenter.getY() * -1.0f), (float)0.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.TEXTURE_BLUR);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)resolution.func_78328_b(), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)resolution.func_78326_a(), 0.0, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

