/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.relocator.IItemRelocator;
import com.dynious.refinedrelocation.api.relocator.RelocatorModuleBase;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.client.gui.GuiFiltered;
import com.dynious.refinedrelocation.container.ContainerFiltered;
import com.dynious.refinedrelocation.grid.FilterStandard;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class RelocatorModuleFilter
extends RelocatorModuleBase {
    private static IIcon icon;
    private FilterStandard filter;
    private FilterStandard filterWaila;
    private long lastChange = -401L;
    private IItemRelocator relocator;

    @Override
    public void init(IItemRelocator relocator, int side) {
        this.filter = new FilterStandard(this.getFilterTile(this, relocator));
        this.relocator = relocator;
    }

    @Override
    public boolean onActivated(IItemRelocator relocator, EntityPlayer player, int side, ItemStack stack) {
        APIUtils.openRelocatorModuleGUI(relocator, player, side);
        return true;
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"item.relocatorModule1.name");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(IItemRelocator relocator, int side, EntityPlayer player) {
        return new GuiFiltered(this.getFilterTile(this, relocator));
    }

    @Override
    public Container getContainer(IItemRelocator relocator, int side, EntityPlayer player) {
        return new ContainerFiltered(this.getFilterTile(this, relocator));
    }

    @Override
    public boolean passesFilter(IItemRelocator relocator, int side, ItemStack stack, boolean input, boolean simulate) {
        return !simulate && relocator.getTileEntity().func_145831_w().func_82737_E() - this.lastChange > 400L || this.filter.passesFilter(stack);
    }

    @Override
    public List<ItemStack> getDrops(IItemRelocator relocator, int side) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)ModItems.relocatorModule, 1, 1));
        return list;
    }

    private IFilterTileGUI getFilterTile(final RelocatorModuleFilter module, final IItemRelocator relocator) {
        return new IFilterTileGUI(){

            @Override
            public IFilterGUI getFilter() {
                return module.filter;
            }

            @Override
            public TileEntity getTileEntity() {
                return relocator.getTileEntity();
            }

            @Override
            public void onFilterChanged() {
                RelocatorModuleFilter.this.lastChange = relocator.getTileEntity().func_145831_w().func_82737_E();
                relocator.getTileEntity().func_70296_d();
            }
        };
    }

    @Override
    public void readFromNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        this.filter.readFromNBT(compound);
    }

    @Override
    public void writeToNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        this.filter.writeToNBT(compound);
    }

    @Override
    public IIcon getIcon(IItemRelocator relocator, int side) {
        return icon;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a(Resources.MOD_ID + ":" + "relocatorModuleFilter");
    }

    @Override
    public List<String> getWailaInformation(NBTTagCompound nbtData) {
        if (this.filterWaila == null) {
            this.filterWaila = new FilterStandard(this.getFilterTile(this, this.relocator));
        }
        ArrayList<String> information = new ArrayList<String>();
        this.filterWaila.readFromNBT(nbtData);
        information.addAll(this.filterWaila.getWAILAInformation(nbtData));
        return information;
    }
}

