/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid;

import com.dynious.refinedrelocation.api.tileentity.grid.IGrid;
import com.dynious.refinedrelocation.api.tileentity.handlers.IGridMemberHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Grid
implements IGrid {
    protected ArrayList<IGridMemberHandler> members;

    @Override
    public void addMember(IGridMemberHandler member) {
        if (this.members == null) {
            this.members = new ArrayList();
        }
        if (!this.members.contains(member)) {
            this.removeDuplicateMember(member);
            this.members.add(member);
        }
    }

    private void removeDuplicateMember(IGridMemberHandler member) {
        Iterator<IGridMemberHandler> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            IGridMemberHandler member1 = iterator.next();
            if (member.getOwner().field_145851_c != member1.getOwner().field_145851_c || member.getOwner().field_145848_d != member1.getOwner().field_145848_d || member.getOwner().field_145849_e != member1.getOwner().field_145849_e) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public void removeMember(IGridMemberHandler member) {
        if (this.members != null) {
            this.members.remove(member);
        }
    }

    @Override
    public void resetMembers() {
        if (this.members != null && !this.members.isEmpty()) {
            ArrayList<IGridMemberHandler> tempMembers = new ArrayList<IGridMemberHandler>(this.members);
            this.members = null;
            for (IGridMemberHandler member : tempMembers) {
                member.setGrid(null);
            }
            for (IGridMemberHandler member : tempMembers) {
                member.onTileAdded();
            }
        }
    }

    @Override
    public List<IGridMemberHandler> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    @Override
    public void mergeToGrid(IGrid grid) {
        if (this.members != null) {
            for (IGridMemberHandler child : this.members) {
                child.setGrid(grid);
            }
        }
        this.members = null;
    }
}

