/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid;

import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.helper.LogHelper;
import com.dynious.refinedrelocation.helper.StringHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class FilterStandard
implements IFilterGUI {
    public static final int FILTER_SIZE = 14;
    private static CreativeTabs[] tabs = CreativeTabs.field_78032_a;
    private boolean[] customFilters = new boolean[14];
    private IFilterTileGUI tile;
    private boolean[] creativeTabs = new boolean[tabs.length];
    private String userFilter = "";
    private boolean blacklists = false;

    public FilterStandard(IFilterTileGUI tile) {
        this.tile = tile;
    }

    public static boolean stringMatchesWildcardPattern(String string, String wildcardPattern) {
        return wildcardPattern.startsWith("*") && wildcardPattern.length() > 1 ? (wildcardPattern.endsWith("*") && wildcardPattern.length() > 2 ? string.contains(wildcardPattern.substring(1, wildcardPattern.length() - 1)) : string.endsWith(wildcardPattern.substring(1))) : (wildcardPattern.endsWith("*") && wildcardPattern.length() > 1 ? string.startsWith(wildcardPattern.substring(0, wildcardPattern.length() - 1)) : string.equalsIgnoreCase(wildcardPattern));
    }

    public static String[] getOreNames(ItemStack itemStack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)itemStack);
        String[] oreNames = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            oreNames[i] = OreDictionary.getOreName((int)ids[i]).toLowerCase().replaceAll("\\s+", "");
        }
        return oreNames;
    }

    public static void syncTabs(String[] tabLabels) {
        tabs = new CreativeTabs[tabLabels.length];
        for (int i = 0; i < tabLabels.length; ++i) {
            String label = tabLabels[i];
            if (label != null) {
                for (CreativeTabs tab : CreativeTabs.field_78032_a) {
                    if (!label.equalsIgnoreCase(tab.func_78013_b())) continue;
                    FilterStandard.tabs[i] = tab;
                }
            }
            if (tabs[i] != null) continue;
            FilterStandard.tabs[i] = FilterStandard.createNewFakeTab(label);
        }
    }

    public static String[] getLabels() {
        String[] labels = new String[CreativeTabs.field_78032_a.length];
        CreativeTabs[] creativeTabArray = CreativeTabs.field_78032_a;
        for (int i = 0; i < creativeTabArray.length; ++i) {
            labels[i] = creativeTabArray[i].field_78034_o;
        }
        return labels;
    }

    public static CreativeTabs createNewFakeTab(String tabName) {
        CreativeTabs oldTab = CreativeTabs.field_78032_a[0];
        CreativeTabs tab = new CreativeTabs(0, tabName){

            public Item func_78016_d() {
                return null;
            }
        };
        CreativeTabs.field_78032_a[0] = oldTab;
        return tab;
    }

    @Override
    public int getSize() {
        return this.creativeTabs.length - 2 + 14;
    }

    @Override
    public boolean passesFilter(ItemStack itemStack) {
        return this.isBlacklisting() ? !this.isInFilter(itemStack) : this.isInFilter(itemStack);
    }

    private boolean isInFilter(ItemStack itemStack) {
        if (itemStack != null) {
            CreativeTabs tab;
            String[] oreNames = null;
            if (this.getUserFilter() != null && !this.getUserFilter().isEmpty()) {
                String filter = this.getUserFilter().toLowerCase().replaceAll("\\s+", "");
                String itemName = null;
                for (String s : filter.split(",")) {
                    if (s.contains("!")) {
                        if (oreNames == null) {
                            oreNames = FilterStandard.getOreNames(itemStack);
                        }
                        s = s.replace("!", "");
                        for (String oreName : oreNames) {
                            if (!FilterStandard.stringMatchesWildcardPattern(oreName, s)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (itemName == null) {
                        try {
                            itemName = itemStack.func_82833_r().toLowerCase().replaceAll("\\s+", "");
                        }
                        catch (Exception e) {
                            LogHelper.error("Encountered an error when retrieving item name of: " + itemStack.toString());
                            break;
                        }
                    }
                    if (!FilterStandard.stringMatchesWildcardPattern(itemName, s)) continue;
                    return true;
                }
            }
            if (Booleans.contains((boolean[])this.customFilters, (boolean)true)) {
                if (oreNames == null) {
                    oreNames = FilterStandard.getOreNames(itemStack);
                }
                for (String oreName : oreNames) {
                    if (this.customFilters[0] && (oreName.contains("ingot") || itemStack.func_77973_b() == Items.field_151042_j || itemStack.func_77973_b() == Items.field_151043_k)) {
                        return true;
                    }
                    if (this.customFilters[1] && oreName.contains("ore")) {
                        return true;
                    }
                    if (this.customFilters[2] && oreName.contains("log")) {
                        return true;
                    }
                    if (this.customFilters[3] && oreName.contains("plank")) {
                        return true;
                    }
                    if (this.customFilters[4] && oreName.contains("dust")) {
                        return true;
                    }
                    if (this.customFilters[5] && oreName.contains("crushed") && !oreName.contains("purified")) {
                        return true;
                    }
                    if (this.customFilters[6] && oreName.contains("purified")) {
                        return true;
                    }
                    if (this.customFilters[7] && oreName.contains("plate")) {
                        return true;
                    }
                    if (this.customFilters[8] && oreName.contains("gem")) {
                        return true;
                    }
                    if (this.customFilters[10] && oreName.contains("dye")) {
                        return true;
                    }
                    if (!this.customFilters[11] || !oreName.contains("nugget")) continue;
                    return true;
                }
                if (this.customFilters[9] && itemStack.func_77973_b() instanceof ItemFood) {
                    return true;
                }
                if (this.customFilters[12] && itemStack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)itemStack.func_77973_b()) instanceof IPlantable) {
                    return true;
                }
                if (this.customFilters[13] && TileEntityFurnace.func_145952_a((ItemStack)itemStack) > 0) {
                    return true;
                }
            }
            if (Booleans.contains((boolean[])this.creativeTabs, (boolean)true) && (tab = itemStack.func_77973_b() instanceof ItemBlock ? Block.func_149729_e((int)ItemBlock.func_150891_b((Item)itemStack.func_77973_b())).field_149772_a : itemStack.func_77973_b().field_77701_a) != null) {
                int index = tab.field_78033_n;
                for (int i = 0; i < this.creativeTabs.length; ++i) {
                    if (!this.creativeTabs[i] || index != i) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void setValue(int place, boolean value) {
        if (place < this.customFilters.length) {
            this.customFilters[place] = value;
        } else {
            this.creativeTabs[this.getCreativeTab((int)place)] = value;
        }
        this.tile.onFilterChanged();
    }

    @Override
    public boolean getValue(int place) {
        if (place < this.customFilters.length) {
            return this.customFilters[place];
        }
        return this.creativeTabs[this.getCreativeTab(place)];
    }

    @Override
    public String getName(int place) {
        switch (place) {
            case 0: {
                return StatCollector.func_74838_a((String)Strings.INGOT_FILTER);
            }
            case 1: {
                return StatCollector.func_74838_a((String)Strings.ORE_FILTER);
            }
            case 2: {
                return StatCollector.func_74838_a((String)Strings.LOG_FILTER);
            }
            case 3: {
                return StatCollector.func_74838_a((String)Strings.PLANK_FILTER);
            }
            case 4: {
                return StatCollector.func_74838_a((String)Strings.DUST_FILTER);
            }
            case 5: {
                return StatCollector.func_74838_a((String)Strings.CRUSHED_ORE_FILTER);
            }
            case 6: {
                return StatCollector.func_74838_a((String)Strings.PURIFIED_ORE_FILTER);
            }
            case 7: {
                return StatCollector.func_74838_a((String)Strings.PLATE_FILTER);
            }
            case 8: {
                return StatCollector.func_74838_a((String)Strings.GEM_FILTER);
            }
            case 9: {
                return StatCollector.func_74838_a((String)Strings.FOOD_FILTER);
            }
            case 10: {
                return StatCollector.func_74838_a((String)Strings.DYE_FILTER);
            }
            case 11: {
                return StatCollector.func_74838_a((String)Strings.NUGGET_FILTER);
            }
            case 12: {
                return StatCollector.func_74838_a((String)Strings.PLANT_FILTER);
            }
            case 13: {
                return StatCollector.func_74838_a((String)Strings.FUEL_FILTER);
            }
        }
        return I18n.func_135052_a((String)tabs[this.getCreativeTab(place)].func_78024_c(), (Object[])new Object[0]).replace("itemGroup.", "");
    }

    public int getCreativeTab(int place) {
        int index = place - 14;
        if (index >= 5) {
            ++index;
        }
        if (index >= 11) {
            ++index;
        }
        return index;
    }

    @Override
    public boolean isBlacklisting() {
        return this.blacklists;
    }

    @Override
    public void setBlacklists(boolean blacklists) {
        this.blacklists = blacklists;
        this.tile.onFilterChanged();
    }

    @Override
    public String getUserFilter() {
        return this.userFilter;
    }

    @Override
    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
        this.tile.onFilterChanged();
    }

    @Override
    public List<String> getWAILAInformation(NBTTagCompound nbtData) {
        ArrayList<String> filter = new ArrayList<String>();
        filter.add(StringHelper.getLocalizedString(Strings.MODE) + ": " + (nbtData.func_74767_n("blacklists") ? StringHelper.getLocalizedString(Strings.BLACKLIST) : StringHelper.getLocalizedString(Strings.WHITELIST)));
        if (nbtData.func_74764_b("userFilter") && StringUtils.isNotBlank((CharSequence)nbtData.func_74779_i("userFilter"))) {
            filter.add(StatCollector.func_74837_a((String)Strings.WAILA_USER_FILTER, (Object[])new Object[]{StringUtils.abbreviate((String)nbtData.func_74779_i("userFilter"), (int)40)}));
        }
        int usedPresets = 0;
        for (int i = 0; i < this.getSize() && usedPresets < 2; ++i) {
            if (!this.getValue(i)) continue;
            filter.add(" " + this.getName(i) + (i == 1 ? " " + StringHelper.getLocalizedString(Strings.ELLIPSE) : ""));
            ++usedPresets;
        }
        return filter;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("userFilter", this.getUserFilter());
        compound.func_74757_a("blacklists", this.isBlacklisting());
        for (int i = 0; i < this.customFilters.length; ++i) {
            compound.func_74757_a("cumstomFilters" + i, this.customFilters[i]);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tabs.length && i < this.creativeTabs.length; ++i) {
            if (!this.creativeTabs[i]) continue;
            builder.append(FilterStandard.tabs[i].field_78034_o).append("^$");
        }
        compound.func_74778_a("filters", builder.toString());
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.userFilter = compound.func_74779_i("userFilter");
        this.blacklists = compound.func_74767_n("blacklists");
        for (int i = 0; i < this.customFilters.length; ++i) {
            this.customFilters[i] = compound.func_74767_n("cumstomFilters" + i);
        }
        String filters = compound.func_74779_i("filters");
        for (String string : filters.split("\\^\\$")) {
            for (int i = 0; i < tabs.length && i < this.creativeTabs.length; ++i) {
                if (!string.equals(FilterStandard.tabs[i].field_78034_o)) continue;
                this.creativeTabs[i] = true;
            }
        }
        for (int i = 0; compound.func_74764_b("creativeTabs" + i) && i < this.creativeTabs.length; ++i) {
            this.creativeTabs[i] = compound.func_74767_n("creativeTabs" + i);
        }
    }
}

