/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButtonCounter;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleCrafting;
import com.dynious.refinedrelocation.lib.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonMaxCraftStack
extends GuiButtonCounter {
    protected RelocatorModuleCrafting tile;

    public GuiButtonMaxCraftStack(IGuiParent parent, int x, int y, RelocatorModuleCrafting tile) {
        super(parent, x, y, 24, 20, 0, 0, 0, 64, 1, 16);
        this.tile = tile;
        this.update();
    }

    @Override
    protected void onValueChangedByUser(double newValue) {
        if (this.tile == null) {
            return;
        }
        this.tile.setMaxCraftStack((int)newValue);
        this.getContainer().sendMessage(0, (int)newValue);
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> subTooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(StatCollector.func_74838_a((String)Strings.MAX_CRAFT_STACK));
            tooltip.addAll(subTooltip);
            return tooltip;
        }
        return subTooltip;
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setValue(this.tile.getMaxCraftStack());
        }
        super.update();
    }
}

