/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.GuiButtonToggle;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessageBlackList;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonBlacklist
extends GuiButtonToggle {
    protected IFilterTileGUI tile;

    public GuiButtonBlacklist(IGuiParent parent, int x, int y, IFilterTileGUI tile) {
        super(parent, x, y, 24, 20, 24, 0, null, null);
        this.tile = tile;
        this.update();
    }

    @Override
    protected void onStateChangedByUser(boolean newState) {
        if (this.tile == null) {
            return;
        }
        this.tile.getFilter().setBlacklists(newState);
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageBlackList(newState));
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> tooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            tooltip.add(StatCollector.func_74838_a((String)(this.getState() ? Strings.BLACKLIST : Strings.WHITELIST)));
        }
        return tooltip;
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setState(this.tile.getFilter().isBlacklisting());
        }
        super.update();
    }
}

