/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import cofh.lib.gui.GuiColor;
import java.util.List;
import matteroverdrive.client.render.tileentity.TileEntityRendererPatternMonitor;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class RenderUtils {
    private static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    private static TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private static RenderItem renderItem = new RenderItem();

    public static void renderStack(int x, int y, ItemStack stack) {
        RenderUtils.renderStack(x, y, stack, false);
    }

    public static void renderStack(int x, int y, ItemStack stack, boolean renderOverlay) {
        if (stack != null && stack.func_77973_b() != null) {
            GL11.glPushMatrix();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74520_c();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            RenderUtils.renderItem.field_77023_b = 200.0f;
            FontRenderer font = null;
            if (stack != null) {
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (font == null) {
                font = Minecraft.func_71410_x().field_71466_p;
            }
            renderItem.func_82406_b(font, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
            if (renderOverlay) {
                renderItem.func_94148_a(font, Minecraft.func_71410_x().func_110434_K(), stack, x, y, stack.field_77994_a > 1 ? Integer.toString(stack.field_77994_a) : null);
            }
            RenderUtils.renderItem.field_77023_b = 0.0f;
            GL11.glEnable((int)3008);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
        }
    }

    public static void renderStack(int x, int y, ItemStack stack, float opacity) {
        if (stack != null && stack.func_77973_b() != null) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2884);
            GL11.glDepthMask((boolean)true);
            RenderHelper.func_74520_c();
            renderItem.func_77015_a(fontRenderer, textureManager, stack, x, y);
            RenderHelper.func_74518_a();
            GL11.glEnable((int)2884);
        }
    }

    public static void rotateFromBlock(World world, int x, int y, int z) {
        if (world != null) {
            int metadata = world.func_72805_g(x, y, z);
            ForgeDirection direction = ForgeDirection.values()[metadata];
            if (direction == ForgeDirection.WEST) {
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            } else if (direction == ForgeDirection.EAST) {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            } else if (direction == ForgeDirection.NORTH) {
                GL11.glRotated((double)-180.0, (double)0.0, (double)1.0, (double)0.0);
            }
        }
    }

    public static void rotateFromBlock(Matrix4f mat, IBlockAccess world, int x, int y, int z) {
        if (world != null) {
            int metadata = world.func_72805_g(x, y, z);
            ForgeDirection direction = ForgeDirection.values()[metadata];
            Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
            if (direction == ForgeDirection.WEST) {
                mat.rotate(-1.5707964f, axis);
            } else if (direction == ForgeDirection.EAST) {
                mat.rotate(1.5707964f, axis);
            } else if (direction == ForgeDirection.NORTH) {
                mat.rotate((float)(-Math.PI), axis);
            }
        }
    }

    public static void drawCircle(double radius, int segments) {
        GL11.glBegin((int)9);
        for (int i = 0; i < segments; ++i) {
            GL11.glVertex3d((double)(Math.sin((double)i / (double)segments * Math.PI * 2.0) * radius), (double)(Math.cos((double)i / (double)segments * Math.PI * 2.0) * radius), (double)0.0);
        }
        GL11.glEnd();
    }

    public static void drawPlane(double size) {
        RenderUtils.drawPlane(size, size);
    }

    public static void drawPlane(double x, double y, double z, double sizeX, double sizeY) {
        RenderUtils.drawPlaneWithUV(x, y, z, sizeX, sizeY, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawPlane(double sizeX, double sizeY) {
        RenderUtils.drawPlaneWithUV(0.0, 0.0, 0.0, sizeX, sizeY, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawPlaneWithUV(double sizeX, double sizeY, double uStart, double vStart, double uSize, double vSize) {
        RenderUtils.drawPlaneWithUV(0.0, 0.0, 0.0, sizeX, sizeY, uStart, vStart, uSize, vSize);
    }

    public static void drawPlaneWithUV(double x, double y, double z, double sizeX, double sizeY, double uStart, double vStart, double uSize, double vSize) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + sizeX, y + sizeY, z, uStart + uSize, vStart + vSize);
        tessellator.func_78374_a(x + sizeX, y, z, uStart + uSize, vStart);
        tessellator.func_78374_a(x, y, z, uStart, vStart);
        tessellator.func_78374_a(x, y + sizeY, z, uStart, vStart + vSize);
        tessellator.func_78381_a();
    }

    public static void drawStencil(int xMin, int yMin, int xMax, int yMax, int mask) {
        GL11.glDisable((int)3553);
        GL11.glStencilFunc((int)519, (int)mask, (int)mask);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)1);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78377_a((double)xMin, (double)yMax, 0.0);
        Tessellator.field_78398_a.func_78377_a((double)xMax, (double)yMax, 0.0);
        Tessellator.field_78398_a.func_78377_a((double)xMax, (double)yMin, 0.0);
        Tessellator.field_78398_a.func_78377_a((double)xMin, (double)yMin, 0.0);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glStencilFunc((int)514, (int)mask, (int)mask);
        GL11.glStencilMask((int)0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
    }

    public static void drawCube(double sizeX, double sizeY, double sizeZ, GuiColor color) {
        RenderUtils.drawCube(0.0, 0.0, 0.0, sizeX, sizeY, sizeZ, color);
    }

    public static void drawCube(double sizeX, double sizeY, double sizeZ, GuiColor color, float multiply) {
        RenderUtils.drawCube(0.0, 0.0, 0.0, sizeX, sizeY, sizeZ, new GuiColor((int)((float)color.getIntR() * multiply), (int)((float)color.getIntG() * multiply), (int)((float)color.getIntB() * multiply)));
    }

    public static void drawCube(double x, double y, double z, double sizeX, double sizeY, double sizeZ, GuiColor color) {
        RenderUtils.drawCube(x, y, z, sizeX, sizeY, sizeZ, 0.0, 0.0, 1.0, 1.0, color);
    }

    public static void drawCube(double x, double y, double z, double sizeX, double sizeY, double sizeZ, double minU, double minV, double maxU, double maxV, GuiColor color) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        if (color != null) {
            tessellator.func_78370_a(color.getIntR(), color.getIntG(), color.getIntB(), color.getIntA());
        }
        tessellator.func_78374_a(x, y, z, minU, minV);
        tessellator.func_78374_a(x + sizeX, y, z, maxU, minV);
        tessellator.func_78374_a(x + sizeX, y, z + sizeZ, maxU, maxV);
        tessellator.func_78374_a(x, y, z + sizeZ, minU, maxV);
        tessellator.func_78374_a(x + sizeX, y + sizeY, z, maxU, minV);
        tessellator.func_78374_a(x, y + sizeY, z, minU, minV);
        tessellator.func_78374_a(x, y + sizeY, z + sizeZ, minU, maxV);
        tessellator.func_78374_a(x + sizeX, y + sizeY, z + sizeZ, maxU, maxV);
        tessellator.func_78374_a(x, y, z, minU, minV);
        tessellator.func_78374_a(x, y, z + sizeZ, maxU, minV);
        tessellator.func_78374_a(x, y + sizeY, z + sizeZ, maxU, maxV);
        tessellator.func_78374_a(x, y + sizeY, z, minU, maxV);
        tessellator.func_78374_a(x + sizeX, y, z + sizeZ, maxU, minV);
        tessellator.func_78374_a(x + sizeX, y, z, minU, minV);
        tessellator.func_78374_a(x + sizeX, y + sizeY, z, minU, maxV);
        tessellator.func_78374_a(x + sizeX, y + sizeY, z + sizeZ, maxU, maxV);
        tessellator.func_78374_a(x, y, z, minU, minV);
        tessellator.func_78374_a(x, y + sizeY, z, minU, maxV);
        tessellator.func_78374_a(x + sizeX, y + sizeY, z, maxU, maxV);
        tessellator.func_78374_a(x + sizeX, y, z, maxU, minV);
        tessellator.func_78374_a(x, y + sizeY, z + sizeZ, minU, maxV);
        tessellator.func_78374_a(x, y, z + sizeZ, minU, minV);
        tessellator.func_78374_a(x + sizeX, y, z + sizeZ, maxU, minV);
        tessellator.func_78374_a(x + sizeX, y + sizeY, z + sizeZ, maxU, maxV);
        tessellator.func_78381_a();
    }

    public static void tesseleteModelAsBlock(Matrix4f mat, GroupObject object, IIcon icon, int x, int y, int z, int brightness, boolean lighting, GuiColor color) {
        float uSize = icon.func_94212_f() - icon.func_94209_e();
        float vSize = icon.func_94210_h() - icon.func_94206_g();
        float textureOffset = 5.0E-5f;
        Vector4f pos = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        for (Face face : object.faces) {
            if (face.faceNormal == null) {
                face.faceNormal = face.calculateFaceNormal();
            }
            float averageU = 0.0f;
            float averageV = 0.0f;
            if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                for (int i = 0; i < face.textureCoordinates.length; ++i) {
                    averageU += face.textureCoordinates[i].u;
                    averageV += face.textureCoordinates[i].v;
                }
                averageU /= (float)face.textureCoordinates.length;
                averageV /= (float)face.textureCoordinates.length;
            }
            for (int i = 0; i < face.vertices.length; ++i) {
                if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                    float offsetU = textureOffset;
                    float offsetV = textureOffset;
                    if (face.textureCoordinates[i].u > averageU) {
                        offsetU = -offsetU;
                    }
                    if (face.textureCoordinates[i].v > averageV) {
                        offsetV = -offsetV;
                    }
                    pos.x = face.vertices[i].x;
                    pos.y = face.vertices[i].y;
                    pos.z = face.vertices[i].z;
                    pos.w = 1.0f;
                    Matrix4f.transform((Matrix4f)mat, (Vector4f)pos, (Vector4f)pos);
                    Tessellator.field_78398_a.func_78375_b(face.faceNormal.x, face.faceNormal.y, face.faceNormal.z);
                    float colorMul = 1.0f;
                    if (lighting) {
                        colorMul = 0.7f + 0.3f * Vector3f.dot((Vector3f)new Vector3f(face.faceNormal.x, face.faceNormal.y, face.faceNormal.z), (Vector3f)new Vector3f(-0.3f, 1.0f, 0.0f));
                    }
                    if (color != null) {
                        Tessellator.field_78398_a.func_78369_a(color.getFloatR() + colorMul, color.getFloatG() + colorMul, color.getFloatB() + colorMul, color.getFloatA());
                    } else {
                        Tessellator.field_78398_a.func_78369_a(colorMul, colorMul, colorMul, 1.0f);
                    }
                    if (brightness >= 0) {
                        Tessellator.field_78398_a.func_78380_c(brightness);
                    }
                    Tessellator.field_78398_a.func_78374_a((double)((float)x + 0.5f + pos.x), (double)((float)y + pos.y), (double)((float)z + 0.5f + pos.z), (double)(icon.func_94209_e() + face.textureCoordinates[i].u * uSize + offsetU), (double)(icon.func_94206_g() + face.textureCoordinates[i].v * vSize + offsetV));
                    continue;
                }
                Tessellator.field_78398_a.func_78377_a((double)((float)x + face.vertices[i].x), (double)((float)y + face.vertices[i].y), (double)((float)z + face.vertices[i].z));
            }
        }
    }

    public static int lerp(int a, int b, float lerp) {
        int MASK1 = 0xFF00FF;
        int MASK2 = 65280;
        int f2 = Math.round(256.0f * lerp);
        int f1 = Math.round(256 - f2);
        return (a & MASK1) * f1 + (b & MASK1) * f2 >> 8 & MASK1 | (a & MASK2) * f1 + (b & MASK2) * f2 >> 8 & MASK2;
    }

    public static GuiColor lerp(GuiColor a, GuiColor b, float lerp) {
        return new GuiColor(RenderUtils.lerp(a.getIntR(), b.getIntR(), lerp), RenderUtils.lerp(a.getIntG(), b.getIntG(), lerp), RenderUtils.lerp(a.getIntB(), b.getIntB(), lerp), RenderUtils.lerp(a.getIntA(), b.getIntA(), lerp));
    }

    public static void applyColor(int color) {
        GL11.glColor4f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color >> 0 & 0xFF) / 256.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
    }

    public static void applyColor(GuiColor color) {
        GL11.glColor3f((float)color.getFloatR(), (float)color.getFloatG(), (float)color.getFloatB());
    }

    public static void applyColorWithMultipy(GuiColor color, float mul) {
        GL11.glColor3f((float)(color.getFloatR() * mul), (float)(color.getFloatG() * mul), (float)(color.getFloatB() * mul));
    }

    public static void applyColorWithAdd(GuiColor color, float add) {
        GL11.glColor3f((float)(color.getFloatR() + add), (float)(color.getFloatG() + add), (float)(color.getFloatB() + add));
    }

    public static void applyColorWithAlpha(GuiColor color, float alphaMultiply) {
        GL11.glColor4f((float)color.getFloatR(), (float)color.getFloatG(), (float)color.getFloatB(), (float)(color.getFloatA() * alphaMultiply));
    }

    public static void applyColorWithAlpha(GuiColor color) {
        GL11.glColor4f((float)color.getFloatR(), (float)color.getFloatG(), (float)color.getFloatB(), (float)color.getFloatA());
    }

    public static void beginDrawinngBlockScreen(double x, double y, double z, ForgeDirection side, GuiColor color, TileEntity entity) {
        RenderUtils.beginDrawinngBlockScreen(x, y, z, side, color, entity, 0.05, 1.0f);
    }

    public static void beginDrawinngBlockScreen(double x, double y, double z, ForgeDirection side, GuiColor color, TileEntity entity, double offset, float glowAlpha) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        RenderUtils.disableLightmap();
        Vector3f dir = new Vector3f((float)side.offsetX, (float)side.offsetY, (float)side.offsetZ);
        Vector3f front = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f c = Vector3f.cross((Vector3f)front, (Vector3f)dir, null);
        double omega = Math.acos(Vector3f.dot((Vector3f)front, (Vector3f)dir));
        if (omega == Math.PI) {
            c.y = 1.0f;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)dir.x * (0.5 + offset)), (double)((double)dir.y * (0.5 + offset)), (double)((double)dir.z * (0.5 + offset)));
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glRotated((double)(omega * 57.29577951308232), (double)c.x, (double)c.y, (double)c.z);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)0.0);
        GL11.glBlendFunc((int)1, (int)769);
        double multiply = (MOMathHelper.noise(entity.field_145851_c, (double)entity.func_145831_w().func_72820_D() * 0.01, entity.field_145849_e) * 0.5 + 0.5) * (double)glowAlpha;
        GL11.glColor3d((double)((double)color.getFloatR() * multiply), (double)((double)color.getFloatG() * multiply), (double)((double)color.getFloatB() * multiply));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TileEntityRendererPatternMonitor.screenTextureGlow);
        RenderUtils.drawPlane(1.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.05);
        GL11.glColor3d((double)(color.getFloatR() * 0.05f), (double)(color.getFloatG() * 0.05f), (double)(color.getFloatB() * 0.05f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TileEntityRendererPatternMonitor.screenTextureBack);
        RenderUtils.drawPlane(1.0);
    }

    public static void drawScreenInfoWithGlobalAutoSize(String[] info, GuiColor color, ForgeDirection side, int leftMargin, int rightMargin, float maxScaleFactor) {
        int i;
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.03);
        GL11.glScaled((double)0.01, (double)0.01, (double)0.01);
        int height = 0;
        int maxWidth = 0;
        int sizeX = 100 - leftMargin - rightMargin;
        int sizeY = 80;
        float scaleFactor = 1.0f;
        for (i = 0; i < info.length; ++i) {
            if (maxWidth >= fontRenderer.func_78256_a(info[i])) continue;
            maxWidth = fontRenderer.func_78256_a(info[i]);
        }
        if (maxWidth > 0) {
            scaleFactor = MathHelper.func_76131_a((float)((float)sizeX / (float)maxWidth), (float)0.02f, (float)maxScaleFactor);
        }
        for (i = 0; i < info.length; ++i) {
            int scaledHeight = (int)((float)RenderUtils.fontRenderer.field_78288_b * scaleFactor);
            if (height + scaledHeight >= sizeY) continue;
            height += scaledHeight;
        }
        height = MathHelper.func_76125_a((int)height, (int)0, (int)sizeY);
        int yCount = 0;
        for (int i2 = 0; i2 < info.length; ++i2) {
            GL11.glPushMatrix();
            int scaledHeight = (int)((float)RenderUtils.fontRenderer.field_78288_b * scaleFactor);
            if (yCount + scaledHeight >= sizeY) {
                GL11.glPopMatrix();
                break;
            }
            int width = fontRenderer.func_78256_a(info[i2]);
            GL11.glTranslated((double)(leftMargin + sizeX / 2), (double)(50 + yCount + scaledHeight / 2 - height / 2), (double)0.0);
            GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)0.0);
            fontRenderer.func_78276_b(info[i2], -width / 2, -RenderUtils.fontRenderer.field_78288_b / 2, color.getColor());
            GL11.glPopMatrix();
            yCount += scaledHeight;
        }
        GL11.glPopMatrix();
    }

    public static void drawScreenInfoWithLocalAutoSize(String[] info, GuiColor color, ForgeDirection side, int leftMargin, int rightMargin, float maxScaleFactor) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.03);
        GL11.glScaled((double)0.01, (double)0.01, (double)0.01);
        int height = 0;
        int maxWidth = 0;
        int sizeX = 100 - leftMargin - rightMargin;
        int sizeY = 80;
        for (int i = 0; i < info.length; ++i) {
            float scaleFactor = 1.0f;
            int width = fontRenderer.func_78256_a(info[i]);
            if (width > 0) {
                scaleFactor = MathHelper.func_76131_a((float)((float)sizeX / (float)width), (float)0.02f, (float)maxScaleFactor);
            }
            int scaledHeight = (int)((float)RenderUtils.fontRenderer.field_78288_b * scaleFactor);
            if (maxWidth < fontRenderer.func_78256_a(info[i])) {
                maxWidth = fontRenderer.func_78256_a(info[i]);
            }
            if (height + scaledHeight >= sizeY) continue;
            height += scaledHeight;
        }
        height = MathHelper.func_76125_a((int)height, (int)0, (int)sizeY);
        int yCount = 0;
        for (int i = 0; i < info.length; ++i) {
            int scaledHeight;
            GL11.glPushMatrix();
            float scaleFactor = 1.0f;
            int width = fontRenderer.func_78256_a(info[i]);
            if (width > 0) {
                scaleFactor = MathHelper.func_76131_a((float)((float)sizeX / (float)width), (float)0.02f, (float)maxScaleFactor);
            }
            if (yCount + (scaledHeight = (int)((float)RenderUtils.fontRenderer.field_78288_b * scaleFactor)) >= sizeY) {
                GL11.glPopMatrix();
                break;
            }
            GL11.glTranslated((double)(leftMargin + sizeX / 2), (double)(50 + yCount + scaledHeight / 2 - height / 2), (double)0.0);
            GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)0.0);
            fontRenderer.func_78276_b(info[i], -width / 2, -RenderUtils.fontRenderer.field_78288_b / 2, color.getColor());
            GL11.glPopMatrix();
            yCount += scaledHeight;
        }
        GL11.glPopMatrix();
    }

    public static void endDrawinngBlockScreen() {
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
    }

    public static void disableLightmap() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void DrawMultilineInfo(List infos, int x, int y, int maxLines, int maxLineWidth, int color) {
        try {
            int linesCounter = 0;
            String infoText = StringUtils.join((Iterable)infos, (String)"\n");
            fontRenderer.func_78279_b(infoText, x, y + linesCounter * 10, maxLineWidth, color);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void DrawMultilineInfoCentered(List infos, int x, int y, int maxLines, int maxLineWidth, int color) {
        try {
            for (int i = 0; i < Math.min(maxLines, infos.size()); ++i) {
                String info = infos.get(i).toString();
                info = info.substring(0, Math.min(maxLineWidth, info.length()));
                int width = fontRenderer.func_78256_a(info);
                fontRenderer.func_78261_a(info, x - width / 2, y + i * 10, color);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void translateToWorldCoords(Entity entity, float frame) {
        double interpPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double interpPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double interpPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void rotateTo(Entity viewer) {
        GL11.glRotated((double)viewer.field_70177_z, (double)0.0, (double)-1.0, (double)0.0);
        GL11.glRotated((double)viewer.field_70125_A, (double)1.0, (double)0.0, (double)0.0);
    }

    public static void tessalateParticle(EntityLivingBase viewer, IIcon particleIcon, double scale, Vec3 position, GuiColor color) {
        RenderUtils.tessalateParticle(viewer, particleIcon, scale, position, color.getFloatR(), color.getFloatG(), color.getFloatB(), color.getFloatA());
    }

    public static void tessalateParticle(EntityLivingBase viewer, IIcon particleIcon, double scale, Vec3 position, float r, float g, float b, float a) {
        float f1 = MathHelper.func_76134_b((float)(viewer.field_70177_z * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76126_a((float)(viewer.field_70177_z * ((float)Math.PI / 180)));
        float f3 = -f2 * MathHelper.func_76126_a((float)(viewer.field_70125_A * ((float)Math.PI / 180)));
        float f4 = f1 * MathHelper.func_76126_a((float)(viewer.field_70125_A * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76134_b((float)(viewer.field_70125_A * ((float)Math.PI / 180)));
        float uMin = particleIcon.func_94209_e();
        float uMax = particleIcon.func_94212_f();
        float vMin = particleIcon.func_94206_g();
        float vMax = particleIcon.func_94210_h();
        float x = (float)position.field_72450_a;
        float y = (float)position.field_72448_b;
        float z = (float)position.field_72449_c;
        Tessellator.field_78398_a.func_78369_a(r, g, b, a);
        Tessellator.field_78398_a.func_78374_a((double)x - (double)f1 * scale - (double)f3 * scale, (double)y - (double)f5 * scale, (double)z - (double)f2 * scale - (double)f4 * scale, (double)uMax, (double)vMax);
        Tessellator.field_78398_a.func_78374_a((double)x - (double)f1 * scale + (double)f3 * scale, (double)y + (double)f5 * scale, (double)z - (double)f2 * scale + (double)f4 * scale, (double)uMax, (double)vMin);
        Tessellator.field_78398_a.func_78374_a((double)x + (double)f1 * scale + (double)f3 * scale, (double)y + (double)f5 * scale, (double)z + (double)f2 * scale + (double)f4 * scale, (double)uMin, (double)vMin);
        Tessellator.field_78398_a.func_78374_a((double)x + (double)f1 * scale - (double)f3 * scale, (double)y - (double)f5 * scale, (double)z + (double)f2 * scale - (double)f4 * scale, (double)uMin, (double)vMax);
    }

    public static void enable3DRender() {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)2884);
    }

    public static void enable2DRender() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)2884);
    }

    public static void drawSizedTexturedModalRect(int x, int y, int u, int v, int width, int height, int widthU, int heightV, float texW, float texH, float zLevel) {
        Tessellator.field_78398_a.func_78382_b();
        RenderUtils.tessalateSizedModelRect(x, y, u, v, width, height, widthU, heightV, texW, texH, zLevel);
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void tessalateSizedModelRect(int x, int y, int u, int v, int width, int height, int widthU, int heightV, float texW, float texH, float zLevel) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        Tessellator.field_78398_a.func_78374_a((double)x, (double)(y + height), (double)zLevel, (double)((float)u * texU), (double)((float)(v + heightV) * texV));
        Tessellator.field_78398_a.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((float)(u + widthU) * texU), (double)((float)(v + heightV) * texV));
        Tessellator.field_78398_a.func_78374_a((double)(x + width), (double)y, (double)zLevel, (double)((float)(u + widthU) * texU), (double)((float)v * texV));
        Tessellator.field_78398_a.func_78374_a((double)x, (double)y, (double)zLevel, (double)((float)u * texU), (double)((float)v * texV));
    }

    public static void drawString(String string, int x, int y, GuiColor color, float multiply) {
        RenderUtils.drawString(Minecraft.func_71410_x().field_71466_p, string, x, y, color, multiply);
    }

    public static void drawString(FontRenderer fontRenderer, String string, int x, int y, GuiColor color, float multiply) {
        fontRenderer.func_78276_b(string, x, y, new GuiColor((int)((float)color.getIntR() * multiply), (int)((float)color.getIntG() * multiply), (int)((float)color.getIntB() * multiply)).getColor());
    }

    public static void beginStencil() {
        GL11.glEnable((int)2960);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glStencilMask((int)255);
        GL11.glClear((int)1024);
    }

    public static void endStencil() {
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        GL11.glStencilMask((int)0);
        GL11.glDepthMask((boolean)true);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDisable((int)2960);
    }

    public static void drawSizeableBackground(int left, int top, int width, int height, int texW, int texH, ResourceLocation texture, float zLevel, int chunkSize) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        RenderUtils.drawSizedTexturedModalRect(left, top, 0, 0, chunkSize, chunkSize, chunkSize, chunkSize, 255.0f, 255.0f, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left + chunkSize, top, chunkSize, 0, width - chunkSize * 2, chunkSize, texW - chunkSize * 2, chunkSize, 255.0f, 255.0f, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left + width - chunkSize, top, texW - chunkSize, 0, chunkSize, chunkSize, chunkSize, chunkSize, 255.0f, 255.0f, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left, top + chunkSize, 0, chunkSize, chunkSize, height - chunkSize * 2, chunkSize, texH - chunkSize * 2, 255.0f, 255.0f, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left + width - chunkSize, top + chunkSize, texW - chunkSize, chunkSize, chunkSize, height - chunkSize * 2, chunkSize, texH - chunkSize * 2, 255.0f, 255.0f, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left, top + height - chunkSize, 0, texH - chunkSize, chunkSize, chunkSize, chunkSize, chunkSize, 255.0f, 255.0f, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left + width - chunkSize, top + height - chunkSize, texW - chunkSize, texH - chunkSize, chunkSize, chunkSize, chunkSize, chunkSize, 255.0f, 255.0f, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left + chunkSize, top + height - chunkSize, chunkSize, texH - chunkSize, width - chunkSize * 2, chunkSize, texW - chunkSize * 2, chunkSize, 255.0f, 255.0f, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left + chunkSize, top + chunkSize, chunkSize, chunkSize, width - chunkSize * 2, height - chunkSize * 2, texW - chunkSize * 2, texH - chunkSize * 2, 255.0f, 255.0f, zLevel);
    }

    public static void drawSizeableVertical(int left, int top, int u, int v, int width, int height, int texW, int texH, ResourceLocation texture, float zLevel, int chunkSize) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        RenderUtils.drawSizedTexturedModalRect(left, top, u + 0, v + 0, width, v + chunkSize, width, chunkSize, texW, texH, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left, top + chunkSize, u + 0, chunkSize, width, height - chunkSize * 2, width, texH - chunkSize * 2, texW, texH, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left, top + height - chunkSize, u + 0, v + texH - chunkSize, width, chunkSize, width, chunkSize, texW, texH, zLevel);
    }

    public static void drawSizeableHorizontal(int left, int top, int u, int v, int width, int height, int texW, int texH, ResourceLocation texture, float zLevel, int chunkSize) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        RenderUtils.drawSizedTexturedModalRect(left, top, u, v, chunkSize, height, chunkSize, height, texW, texH, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left + chunkSize, top, u + chunkSize, v, width - chunkSize * 2, height, texW - chunkSize * 2, height, texW, texH, zLevel);
        RenderUtils.drawSizedTexturedModalRect(left + width - chunkSize, top, u + texW - chunkSize, v, chunkSize, height, chunkSize, height, texW, texH, zLevel);
    }

    public static void drawShip(double x, double y, double z, double size) {
        Tessellator.field_78398_a.func_78371_b(4);
        Tessellator.field_78398_a.func_78377_a(x - size, y, z);
        Tessellator.field_78398_a.func_78377_a(x + size, y, z - size);
        Tessellator.field_78398_a.func_78377_a(x + size, y, z + size);
        Tessellator.field_78398_a.func_78377_a(x - size, y, z);
        Tessellator.field_78398_a.func_78377_a(x + size, y, z + size);
        Tessellator.field_78398_a.func_78377_a(x + size, y + size, z);
        Tessellator.field_78398_a.func_78377_a(x - size, y, z);
        Tessellator.field_78398_a.func_78377_a(x + size, y + size, z);
        Tessellator.field_78398_a.func_78377_a(x + size, y, z - size);
        Tessellator.field_78398_a.func_78377_a(x + size, y, z - size);
        Tessellator.field_78398_a.func_78377_a(x + size, y + size, z);
        Tessellator.field_78398_a.func_78377_a(x + size, y, z + size);
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void rotateTowards(Vec3 from, Vec3 to, Vec3 up) {
        double dot = from.func_72430_b(to);
        if (Math.abs(dot - -1.0) < Double.MIN_VALUE) {
            GL11.glRotated((double)180.0, (double)up.field_72450_a, (double)up.field_72448_b, (double)up.field_72449_c);
        }
        if (Math.abs(dot - 1.0) < Double.MIN_VALUE) {
            return;
        }
        double rotAngle = Math.acos(dot);
        Vec3 rotAxis = from.func_72431_c(to).func_72432_b();
        GL11.glRotated((double)(rotAngle * 57.29577951308232), (double)rotAxis.field_72450_a, (double)rotAxis.field_72448_b, (double)rotAxis.field_72449_c);
    }
}

