/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.IUpgrade;
import matteroverdrive.api.matter.IMatterItem;
import matteroverdrive.api.matter.IMatterPatternStorage;
import matteroverdrive.api.matter.IMatterProvider;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.handler.MatterEntry;
import matteroverdrive.init.MatterOverdriveFluids;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class MatterHelper {
    public static final String MATTER_UNIT = " kM";

    public static boolean containsMatter(ItemStack item) {
        return MatterHelper.getMatterAmountFromItem(item) > 0;
    }

    public static int getMatterAmountFromItem(ItemStack item) {
        if (item != null) {
            if (item.func_77973_b() instanceof IMatterItem) {
                return ((IMatterItem)item.func_77973_b()).getMatter(item);
            }
            MatterEntry matter = MatterOverdrive.matterRegistry.getEntry(item);
            if (matter != null) {
                return matter.getMatter();
            }
        }
        return 0;
    }

    public static int getEnergyFromMatter(int multiply, ItemStack itemStack) {
        int matter = MatterHelper.getMatterAmountFromItem(itemStack);
        return multiply * matter;
    }

    public static int getTotalEnergyFromMatter(int multiply, ItemStack itemStack, int time) {
        int matter = MatterHelper.getMatterAmountFromItem(itemStack);
        return multiply * matter * time;
    }

    public static int Transfer(ForgeDirection toDir, int amount, IMatterProvider from, IFluidHandler to) {
        ForgeDirection oposite = toDir.getOpposite();
        int extract = from.extractMatter(toDir, amount, true);
        int recived = to.fill(oposite, new FluidStack((Fluid)MatterOverdriveFluids.matterPlasma, extract), true);
        from.extractMatter(toDir, recived, false);
        return recived;
    }

    public static ForgeDirection opposite(ForgeDirection dir) {
        return ForgeDirection.values()[ForgeDirection.OPPOSITES[dir.ordinal()]];
    }

    private static IRecipe GetRecipeOf(ItemStack item) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (int i = 0; i < recipes.size(); ++i) {
            IRecipe recipe = (IRecipe)recipes.get(i);
            if (recipe == null || recipe.func_77571_b() == null || recipe.func_77571_b().func_77973_b() != item.func_77973_b()) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isWeaponModule(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b() instanceof IWeaponModule;
    }

    public static boolean isWeapon(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b() instanceof IWeapon;
    }

    public static boolean isMatterScanner(ItemStack item) {
        return item != null && item.func_77973_b() != null && item.func_77973_b() instanceof MatterScanner;
    }

    public static boolean isMatterPatternStorage(ItemStack item) {
        return item != null && item.func_77973_b() != null && item.func_77973_b() instanceof IMatterPatternStorage;
    }

    public static boolean isUpgrade(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof IUpgrade;
    }

    public static boolean CanScan(ItemStack stack) {
        Block block;
        if (MatterHelper.getMatterAmountFromItem(stack) <= 0) {
            return false;
        }
        Item item = stack.func_77973_b();
        return !(item instanceof ItemBlock) || (block = Block.func_149634_a((Item)item)) != Blocks.field_150357_h && block != Blocks.field_150350_a;
    }

    public static String formatMatter(int matter) {
        return MOStringHelper.formatNUmber(matter) + MATTER_UNIT;
    }

    public static String formatMatter(int matter, int capacity) {
        return MOStringHelper.formatNUmber(matter) + " / " + MOStringHelper.formatNUmber(capacity) + MATTER_UNIT;
    }

    public static boolean DropInventory(World world, IInventory inventory, int x, int y, int z) {
        if (inventory != null) {
            for (int i1 = 0; i1 < inventory.func_70302_i_(); ++i1) {
                ItemStack itemstack = inventory.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = world.field_73012_v.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            return true;
        }
        return false;
    }

    public static void DrawMatterInfoTooltip(ItemStack itemStack, int speed, int energyPerTick, List tooltips) {
        int matter = MatterHelper.getMatterAmountFromItem(itemStack);
        if (matter > 0) {
            tooltips.add(EnumChatFormatting.ITALIC.toString() + EnumChatFormatting.BLUE.toString() + "Matter: " + MatterHelper.formatMatter(matter));
            tooltips.add(EnumChatFormatting.ITALIC.toString() + EnumChatFormatting.DARK_RED + "Power: " + MOEnergyHelper.formatEnergy(speed * matter * energyPerTick));
        }
    }
}

