/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile.pipes;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import matteroverdrive.api.network.IMatterNetworkCable;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.packets.MatterNetworkTaskPacket;
import matteroverdrive.tile.pipes.TileEntityPipe;
import matteroverdrive.util.MatterNetworkHelper;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityNetworkPipe
extends TileEntityPipe
implements IMatterNetworkCable,
IMatterNetworkConnection {
    @Override
    public boolean canConnectTo(TileEntity entity, ForgeDirection direction) {
        if (entity instanceof IMatterNetworkConnection) {
            if (entity instanceof TileEntityNetworkPipe) {
                TileEntityNetworkPipe networkPipe = (TileEntityNetworkPipe)entity;
                int pipeConnections = networkPipe.getConnections();
                if (MOMathHelper.getBoolean(pipeConnections, direction.ordinal())) {
                    return true;
                }
                int pipeConnectionsCount = 0;
                for (int i = 0; i < 6; ++i) {
                    pipeConnectionsCount += pipeConnections >> i & 1;
                }
                return pipeConnectionsCount < 2;
            }
            return ((IMatterNetworkConnection)entity).canConnectFromSide(direction);
        }
        return false;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void broadcast(MatterNetworkPacket task, ForgeDirection direction) {
        if (this.isValid()) {
            if (task == null) {
                System.out.println("Task is null");
            }
            if (task instanceof MatterNetworkTaskPacket && ((MatterNetworkTaskPacket)task).getTask(this.field_145850_b).getState().above(MatterNetworkTaskState.WAITING)) {
                return;
            }
            for (int i = 0; i < 6; ++i) {
                if (direction.getOpposite().ordinal() == i) continue;
                MatterNetworkHelper.broadcastPacketInDirection(this.field_145850_b, task, this, ForgeDirection.getOrientation((int)i));
            }
        }
    }

    @Override
    public BlockPosition getPosition() {
        return new BlockPosition((TileEntity)this);
    }

    @Override
    public boolean canConnectFromSide(ForgeDirection side) {
        return MOMathHelper.getBoolean(this.getConnections(), side.ordinal());
    }

    @Override
    public void updateSides(boolean notify) {
        int connections = 0;
        int connectionCount = 0;
        for (int i = 0; i < 6; ++i) {
            TileEntity t = this.field_145850_b.func_147438_o(ForgeDirection.values()[i].offsetX + this.field_145851_c, ForgeDirection.values()[i].offsetY + this.field_145848_d, ForgeDirection.values()[i].offsetZ + this.field_145849_e);
            if (connectionCount >= 2 || !this.canConnectTo(t, ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[i]))) continue;
            connections |= ForgeDirection.values()[i].flag;
            ++connectionCount;
        }
        this.setConnections(connections, notify);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
    }

    @Override
    protected void onAwake(Side side) {
    }
}

