/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cofh.lib.util.TimeTracker;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import matteroverdrive.api.IGravityEntity;
import matteroverdrive.api.IScannable;
import matteroverdrive.client.sound.GravitationalAnomalySound;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.fx.GravitationalAnomalyParticle;
import matteroverdrive.init.MatterOverdriveBioticStats;
import matteroverdrive.items.SpacetimeEqualizer;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.tile.IMOTickable;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.logging.log4j.Level;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityGravitationalAnomaly
extends MOTileEntity
implements IScannable,
IMOTickable {
    public static boolean FALLING_BLOCKS = true;
    public static boolean BLOCK_ENTETIES = true;
    public static boolean VANILLA_FLUIDS = true;
    public static boolean FORGE_FLUIDS = true;
    public static boolean BLOCK_DESTRUCTION = true;
    public static boolean GRAVITATION = true;
    public static final float MAX_VOLUME = 0.5f;
    public static final int BLOCK_DESTORY_DELAY = 6;
    public static final int MAX_BLOCKS_PER_HARVEST = 6;
    public static final int MAX_LIQUIDS_PER_HARVEST = 32;
    public static final double STREHGTH_MULTIPLYER = 1.0E-5;
    public static final double G = 6.67384;
    public static final double G2 = 13.34768;
    public static final double C = 2.99792458;
    public static final double CC = 8.987551787368176;
    public static final int ENTITY_DAMAGE = 6;
    @SideOnly(value=Side.CLIENT)
    private GravitationalAnomalySound sound;
    private TimeTracker blockDestoryTimer = new TimeTracker();
    private long mass = 2048 + MathHelper.round((double)(Math.random() * 8192.0));
    @SideOnly(value=Side.CLIENT)
    public int consumedCount;
    PriorityQueue<PositionWrapper> blocks;
    private float tmpSuppression;
    private float suppression;

    public TileEntityGravitationalAnomaly() {
    }

    public TileEntityGravitationalAnomaly(int mass) {
        this();
        this.mass = mass;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74772_a("Mass", this.mass);
            nbt.func_74776_a("Suppression", this.suppression);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.mass = nbt.func_74763_f("Mass");
            this.suppression = nbt.func_74760_g("Suppression");
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeCustomNBT(syncData, MachineNBTCategory.ALL_OPTS);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound syncData = pkt.func_148857_g();
        if (syncData != null) {
            this.readCustomNBT(syncData, MachineNBTCategory.ALL_OPTS);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles(this.field_145850_b);
            this.manageSound();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.stopSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world) {
        double radius = (float)this.getBlockBreakRange();
        Vector3f point = MOMathHelper.randomSpherePoint((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, Vec3.func_72443_a((double)radius, (double)radius, (double)radius), world.field_73012_v);
        GravitationalAnomalyParticle particle = new GravitationalAnomalyParticle(world, point.x, point.y, point.z, Vec3.func_72443_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f)));
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
    }

    public void manageEntityGravitation(World world, float ticks) {
        if (!GRAVITATION) {
            return;
        }
        if (world.field_72995_K) {
            this.consumedCount = 0;
        }
        double range = this.getMaxRange() + 1.0;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
        List entities = world.func_72872_a(Entity.class, bb);
        for (Object entityObject : entities) {
            ItemStack eq;
            double eventHorizon;
            Entity entity;
            if (entityObject instanceof EntityPlayer) {
                AndroidPlayer androidPlayer = AndroidPlayer.get((EntityPlayer)entityObject);
                if (((EntityPlayer)entityObject).field_71075_bZ.field_75098_d || androidPlayer.isUnlocked(MatterOverdriveBioticStats.equalizer, 1)) continue;
            }
            if (!(entityObject instanceof Entity) || (entity = (Entity)entityObject) instanceof IGravityEntity && !((IGravityEntity)entity).isAffectedByAnomaly()) continue;
            Vec3 pos = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
            pos.field_72448_b += (double)entity.func_70047_e();
            Vec3 blockPos = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
            Vec3 dir = pos.func_72444_a(blockPos).func_72432_b();
            double distance = pos.func_72438_d(blockPos);
            if (distance < (eventHorizon = this.getEventHorizon())) {
                if (!world.field_72995_K) {
                    this.consume(entity);
                    continue;
                }
                ++this.consumedCount;
                continue;
            }
            if (entityObject instanceof EntityLivingBase && (eq = ((EntityLivingBase)entityObject).func_71124_b(3)) != null && eq.func_77973_b() instanceof SpacetimeEqualizer) continue;
            double acceleration = this.getAcceleration(distance);
            entity.func_70024_g(dir.field_72450_a * acceleration, dir.field_72448_b * acceleration, dir.field_72449_c * acceleration);
            entity.field_70133_I = true;
        }
    }

    public void onChunkUnload() {
        if (this.field_145850_b.field_72995_K) {
            this.stopSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void stopSounds() {
        if (this.sound != null) {
            this.sound.stopPlaying();
            FMLClientHandler.instance().getClient().func_147118_V().func_147683_b((ISound)this.sound);
            this.sound = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playSounds() {
        if (this.sound == null) {
            this.sound = new GravitationalAnomalySound(new ResourceLocation("mo:windy"), this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.2f, this.getMaxRange());
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
        } else if (!FMLClientHandler.instance().getClient().func_147118_V().func_147692_c((ISound)this.sound)) {
            this.stopSounds();
            this.sound = new GravitationalAnomalySound(new ResourceLocation("mo:windy"), this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.2f, this.getMaxRange());
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void manageSound() {
        if (this.sound == null) {
            this.playSounds();
        } else {
            this.sound.setVolume(Math.min(0.5f, this.getBreakStrength() * 0.1f));
            this.sound.setRange(this.getMaxRange());
        }
    }

    @Override
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (this.field_145850_b == null) {
            return;
        }
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            this.manageEntityGravitation(this.field_145850_b, 0.0f);
            this.manageBlockDestory(this.field_145850_b);
            if (this.tmpSuppression != this.suppression) {
                this.suppression = this.tmpSuppression;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.tmpSuppression = 1.0f;
        }
    }

    @Override
    public int getPhase() {
        return 1;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public void onNeighborBlockChange() {
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
    }

    public void manageBlockDestory(World world) {
        Block block;
        if (!BLOCK_DESTRUCTION) {
            return;
        }
        Vec3 pos = Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        int solidCount = 0;
        int liquidCount = 0;
        int range = MathHelper.floor((double)this.getBlockBreakRange());
        double eventHorizon = this.getEventHorizon();
        float strength = this.getBreakStrength();
        this.blocks = new PriorityQueue<PositionWrapper>(1, new BlockComparitor(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        if (this.blockDestoryTimer.hasDelayPassed(world, 6)) {
            for (int x = -range; x < range; ++x) {
                for (int y = -range; y < range; ++y) {
                    for (int z = -range; z < range; ++z) {
                        int blockPosX = this.field_145851_c + x;
                        int blockPosY = this.field_145848_d + y;
                        int blockPosZ = this.field_145849_e + z;
                        block = this.getBlock(world, blockPosX, blockPosY, blockPosZ);
                        double distance = MOMathHelper.distance(blockPosX, blockPosY, blockPosZ, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        float hardness = block.func_149712_f(world, blockPosX, blockPosY, blockPosZ);
                        if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
                            hardness = 1.0f;
                        }
                        if (block == null || block == Blocks.field_150350_a || !(distance <= (double)range) || !(hardness >= 0.0f) || !(distance < eventHorizon) && !(hardness < strength)) continue;
                        this.blocks.add(new PositionWrapper(blockPosX, blockPosY, blockPosZ));
                    }
                }
            }
        }
        for (PositionWrapper position : this.blocks) {
            block = world.func_147439_a(position.x, position.y, position.z);
            if (this.cleanFlowingLiquids(block, position.x, position.y, position.z)) continue;
            if (liquidCount < 32 && this.cleanLiquids(block, position.x, position.y, position.z)) {
                ++liquidCount;
                continue;
            }
            if (solidCount >= 6) continue;
            try {
                if (!this.brakeBlock(world, position.x, position.y, position.z, strength, eventHorizon, range)) continue;
                ++solidCount;
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "There was a problem while trying to brake block %s", block);
            }
        }
    }

    public Block getBlock(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z);
    }

    public double getEventHorizon() {
        return 13.34768 * this.getRealMass() / 8.987551787368176;
    }

    public double getBlockBreakRange() {
        return this.getMaxRange() / 2.0;
    }

    public double getMaxRange() {
        return Math.sqrt(6.67384 * this.getRealMass() / 0.005);
    }

    public double getAcceleration(double range) {
        return this.getRealMass() / range;
    }

    public double getRealMass() {
        return this.getRealMassUnsuppressed() * (double)this.suppression;
    }

    public double getRealMassUnsuppressed() {
        return Math.log1p((double)this.mass * 1.0E-5);
    }

    public float getBreakStrength() {
        return (float)this.getRealMass() * 4.0f * this.suppression;
    }

    public void consume(Entity entity) {
        int matter = 1;
        if (!entity.field_70128_L) {
            if (entity instanceof EntityItem) {
                ItemStack itemStack = ((EntityItem)entity).func_92059_d();
                if (itemStack != null) {
                    matter = MatterHelper.getMatterAmountFromItem(itemStack) * itemStack.field_77994_a;
                }
                entity.func_70106_y();
                this.field_145850_b.func_72900_e(entity);
            } else if (entity instanceof EntityFallingBlock) {
                ItemStack itemStack = new ItemStack(((EntityFallingBlock)entity).func_145805_f());
                matter = MatterHelper.getMatterAmountFromItem(itemStack) * itemStack.field_77994_a;
                entity.func_70106_y();
                this.field_145850_b.func_72900_e(entity);
            } else if (entity instanceof EntityPlayer) {
                matter = (int)((float)matter + Math.min(((EntityLivingBase)entity).func_110143_aJ(), this.getBreakStrength()));
                DamageSource damageSource = new DamageSource("blackHole");
                entity.func_70097_a(damageSource, this.getBreakStrength());
            } else if (entity instanceof EntityLivingBase) {
                matter = (int)((float)matter + Math.min(((EntityLivingBase)entity).func_110143_aJ(), this.getBreakStrength()));
                if (((EntityLivingBase)entity).func_110143_aJ() <= this.getBreakStrength()) {
                    entity.func_70106_y();
                    this.field_145850_b.func_72900_e(entity);
                }
                DamageSource damageSource = new DamageSource("blackHole");
                entity.func_70097_a(damageSource, this.getBreakStrength());
            }
            this.mass += (long)matter;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Math.pow(this.getMaxRange(), 3.0);
    }

    public boolean brakeBlock(World world, int x, int y, int z, float strength, double eventHorizon, int range) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return true;
        }
        float hardness = block.func_149712_f(this.field_145850_b, x, y, z);
        double distance = MOMathHelper.distance(x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (distance <= (double)range && hardness >= 0.0f && (distance < eventHorizon || hardness < strength)) {
            int meta = this.field_145850_b.func_72805_g(x, y, z);
            if (BLOCK_ENTETIES) {
                if (FALLING_BLOCKS) {
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block, world.func_72805_g(x, y, z));
                    fallingBlock.field_145812_b = 1;
                    fallingBlock.field_70145_X = true;
                    world.func_72838_d((Entity)fallingBlock);
                } else {
                    ItemStack bStack = this.createStackedBlock(block, meta);
                    if (bStack != null) {
                        EntityItem item = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, bStack);
                        world.func_72838_d((Entity)item);
                    }
                }
                block.func_149749_a(world, x, y, z, block, 0);
                this.field_145850_b.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
                world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 10);
                return true;
            }
            int matter = 0;
            if (block.canSilkHarvest(this.field_145850_b, null, x, y, z, meta)) {
                matter += MatterHelper.getMatterAmountFromItem(this.createStackedBlock(block, meta));
            } else {
                for (ItemStack stack : block.getDrops(this.field_145850_b, x, y, z, meta, 0)) {
                    matter += MatterHelper.getMatterAmountFromItem(stack);
                }
            }
            this.field_145850_b.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            List result = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - 2), (double)(y - 2), (double)(z - 2), (double)(x + 3), (double)(y + 3), (double)(z + 3)));
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                EntityItem entityItem;
                EntityItem entity = entityItem = (EntityItem)iterator.next();
                if (entity.field_70128_L || entity.func_92059_d().field_77994_a <= 0) continue;
                matter += MatterHelper.getMatterAmountFromItem(entity.func_92059_d());
                entity.field_70170_p.func_72900_e((Entity)entity);
            }
            this.mass += (long)matter;
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 10);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    protected ItemStack createStackedBlock(Block block, int meta) {
        Item item;
        if (block != null && (item = Item.func_150898_a((Block)block)) != null) {
            if (item.func_77614_k()) {
                return new ItemStack(item, 1, meta);
            }
            return new ItemStack(item, 1, 0);
        }
        return null;
    }

    public boolean cleanLiquids(Block block, int x, int y, int z) {
        if (block instanceof IFluidBlock && FORGE_FLUIDS) {
            if (((IFluidBlock)block).canDrain(this.field_145850_b, x, y, z)) {
                if (FALLING_BLOCKS) {
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(this.field_145850_b, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block, this.field_145850_b.func_72805_g(x, y, z));
                    fallingBlock.field_145812_b = 1;
                    fallingBlock.field_70145_X = true;
                    this.field_145850_b.func_72838_d((Entity)fallingBlock);
                }
                ((IFluidBlock)block).drain(this.field_145850_b, x, y, z, true);
                return true;
            }
        } else if (block instanceof BlockLiquid && VANILLA_FLUIDS && this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2)) {
            if (FALLING_BLOCKS) {
                EntityFallingBlock fallingBlock = new EntityFallingBlock(this.field_145850_b, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block, this.field_145850_b.func_72805_g(x, y, z));
                fallingBlock.field_145812_b = 1;
                fallingBlock.field_70145_X = true;
                this.field_145850_b.func_72838_d((Entity)fallingBlock);
            }
            return true;
        }
        return false;
    }

    public boolean cleanFlowingLiquids(Block block, int x, int y, int z) {
        if (VANILLA_FLUIDS && (block == Blocks.field_150358_i || block == Blocks.field_150356_k)) {
            return this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        }
        return false;
    }

    @Override
    public void addInfo(World world, double x, double y, double z, List<String> infos) {
        DecimalFormat format = new DecimalFormat("#.##");
        infos.add("Mass: " + this.mass);
        infos.add("Range: " + format.format(this.getMaxRange()));
        infos.add("Brake Range: " + format.format(this.getBlockBreakRange()));
        infos.add("Horizon: " + format.format(this.getEventHorizon()));
        infos.add("Brake Lvl: " + format.format(this.getBreakStrength()));
    }

    @Override
    public void onScan(World world, double x, double y, double z, EntityPlayer player, ItemStack scanner) {
    }

    public void supress(double amount) {
        this.tmpSuppression = (float)((double)this.tmpSuppression - amount);
        this.tmpSuppression = Math.max(0.0f, this.tmpSuppression);
    }

    public static class PositionWrapper {
        int x;
        int y;
        int z;

        public PositionWrapper(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static class BlockComparitor
    implements Comparator<PositionWrapper> {
        int posX;
        int posY;
        int posZ;

        public BlockComparitor(int x, int y, int z) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }

        @Override
        public int compare(PositionWrapper o1, PositionWrapper o2) {
            return Double.compare(MOMathHelper.distanceSqured(o1.x, o1.y, o1.z, this.posX, this.posY, this.posZ), MOMathHelper.distanceSqured(o2.x, o2.y, o2.z, this.posX, this.posY, this.posZ));
        }
    }
}

