/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap.data;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.api.starmap.IShip;
import matteroverdrive.network.packet.client.starmap.PacketUpdateTravelEvents;
import matteroverdrive.starmap.GalaxyGenerator;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.starmap.data.TravelEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class Galaxy
extends SpaceBody {
    public static final float GALAXY_SIZE_TO_LY = 8000.0f;
    public static final float LY_TO_TICKS = 8.0f;
    public static final float AU_TO_TICKS = 10.0f;
    public static final float PLANET_SYSTEM_SIZE_TO_AU = 100.0f;
    public static float GALAXY_BUILD_TIME_MULTIPLY = 1.0f;
    public static float GALAXY_TRAVEL_TIME_MULTIPLY = 1.0f;
    private long seed;
    private HashMap<Integer, Quadrant> quadrantHashMap;
    private List<TravelEvent> travelEvents;
    private World world;
    private int version;
    private boolean isDirty;

    public Galaxy() {
        this(null);
    }

    public Galaxy(World world) {
        this.init();
        this.world = world;
    }

    public Galaxy(String name, int id, long seed, World world) {
        super(name, id);
        this.init();
        this.setSeed(seed);
        this.world = world;
    }

    private void init() {
        this.quadrantHashMap = new HashMap();
        this.travelEvents = new ArrayList<TravelEvent>();
    }

    public void update(World world) {
        this.manageTravelEvents(world);
        for (Quadrant quadrant : this.getQuadrants()) {
            quadrant.update(world);
        }
    }

    private void manageDirty(World world) {
    }

    private void manageTravelEvents(World world) {
        Iterator<TravelEvent> travelEventIterator = this.travelEvents.iterator();
        while (travelEventIterator.hasNext()) {
            TravelEvent travelEvent = travelEventIterator.next();
            if (travelEvent.isValid(this)) {
                if (!travelEvent.isComplete(world)) continue;
                if (!world.field_72995_K) {
                    Planet to = this.getPlanet(travelEvent.getTo());
                    Planet from = this.getPlanet(travelEvent.getFrom());
                    if (to != null) {
                        to.addShip(travelEvent.getShip());
                        from.func_70296_d();
                        to.func_70296_d();
                        to.onTravelEvent(travelEvent.getShip(), travelEvent.getFrom(), world);
                        MatterOverdrive.packetPipeline.sendToDimention((IMessage)new PacketUpdateTravelEvents(this), world);
                    }
                }
                travelEventIterator.remove();
                continue;
            }
            travelEventIterator.remove();
        }
    }

    public void onSave(File file, World world) {
        this.isDirty = false;
        for (Quadrant quadrant : this.getQuadrants()) {
            quadrant.onSave(file, world);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("Version", this.version);
        NBTTagList quadrantList = new NBTTagList();
        for (Quadrant quadrant : this.getQuadrants()) {
            NBTTagCompound quadrantNBT = new NBTTagCompound();
            quadrant.writeToNBT(quadrantNBT);
            quadrantList.func_74742_a((NBTBase)quadrantNBT);
        }
        tagCompound.func_74782_a("Quadrants", (NBTBase)quadrantList);
        NBTTagList travelEventsList = new NBTTagList();
        for (TravelEvent travelEvent : this.travelEvents) {
            travelEventsList.func_74742_a((NBTBase)travelEvent.toNBT());
        }
        tagCompound.func_74782_a("TravelEvents", (NBTBase)travelEventsList);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        buf.writeInt(this.version);
        buf.writeInt(this.getQuadrants().size());
        for (Quadrant quadrant : this.getQuadrants()) {
            quadrant.writeToBuffer(buf);
        }
        buf.writeInt(this.travelEvents.size());
        for (TravelEvent travelEvent : this.travelEvents) {
            travelEvent.writeToBuffer(buf);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound, GalaxyGenerator generator) {
        super.readFromNBT(tagCompound, generator);
        this.quadrantHashMap.clear();
        this.travelEvents.clear();
        this.version = tagCompound.func_74762_e("Version");
        NBTTagList quadrantList = tagCompound.func_150295_c("Quadrants", 10);
        for (int i = 0; i < quadrantList.func_74745_c(); ++i) {
            Quadrant quadrant = new Quadrant();
            quadrant.readFromNBT(quadrantList.func_150305_b(i), generator);
            this.addQuadrant(quadrant);
            quadrant.setGalaxy(this);
        }
        NBTTagList travelEventsList = tagCompound.func_150295_c("TravelEvents", 10);
        for (int i = 0; i < travelEventsList.func_74745_c(); ++i) {
            this.travelEvents.add(new TravelEvent(travelEventsList.func_150305_b(i)));
        }
    }

    @Override
    public void readFromBuffer(ByteBuf buf) {
        this.quadrantHashMap.clear();
        this.travelEvents.clear();
        this.version = buf.readInt();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Quadrant quadrant = new Quadrant();
            quadrant.readFromBuffer(buf);
            this.addQuadrant(quadrant);
            quadrant.setGalaxy(this);
        }
        int travelEventsSize = buf.readInt();
        for (int i = 0; i < travelEventsSize; ++i) {
            TravelEvent travelEvent = new TravelEvent(buf);
            this.travelEvents.add(travelEvent);
        }
    }

    @Override
    public SpaceBody getParent() {
        return null;
    }

    public Map<Integer, Quadrant> getQuadrantMap() {
        return this.quadrantHashMap;
    }

    public Collection<Quadrant> getQuadrants() {
        return this.quadrantHashMap.values();
    }

    public Quadrant quadrant(int at) {
        return this.quadrantHashMap.get(at);
    }

    public void addQuadrant(Quadrant quadrant) {
        this.quadrantHashMap.put(quadrant.getId(), quadrant);
    }

    public int getQuadrantCount() {
        return this.quadrantHashMap.size();
    }

    public int getStarCount() {
        int count = 0;
        for (Quadrant quadrant : this.getQuadrants()) {
            count += quadrant.getStars().size();
        }
        return count;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public Planet getPlanet(GalacticPosition position) {
        Star star = this.getStar(position);
        if (star != null && position.getPlanetID() >= 0 && star.hasPlanet(position.getPlanetID())) {
            return star.planet(position.getPlanetID());
        }
        return null;
    }

    public Star getStar(GalacticPosition position) {
        Quadrant quadrant = this.getQuadrant(position);
        if (quadrant != null && position.getStarID() >= 0 && quadrant.hasStar(position.getStarID())) {
            return quadrant.star(position.getStarID());
        }
        return null;
    }

    public Quadrant getQuadrant(GalacticPosition position) {
        if (position.getQuadrantID() >= 0 && this.quadrantHashMap.containsKey(position.getQuadrantID())) {
            return this.quadrantHashMap.get(position.getQuadrantID());
        }
        return null;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getVersion() {
        return this.version;
    }

    public int getOwnedSystemCount(EntityPlayer player) {
        int count = 0;
        for (Quadrant quadrant : this.getQuadrants()) {
            for (Star star : quadrant.getStars()) {
                if (star.isClaimed(player) <= 1) continue;
                ++count;
            }
        }
        return count;
    }

    public int getEnemySystemCount(EntityPlayer player) {
        int count = 0;
        for (Quadrant quadrant : this.getQuadrants()) {
            for (Star star : quadrant.getStars()) {
                if (star.isClaimed(player) != 1) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean addTravelEvent(TravelEvent travelEvent) {
        this.travelEvents.add(travelEvent);
        return true;
    }

    public boolean canCompleteTravelEvent(TravelEvent travelEvent) {
        if (travelEvent.getTo() != null) {
            Planet to = this.getPlanet(travelEvent.getTo());
            ItemStack shipStack = travelEvent.getShip();
            if (shipStack != null && to != null) {
                EntityPlayer owner = null;
                UUID ownerID = ((IShip)shipStack.func_77973_b()).getOwnerID(shipStack);
                if (ownerID != null) {
                    owner = this.world.func_152378_a(ownerID);
                }
                return to.canAddShip(shipStack, owner);
            }
        }
        return false;
    }

    public List<TravelEvent> getTravelEvents() {
        return this.travelEvents;
    }

    public void setTravelEvents(List<TravelEvent> travelEvents) {
        this.travelEvents = travelEvents;
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        for (Quadrant quadrant : this.getQuadrants()) {
            if (!quadrant.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void markDirty() {
        this.isDirty = true;
    }
}

