/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.starmap.WeightedRandomSpaceGen;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.starmap.gen.PlanetDwarfGen;
import matteroverdrive.starmap.gen.PlanetGasGiantGen;
import matteroverdrive.starmap.gen.PlanetNormalGen;
import matteroverdrive.starmap.gen.StarGen;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class GalaxyGenerator
implements IConfigSubscriber {
    private Random random = new Random();
    private Random starRandom = new Random();
    private Random planetRandom = new Random();
    private Random starNameRandom = new Random();
    private WeightedRandomSpaceGen<Planet> planetGen = new WeightedRandomSpaceGen(this.random);
    private WeightedRandomSpaceGen<Star> starGen = new WeightedRandomSpaceGen(this.random);
    private float StarPrefixChance = 1.0f;
    private float StarSufixChance = 0.8f;
    private int maxStars = 2304;
    private int minStars = 2048;
    private int minPlanets = 1;
    private int maxPlanets = 4;
    private int quadrantCount = 3;

    public GalaxyGenerator() {
        this.planetGen.addGen(new PlanetGasGiantGen());
        this.planetGen.addGen(new PlanetDwarfGen());
        this.planetGen.addGen(new PlanetNormalGen());
        this.starGen.addGens(StarGen.getStarGens());
    }

    public Galaxy generateGalaxy(String name, int id, long seed, World world) {
        Galaxy galaxy = new Galaxy(name, id, seed, world);
        this.random.setSeed(seed);
        this.generateQuadrants(galaxy, this.quadrantCount);
        return galaxy;
    }

    public void generateStar(Star star, boolean forced, boolean generatePLanets) {
        if (star.isGenerated() || forced) {
            star.clearPlanets();
            this.starRandom.setSeed(star.getSeed());
            Vec3 starPos = this.generateStarPosition(this.starRandom);
            star.setPosition((float)starPos.field_72450_a, (float)starPos.field_72448_b, (float)starPos.field_72449_c);
            this.starGen.getRandomGen(star, this.starRandom).generateSpaceBody(star, this.starRandom);
            if (generatePLanets) {
                this.generatePlanets(star, this.minPlanets + this.random.nextInt(this.maxPlanets - this.minPlanets));
            }
        }
    }

    public void generatePlanet(Planet planet, boolean forced) {
        if (planet.isGenerated() || forced) {
            this.planetRandom.setSeed(planet.getSeed());
            float orbit = this.planetRandom.nextFloat();
            planet.setOrbit(orbit);
            this.planetGen.getRandomGen(planet, this.planetRandom).generateSpaceBody(planet, this.planetRandom);
        }
    }

    public void generateQuadrants(Galaxy galaxy, int size3d) {
        this.starNameRandom.setSeed(galaxy.getSeed());
        List<Star> stars = this.generateStars(this.minStars + this.random.nextInt(this.maxStars - this.minStars));
        Quadrant[] quadrants = new Quadrant[size3d * size3d * size3d];
        float quadrantPosPeace = 2.0f / (float)size3d;
        for (int i = 0; i < quadrants.length; ++i) {
            float z = (float)(i % size3d) * quadrantPosPeace - 1.0f;
            float y = (float)(i / size3d % size3d) * quadrantPosPeace - 1.0f;
            float x = (float)(i / (size3d * size3d)) * quadrantPosPeace - 1.0f;
            quadrants[i] = new Quadrant("Q" + i, i);
            galaxy.addQuadrant(quadrants[i]);
            quadrants[i].setGalaxy(galaxy);
            quadrants[i].setSize(quadrantPosPeace);
            quadrants[i].setPosition(x, y, z);
        }
        for (Star star : stars) {
            for (int i = 0; i < quadrants.length; ++i) {
                if (!(star.getX() >= quadrants[i].getX()) || !(star.getX() < quadrants[i].getX() + quadrantPosPeace) || !(star.getY() >= quadrants[i].getY()) || !(star.getY() < quadrants[i].getY() + quadrantPosPeace) || !(star.getZ() >= quadrants[i].getZ()) || !(star.getZ() < quadrants[i].getZ() + quadrantPosPeace)) continue;
                star.setId(quadrants[i].getStars().size());
                quadrants[i].addStar(star);
                star.setQuadrant(quadrants[i]);
            }
        }
    }

    public List<Star> generateStars(int amount) {
        ArrayList<Star> stars = new ArrayList<Star>(amount);
        List<String> names = StarGen.generateAvailableNames(this.starNameRandom, 18, this.StarPrefixChance, this.StarSufixChance);
        for (int i = 0; i < amount; ++i) {
            Star star = new Star(names.get(i), i);
            int seed = this.random.nextInt();
            star.setSeed(seed);
            stars.add(star);
            this.generateStar(star, true, true);
        }
        return stars;
    }

    public void generatePlanets(Star star, int amount) {
        for (int i = 0; i < amount; ++i) {
            Planet planet = new Planet(star.getName() + " " + i, i);
            planet.setSeed(this.random.nextInt());
            star.addPlanet(planet);
            planet.setStar(star);
            this.generatePlanet(planet, true);
        }
    }

    public void regenerateQuadrants(Galaxy galaxy) {
        for (Quadrant quadrant : galaxy.getQuadrants()) {
            this.regenerateStars(quadrant);
        }
    }

    public void regenerateStars(Quadrant quadrant) {
        for (Star star : quadrant.getStars()) {
            if (star.isClaimed()) continue;
            this.starRandom.setSeed(star.getSeed());
            this.starGen.getRandomGen(star).generateSpaceBody(star, this.starRandom);
            this.regeneratePlanets(star);
        }
    }

    public void regeneratePlanets(Star star) {
        for (Planet planet : star.getPlanets()) {
            this.generatePlanet(planet, true);
        }
    }

    public Vec3 generateStarPosition(Random random) {
        double x = MathHelper.func_151237_a((double)MOMathHelper.nextGaussian(random, 0.0, 0.3333333333333333), (double)-1.0, (double)1.0);
        double y = MathHelper.func_151237_a((double)MOMathHelper.nextGaussian(random, 0.0, 0.3333333333333333), (double)-1.0, (double)1.0);
        double z = MathHelper.func_151237_a((double)MOMathHelper.nextGaussian(random, 0.0, 0.3333333333333333), (double)-1.0, (double)1.0);
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        this.StarPrefixChance = config.config.getFloat("name_prefix_chance", "starmap", 1.0f, 0.0f, 1.0f, "The chance of adding a prefix to a Star System's name");
        this.StarSufixChance = config.config.getFloat("name_suffix_chance", "starmap", 0.8f, 0.0f, 1.0f, "The chance of adding a suffix to a Star System's name");
        this.minStars = config.config.getInt("min_star_count", "starmap", 2048, 0, 512000, "The minimum amount of stars in a galaxy");
        this.maxStars = config.config.getInt("max_star_count", "starmap", 2304, 0, 512000, "The maximum amount of stars in a galaxy");
        this.minPlanets = config.config.getInt("min_planet_count", "starmap", 1, 0, 8, "The minimum amount of planets per star system");
        this.maxPlanets = config.config.getInt("max_planet_count", "starmap", 4, 0, 8, "The maximum amount of planets pre star system");
        this.quadrantCount = config.config.getInt("quadrant_count", "starmap", 3, 1, 6, "The amount of quadrants the galaxy should be divided into. The amount is cubed. x ^ 3. For example 3 ^ 3 = 27 quadrants.");
    }

    public WeightedRandomSpaceGen<Planet> getPlanetGen() {
        return this.planetGen;
    }

    public WeightedRandomSpaceGen<Star> getStarGen() {
        return this.starGen;
    }

    public Random getPlanetRandom() {
        return this.planetRandom;
    }

    public Random getStarRandom() {
        return this.starRandom;
    }
}

