/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.init.MatterOverdriveBioticStats;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSendAndroidAnction
extends PacketAbstract {
    public static final int ACTION_SHIELD = 0;
    public static final int ACTION_CLOAK = 1;
    public static final int ACTION_NIGHTVISION = 2;
    int action = 0;
    boolean state;
    int options;

    public PacketSendAndroidAnction() {
    }

    public PacketSendAndroidAnction(int action, boolean state) {
        this(action, state, 0);
    }

    public PacketSendAndroidAnction(int action, boolean state, int options) {
        this.action = action;
        this.state = state;
        this.options = options;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = buf.readInt();
        this.state = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action);
        buf.writeBoolean(this.state);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketSendAndroidAnction> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketSendAndroidAnction message, MessageContext ctx) {
            AndroidPlayer androidPlayer = AndroidPlayer.get(player);
            if (androidPlayer != null) {
                if (message.action == 0) {
                    MatterOverdriveBioticStats.shield.setShield(androidPlayer, message.state);
                } else if (message.action == 1) {
                    MatterOverdriveBioticStats.cloak.setActive(androidPlayer, androidPlayer.getUnlockedLevel(MatterOverdriveBioticStats.cloak), message.state);
                } else if (message.action == 2) {
                    MatterOverdriveBioticStats.nightvision.setActive(androidPlayer, androidPlayer.getUnlockedLevel(MatterOverdriveBioticStats.nightvision), message.state);
                }
            }
            return null;
        }
    }
}

