/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.weapon.PhaserRifle;
import matteroverdrive.network.packet.AbstractBiPacketHandler;
import matteroverdrive.network.packet.PacketAbstract;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;

public class PacketFirePhaserRifle
extends PacketAbstract {
    private int seed;
    private boolean isAiming;
    private int sender;
    private long timestamp;
    private Vec3 position;
    private Vec3 direction;

    public PacketFirePhaserRifle() {
    }

    public PacketFirePhaserRifle(boolean isAiming, int sender, int seed, Vec3 pos, Vec3 dir) {
        this.isAiming = isAiming;
        this.sender = sender;
        this.seed = seed;
        this.position = pos;
        this.direction = dir;
    }

    public void fromBytes(ByteBuf buf) {
        this.isAiming = buf.readBoolean();
        this.sender = buf.readInt();
        this.seed = buf.readInt();
        this.timestamp = buf.readLong();
        this.position = Vec3.func_72443_a((double)buf.readDouble(), (double)buf.readDouble(), (double)buf.readDouble());
        this.direction = Vec3.func_72443_a((double)buf.readDouble(), (double)buf.readDouble(), (double)buf.readDouble());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isAiming);
        buf.writeInt(this.sender);
        buf.writeInt(this.seed);
        buf.writeLong(System.currentTimeMillis());
        buf.writeDouble(this.position.field_72450_a);
        buf.writeDouble(this.position.field_72448_b);
        buf.writeDouble(this.position.field_72449_c);
        buf.writeDouble(this.direction.field_72450_a);
        buf.writeDouble(this.direction.field_72448_b);
        buf.writeDouble(this.direction.field_72449_c);
    }

    public static class BiHandler
    extends AbstractBiPacketHandler<PacketFirePhaserRifle> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketFirePhaserRifle message, MessageContext ctx) {
            Entity entity;
            if (player.func_145782_y() != message.sender && (entity = player.field_70170_p.func_73045_a(message.sender)) != null && entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70694_bm() != null && ((EntityPlayer)entity).func_70694_bm().func_77973_b() instanceof PhaserRifle) {
                MatterOverdriveItems.phaserRifle.onClientFire(((EntityPlayer)entity).func_70694_bm(), (EntityPlayer)entity, message.isAiming, message.seed, message.position, message.direction);
            }
            return null;
        }

        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketFirePhaserRifle message, MessageContext ctx) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == MatterOverdriveItems.phaserRifle && MatterOverdriveItems.phaserRifle.canFire(player.func_70694_bm(), player.field_70170_p)) {
                MatterOverdriveItems.phaserRifle.onServerFire(player.func_70694_bm(), player, message.isAiming, message.seed, (int)(System.currentTimeMillis() - message.timestamp), message.position, message.direction);
                MatterOverdrive.packetPipeline.sendToAllAround((IMessage)message, player, 128.0);
            }
            return null;
        }
    }
}

