/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client.starmap;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PacketUpdatePlanet
extends PacketAbstract {
    int planetID;
    int starID;
    int quadrantID;
    boolean updateHomeworlds;
    NBTTagCompound planetData;

    public PacketUpdatePlanet() {
    }

    public PacketUpdatePlanet(Planet planet) {
        this(planet, false);
    }

    public PacketUpdatePlanet(Planet planet, boolean updateHomeworlds) {
        this.planetID = planet.getId();
        this.starID = planet.getStar().getId();
        this.quadrantID = planet.getStar().getQuadrant().getId();
        this.planetData = new NBTTagCompound();
        this.updateHomeworlds = updateHomeworlds;
        planet.writeToNBT(this.planetData);
    }

    public void fromBytes(ByteBuf buf) {
        this.planetID = buf.readInt();
        this.starID = buf.readInt();
        this.quadrantID = buf.readInt();
        this.updateHomeworlds = buf.readBoolean();
        this.planetData = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.planetID);
        buf.writeInt(this.starID);
        buf.writeInt(this.quadrantID);
        buf.writeBoolean(this.updateHomeworlds);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.planetData);
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketUpdatePlanet> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketUpdatePlanet message, MessageContext ctx) {
            Galaxy galaxy = GalaxyClient.getInstance().getTheGalaxy();
            if (galaxy != null) {
                Star star;
                Quadrant quadrant = galaxy.quadrant(message.quadrantID);
                if (quadrant != null && (star = quadrant.star(message.starID)) != null) {
                    Planet planet = star.planet(message.planetID);
                    if (planet == null) {
                        planet = new Planet();
                        planet.readFromNBT(message.planetData, null);
                        star.addPlanet(planet);
                    } else {
                        planet.readFromNBT(message.planetData, null);
                    }
                    this.notifyChange(planet);
                }
                if (message.updateHomeworlds) {
                    GalaxyClient.getInstance().loadClaimedPlanets();
                }
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void notifyChange(Planet planet) {
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiStarMap) {
                GuiStarMap guiStarMap = (GuiStarMap)Minecraft.func_71410_x().field_71462_r;
                guiStarMap.onPlanetChange(planet);
            }
        }
    }
}

