/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.handler.MatterEntry;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import net.minecraft.entity.player.EntityPlayer;

public class PacketUpdateMatterRegistry
extends PacketAbstract {
    private static Map<String, MatterEntry> entries;

    public PacketUpdateMatterRegistry() {
    }

    public PacketUpdateMatterRegistry(Map<String, MatterEntry> entries) {
        PacketUpdateMatterRegistry.entries = entries;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        entries = new HashMap<String, MatterEntry>();
        for (int i = 0; i < size; ++i) {
            int keySize = buf.readInt();
            char[] keyChars = new char[keySize];
            for (int c = 0; c < keySize; ++c) {
                keyChars[c] = buf.readChar();
            }
            String key = String.copyValueOf(keyChars);
            entries.put(key, new MatterEntry(key, buf.readInt(), buf.readByte()));
        }
    }

    public void toBytes(ByteBuf buf) {
        int size = entries.size();
        buf.writeInt(size);
        for (Map.Entry<String, MatterEntry> entry : entries.entrySet()) {
            int keySize = entry.getKey().length();
            buf.writeInt(keySize);
            char[] keyChars = entry.getKey().toCharArray();
            for (int c = 0; c < keySize; ++c) {
                buf.writeChar((int)keyChars[c]);
            }
            buf.writeInt(entry.getValue().getMatter());
            buf.writeByte((int)entry.getValue().getType());
        }
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketUpdateMatterRegistry> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketUpdateMatterRegistry message, MessageContext ctx) {
            MatterOverdrive.matterRegistry.setEntries(entries);
            MatterOverdrive.matterRegistry.hasComplitedRegistration = true;
            return null;
        }
    }
}

