/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.fx.AndroidTeleportParticle;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import matteroverdrive.proxy.ClientProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PacketSpawnParticle
extends PacketAbstract {
    String particleType;
    double x;
    double y;
    double z;
    int count;
    int blending;

    public PacketSpawnParticle() {
    }

    public PacketSpawnParticle(String particleType, double x, double y, double z, int count, int blending) {
        this.particleType = particleType;
        this.x = x;
        this.y = y;
        this.z = z;
        this.count = count;
        this.blending = blending;
    }

    public void fromBytes(ByteBuf buf) {
        this.particleType = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.count = buf.readInt();
        this.blending = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.particleType);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.count);
        buf.writeByte(this.blending);
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketSpawnParticle> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketSpawnParticle message, MessageContext ctx) {
            this.spawnParticle(player.field_70170_p, message);
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void spawnParticle(World world, PacketSpawnParticle message) {
            AndroidTeleportParticle particle = null;
            if (message.particleType.equalsIgnoreCase("teleport")) {
                particle = new AndroidTeleportParticle(world, message.x, message.y, message.z);
            }
            if (particle != null) {
                ClientProxy.renderHandler.getRenderParticlesHandler().addEffect(particle, RenderParticlesHandler.Blending.values()[message.blending]);
            }
        }
    }
}

