/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import matteroverdrive.tile.TileEntityMachinePatternMonitor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketPatternMonitorSync
extends TileEntityUpdatePacket {
    HashSet<BlockPosition> positions;

    public PacketPatternMonitorSync() {
    }

    public PacketPatternMonitorSync(TileEntityMachinePatternMonitor monitor) {
        super(monitor);
        this.positions = monitor.getDatabases();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int size = buf.readInt();
        this.positions = new HashSet(size);
        for (int i = 0; i < size; ++i) {
            this.positions.add(new BlockPosition(buf.readInt(), buf.readInt(), buf.readInt()));
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.positions.size());
        for (BlockPosition position : this.positions) {
            buf.writeInt(position.x);
            buf.writeInt(position.y);
            buf.writeInt(position.z);
        }
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketPatternMonitorSync> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketPatternMonitorSync message, MessageContext ctx) {
            TileEntity entity = message.getTileEntity(player.field_70170_p);
            if (entity != null && entity instanceof TileEntityMachinePatternMonitor) {
                TileEntityMachinePatternMonitor monitor = (TileEntityMachinePatternMonitor)entity;
                monitor.setDatabases(message.positions);
                monitor.forceSearch(true);
            }
            return null;
        }
    }
}

